/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.merge.ChangesViewConflictsBannerCustomizer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/merge/ChangesViewConflictsBanner;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "message", "", "Lorg/jetbrains/annotations/Nls;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;)V", "banner", "Lcom/intellij/ui/InlineBanner;", "showCloseButton", "show", "", "close", "", "intellij.platform.vcs.impl"})
public final class ChangesViewConflictsBanner
extends BorderLayoutPanel {
    @NotNull
    private final InlineBanner banner;

    public ChangesViewConflictsBanner(@NotNull String message, @NotNull ChangesListView changesView) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)changesView, (String)"changesView");
        this.banner = new InlineBanner(message, EditorNotificationPanel.Status.Warning);
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        Project project = changesView.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        for (ChangesViewConflictsBannerCustomizer action : ChangesViewConflictsBannerCustomizer.EP_NAME.getExtensions((AreaInstance)project)) {
            if (!action.isAvailable(changesView)) continue;
            this.banner.addAction(action.getName(), action.getIcon(), action.createAction(changesView));
        }
        this.addToCenter((Component)this.banner);
    }

    @NotNull
    public final ChangesViewConflictsBanner showCloseButton(boolean show) {
        this.banner.showCloseButton(show);
        return this;
    }

    public final void close() {
        block3: {
            Container parent;
            Container container = parent = this.getParent();
            if (container != null) {
                container.remove((Component)((Object)this));
            }
            Container container2 = parent;
            if (container2 != null) {
                container2.doLayout();
            }
            Container container3 = parent;
            if (container3 != null) {
                container3.revalidate();
            }
            Container container4 = parent;
            if (container4 == null) break block3;
            container4.repaint();
        }
    }
}

