/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.update.GitSubmoduleUpdaterKt;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/update/GitSubmoduleUpdater;", "Lgit4idea/update/GitUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "git", "Lgit4idea/commands/Git;", "parentRepository", "Lgit4idea/repo/GitRepository;", "repository", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commands/Git;Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/vcs/update/UpdatedFiles;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGit", "()Lgit4idea/commands/Git;", "isSaveNeeded", "", "doUpdate", "Lgit4idea/update/GitUpdateResult;", "isUpdateNeeded", "branchPair", "Lgit4idea/branch/GitBranchPair;", "toString", "", "intellij.vcs.git"})
public final class GitSubmoduleUpdater
extends GitUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private final Git git;
    @NotNull
    private final GitRepository parentRepository;
    @NotNull
    private final GitRepository repository;

    public GitSubmoduleUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository parentRepository, @NotNull GitRepository repository2, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)parentRepository, (String)"parentRepository");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)updatedFiles, (String)"updatedFiles");
        super(project, git, repository2, progressIndicator, updatedFiles);
        this.project = project;
        this.git = git;
        this.parentRepository = parentRepository;
        this.repository = repository2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Git getGit() {
        return this.git;
    }

    @Override
    public boolean isSaveNeeded() {
        return true;
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        try {
            GitCommandResult gitCommandResult = this.git.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> GitSubmoduleUpdater.doUpdate$lambda$0(this)));
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
            GitCommandResult result2 = gitCommandResult;
            if (result2.success()) {
                return GitUpdateResult.SUCCESS;
            }
            GitSubmoduleUpdaterKt.access$getLOG$p().info("Submodule update failed for submodule [" + this.repository + "] called from parent root [" + this.parentRepository + "]: " + result2.getErrorOutputAsJoinedString());
            return GitUpdateResult.ERROR;
        }
        catch (ProcessCanceledException pce) {
            return GitUpdateResult.CANCEL;
        }
    }

    @Override
    public boolean isUpdateNeeded(@NotNull GitBranchPair branchPair) {
        Intrinsics.checkNotNullParameter((Object)branchPair, (String)"branchPair");
        return true;
    }

    @NotNull
    public String toString() {
        return "Submodule updater";
    }

    private static final GitLineHandler doUpdate$lambda$0(GitSubmoduleUpdater this$0) {
        GitLineHandler handler = new GitLineHandler(this$0.project, this$0.parentRepository.getRoot(), GitCommand.SUBMODULE);
        String[] stringArray = new String[]{"update", "--recursive"};
        handler.addParameters(stringArray);
        handler.endOptions();
        handler.addRelativeFiles(CollectionsKt.listOf((Object)this$0.repository.getRoot()));
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        return handler;
    }
}

