/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;

public final class WorkLocationPlan
extends AIObject {
    private static final Logger logger = Logger.getLogger(WorkLocationPlan.class.getName());
    public static final String TAG = "workLocationPlan";
    private WorkLocation workLocation;
    private GoodsType goodsType;

    public WorkLocationPlan(AIMain aiMain, WorkLocation workLocation, GoodsType goodsType) {
        super(aiMain);
        this.workLocation = workLocation;
        this.goodsType = goodsType;
        this.setInitialized();
    }

    @Override
    public void setInitialized() {
        this.initialized = this.getWorkLocation() != null && this.getGoodsType() != null;
    }

    public WorkLocation getWorkLocation() {
        return this.workLocation;
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public void setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
    }

    public boolean isFoodPlan() {
        return this.goodsType.isFoodType();
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[').append(this.getId()).append(' ').append(this.goodsType.getSuffix()).append(" at ").append(this.workLocation.getId()).append(']');
        return sb.toString();
    }
}

