/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtlsHandshakeMessageFragmentSerializer
extends HandshakeMessageSerializer<DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DtlsHandshakeMessageFragment fragment;

    public DtlsHandshakeMessageFragmentSerializer(DtlsHandshakeMessageFragment message, ProtocolVersion version) {
        super(message, version);
        this.fragment = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        this.writeMessageSequence();
        this.writeFragmentOffset();
        this.writeFragmentLength();
        this.appendBytes((byte[])this.fragment.getContent().getValue());
        return this.getAlreadySerialized();
    }

    private void writeMessageSequence() {
        this.appendInt((Integer)this.fragment.getMessageSeq().getValue(), 2);
        LOGGER.debug("SequenceNumber: " + this.fragment.getMessageSeq().getValue());
    }

    private void writeFragmentOffset() {
        this.appendInt((Integer)this.fragment.getFragmentOffset().getValue(), 3);
        LOGGER.debug("FragmentOffset: " + this.fragment.getFragmentOffset().getValue());
    }

    private void writeFragmentLength() {
        this.appendInt((Integer)this.fragment.getFragmentLength().getValue(), 3);
        LOGGER.debug("FragmentLength: " + this.fragment.getFragmentLength().getValue());
    }
}

