/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public class OrdinalGroupFactory {
    private final List<OrdinalGroup> groups = new ArrayList<OrdinalGroup>();

    public final OrdinalGroup group(int ordinal) {
        this.growTo(ordinal);
        return this.groups.get(ordinal);
    }

    public List<OrdinalGroup> getAllGroups() {
        return this.groups;
    }

    public void reset() {
        this.groups.clear();
    }

    private void growTo(int ordinal) {
        for (int i = this.groups.size(); i <= ordinal; ++i) {
            this.groups.add(new OrdinalGroup(i, this.previous(i)));
        }
    }

    @Nullable
    private OrdinalGroup previous(int i) {
        if (i == 0) {
            return null;
        }
        return this.groups.get(i - 1);
    }
}

