# Power Descriptions
Note that every power, unless otherwise specified, is affected by Intelligence scaling and Nether Attunement scaling. Intelligence scaling is normalized at 10 with +/- 5% per point in either direction—-Intelligence 9 makes powers 95% as effective, Intelligence 12 makes powers 110% as effective, and so on. 

A (C) after a power name indicates that it can be maintained by concentration.

All powers have a kCal cost equal to (Difficulty of power * 5) times a randomized factor from 0.3 to 1.7. This applies when the power is first used and when the power is maintained (if a concentration power).

# Biokinesis
**Note**: No biokinetic powers have a target listed because they only affect the psion. 

**Passive Power: Efficient System**: Reduces hunger, thirst, and metabolic burn rate by 3% plus 1.5% times the highest single biokinetic power the psion knows.

## Overcome Pain (C)
*Difficulty*: 1<br />
*Duration*: 5 minutes to 21 minutes 40 seconds, plus 20 to 75 seconds per level<br />
*Stamina Cost*: 1750, minus 75 per level to a minimum of 800<br />
*Channeling Time*: 125 moves, minus 7 moves per level to a minimum of 50<br />
*Effects*: Adds pkill to the psion, scaling every 4 levels.<br /> 
Level | Pkill Min | Pkill Tick | Pkill Max
——-|——-|——-|———
0 | 1 | 12 | 15
4 | 2 | 10 | 30
8 | 3 | 10 | 50
12| 4 | 8 | 75
16| 5 | 8 | 100
20| 6 | 6 | 130
This is natural painkiller and so has natural effects (reduces speed slightly)<br />
*Prerequisites*: Starting power.

## Physical Enhancement (C)
*Difficulty*: 2<br />
*Duration*: 90 seconds to 7 minutes 30 seconds, plus 15 to 90 seconds per level<br />
*Stamina Cost*: 3500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 120 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Adds +1 Strength and +1 Dexterity, with an additional point of each every 5 power levels.  It also makes the psion immune to Weakening Poison.<br />
*Prerequisites*: Starting power.<br />

## Oxygen Absorption 
*Difficulty*: 2<br />
*Duration*: 3 minutes to 9 minutes, plus 36 to 72 seconds per level<br />
*Stamina Cost*: 2500, minus 85 per level to a minimum of 1200<br />
*Channeling Time*: 70 moves, minus 6 moves per level to a minimum of 25<br />
*Effects*: Allows the psion to breathe underwater.  This is the same as a rebreather, so it reduces the hidden oxygen stat by a significant amount, making Stamina recovery harder.<br />
*Prerequisites*: Physical Enhancement 4, Overcome Pain 3.<br />

## Burst of Speed 
*Difficulty*: 3<br />
*Duration*: Instant<br />
*Stamina Cost*: 3000, minus 190 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 4.5 moves per level to a minimum of 15<br />
*Effects*: Dash up to 1 square plus 1 square per two levels, to a maximum of 12 squares.  This is normal movement and will subject you to tile hazards.<br />
*Prerequisites*: Physical Enhancement 9 *or* Enhance Mobility 5.<br />

## Flexibility 
*Difficulty*: 3<br />
*Duration*: 2 to 5 seconds<br />
*Stamina Cost*: 2500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 50 moves, minus 2.5 moves per level to a minimum of 15<br />
*Effects*: Greatly increases the psion’s reaction (2x), block (1.2x) and crawl (1.5) limb scores, as well as rendering them immune to being grabbed and making it easier to recover from being downed.  It reduces fall damage by 20% plus 2% per level.<br />
*Prerequisites*: Physical Enhancement 6<br />

## Hardened Skin 
*Difficulty*: 4
*Duration*: 45 to 90 seconds, plus 8 to 15 seconds per level.<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 8.5 moves per level to a minimum of 50.<br />
*Effects*: Increases piercing armor by 3, bashing armor by 6, and cutting armor by 4.  Also makes the psion immune to bleeding from wounds received during its duration (previous bleeding is unaffected) and reduces incoming pain by 2% per level.<br />
*Prerequisites*: Overcome Pain 6 *or* Physical Enhancement 8, Flexibility 7 *or* Temperature Adaptability 6.<br />

## Adrenaline Trigger 
*Difficulty*: 4<br />
*Duration*: 15 minutes<br />
*Stamina Cost*: 3500, minus 165 per level to a minimum of 1800<br />
*Channeling Time*: 100 moves, minus 5.5 moves per level to a minimum of 35<br />
*Effects*: Cause an adrenaline surge. This provides a burst of speed and strength and high tolerance for pain for the duration but the psion will crash when the surge ends.<br />
*Prerequisites*: Overcome Pain 7, Burst of Speed 8 *or* Enhance Mobility 6. 

## Temperature Adaptability (C) 
*Difficulty*: 4<br />
*Duration*: 5 minutes to 10 minutes, plus 3 minutes to 6 minutes per level<br />
*Stamina Cost*: 3500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 250 moves, minus 8.5 moves per level to a minimum of 150<br />
*Effects*: Increases temperature tolerance in both directions by 15 degrees plus 7.5 degrees per level.<br />
*Prerequisites*: Oxygen Absorption 5, Physical Enhancement 9 *or* Metabolic Hyperefficiency 6<br />

## Enhance Mobility (C) 
*Difficulty*: 5<br />
*Duration*: 5 minutes to 15 minutes, plus 45 seconds to 120 seconds per level<br />
*Stamina Cost*: 4500, minus 150 per level to a minimum of 2500<br />
*Channeling Time*: 275 moves, minus 15 moves per level to a minimum of 50.<br />
*Effects*: Reduces encumbrance on every body part, improving every 4 levels.  Other than -2 at level 0 through 3, encumbrance reduction is equal to power threshold level: -4 from levels 4 to 7, -8 from levels 8 to 11, and so on.<br />
*Prerequisites*: Overcome Pain 4,  Heightened Reflexes 6 *or* Flexibility 9, Burst of Speed 10 *or* Combat Dance 4 *or* Physical Enhancement 10.<br />

## Hammerhand (C) 
*Difficulty*: 5<br />
*Duration*: 30 minutes to 90 minutes, plus 7 minutes 30 seconds to 12 minutes 30 seconds per level.<br />
*Stamina Cost*: 4500, minus 225 per level to a minimum of 2250<br />
*Channeling Time*: 350 moves, minus 12.5 moves per level to a minimum of 150<br />
*Effects*: Allows the psion to replicate a number of common tools with their own body: it provides the Bolt Turning 1, Screw Driving 1, Hammering 3, Fine Hammering 1, Soft Hammering 1, Wood Chiseling 1, Prying 2, and Nail Prying 1 qualities.<br />
*Prerequisites*: Physical Enhancement 6, Hardened Skin 6<br />

## Heightened Reflexes (C) 
*Difficulty*: 6<br />
*Duration*: 90 seconds to 7 minutes 30 seconds, plus 15 to 90 seconds per level<br />
*Stamina Cost*: 5500, minus 205 per level to a minimum of 2250<br />
*Channeling Time*: 175 moves, minus 5.5 moves per level to a minimum of 100<br />
*Effects*: Adds +1 Perception and +5 Speed, plus 1 Perception per 5 levels and plus 1 Speed per level (to a maximum bonus of +30 speed).<br />
*Prerequisites*: Flexibility 8 *or* Burst of Speed 8, Physical Enhancement 6, Adrenaline Trigger 6<br />

## Sealed System
*Difficulty*: 7<br />
*Duration*: 60 seconds to 5 minutes, plus 8 to 25 seconds per level<br />
*Stamina Cost*: 5500, minus 175 per level to a minimum of 2750<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 100<br />
*Effects*: Prevents the psion from having to breath and seals off their body against outside danger.  They become immune to the Smoke, Teargas, Boomer Bile, Mi-go Atmosphere, Fetid Goop, Relaxation Gas, Triffid Pollen, Fungal Spores, Dermatik parasitization, Poison, and Bad Poison effects, as well as electrical damage.  They have no scent and receive 75% less radiation. Finally, their wounds stop bleeding and wounds received while the power is in effect will not bleed.<br />
*Prerequisites*: Hardened Skin 9 *or* Oxygen Absorption 9, Temperature Adaptability 10 *or* Hammerhand 7<br />

## Metabolic Hyperefficiency (C) 
*Difficulty*: 7<br />
*Duration*: 45 minutes to 112 minutes and 30 seconds, plus 4 minutes 10 seconds to 8 minutes 20 seconds per level<br />
*Stamina Cost*: 8000, minus 250 per level to a minimum of 4000<br />
*Channeling Time*: 250 moves, minus 13 moves per level to a minimum of 50<br />
*Effects*: Greatly increases the psion’s metabolic efficiency.  Hunger, thirst, fatigue grow 25% more slowly and the basal metabolic rate is reduced by 25%.  All of these bonuses increase by 2% per level to a maximum of 70% increase.<br />
*Prerequisites*: Temperature Adaptability 8, Adrenaline Trigger 6 *or* Physical Enhancement 12<br />

## Combat Dance
*Difficulty*: 8<br />
*Duration*: 40 seconds to 3 minutes and 20 seconds, plus 5 to 11 seconds per level<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2250<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 40<br />
*Effects*: Provides a myriad of combat bonuses. Move cost is reduced by 10% and recoil reduced by 30.  In addition, pain is reduced by 3% per power level, and melee damage and attack speed are increased by 2% per power level. The psion is immune to the Stunned and Dazed effects.<br />
*Prerequisites*: Heightened Reflexes 10, Physical Enhancement 10, Adrenaline Trigger 9 *or* Burst of Speed 6<br />

## Perfected Motion
*Difficulty*: 9<br />
*Duration*: 5 seconds to 30 seconds, plus 0.5 to 1.1 seconds per level<br />
*Stamina Cost*: 8000, minus 175 per level to a minimum of 3500<br />
*Channeling Time*: 75 moves, minus 4 moves per level to a minimum of 15<br />
*Effects*: Increases the psion’s movement rate to an inhuman degree.  Move cost is reduced by 50% plus 1.5% per level, to a maximum of 96% reduced move cost. The psion is also immune to slippery terrain.<br />
*Prerequisites*: Combat Dance 6, Burst of Speed 12<br />  

## Hurricane Blow
*Difficulty*: 10<br />
*Duration*: 1 second<br />
*Stamina Cost*: 4500, minus 75 per level to a minimum of 2500<br />
*Channeling Time*: 65 moves, minus 3 moves per level to a minimum of 15<br />
*Effects*: Allows the psion to strike multiple times in less than a second.  Speed is increased by 400 plus 75 per power level and the psion attacks 25% faster and does 10% more melee damage plus 1.5% per power level, but cannot use ranged attacks or other psionic powers, and the power ends immediately if the psion moves.<br />
*Prerequisites*: Combat Dance 10, Reflex Enhance 14 *or* Adrenaline Trigger 12<br />

# Clairsentience

**Passive Power: Psionic Senses**: Enhances mundane senses, allowing farther overmap sight, enhanced hearing, and the ability to always know the exact time even without a watch.  The psion can also sense Nether creaturs within a radius of 2 squares plus 1.5 squares times the level of the psion's highest-level clairsentience power.

## Night Eyes (C)
*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 12 minutes to 23 minutes 20 seconds, plus 6 minutes 12 seconds to 13 minutes 30 seconds minutes per level<br />
*Stamina Cost*: 1500, minus 65 per level to a minimum of 500<br />
*Channeling Time*: 50 moves, minus 2 moves per level to a minimum of 20<br />
*Effects*: Allows the psion to see in the dark.  This is a range multiplier on base night vision, beginning at 2x normal night vision, that increases every 3 power levels: 4x normal at level 6, 6x normal at level 9, and so on.<br />
*Prerequisites*: Starting power<br />

## Speed Reader (C)
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 4 minutes 50 seconds to 16 minutes 20 seconds, plus 2 minutes 30 seconds to 4 minutes 30 seconds minutes per level<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 1000<br />
*Channeling Time*: 500 moves, minus 12 moves per level to a minimum of 250<br />
*Effects*: Increases the psion's ability to read and retain information. The psion reads 33% faster and gains 0.15% additional XP per reading increment per power level.<br />
*Prerequisites*: Starting power<br />

## Premonition (C)
*Difficulty*: 2<br />
*Target*: All enemies within 2 squares per power level<br />
*Duration*: 2 minutes to 8 minutes 10 seconds, plus 45 seconds to 1 minutes 15 seconds minutes per level<br />
*Stamina Cost*: 2250, minus 85 per level to a minimum of 850<br />
*Channeling Time*: 85 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Reveal the location of all enemies within the power's range. Premonition does not reveal exactly what sort of enemy is out there, only that something is.<br />
*Prerequisites*: None<br />

## Discern Weakness
*Difficulty*: 3<br />
*Target*: One enemy within 1 square plus 1.2 squares per power level<br />
*Duration*: 13 to 30 seconds, plus 1.5 to 2.5 seconds per level<br />
*Stamina Cost*: 3000, minus 125 per level to a minimum of 1250<br />
*Channeling Time*: 150 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Reduce the armor values of the target, causing them to take +1 damage per two power levels on any hit. Due to engine limitations, at the moment this power only works on NPCs.<br />
*Prerequisites*: Night Eyes 4, Premonition 4<br />

## Aura Sight (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 10 minutes and 50 seconds to 18 minutes and 50 seconds, plus 1 minute 30 seconds to 3 minutes 10 seconds per level<br />
*Stamina Cost*: 4000, minus 115 per level to a minimum of 1750<br />
*Channeling Time*: 300 moves, minus 8.5 moves per level to a minimum of 100<br />
*Effects*: Reveal others' emotions, increasing the psion's chance to persuade them or lie to them by 1% per power level, to a maximum of 20%.<br />
*Prerequisites*: Premonition 5, Discern Weakness 5<br />

## Radiation Sense
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: Instant or 30 minutes to 1 hour 15 minutes<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 250 moves, minus 4.5 moves per level to a minimum of 100<br />
*Effects*: Sense nearby radiation, either on the psion themselves (instant duration) or in their surrounding environment.  Radiation sense on the psion provides an idea of how much radiation they are suffering from; radiation sense on the environment reveals only its presence or absense.<br />
*Prerequisites*: Special (must be studied from notes)<br />

## Marksman's Eye (C)
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 3 minutes and 30 seconds to 10 minutes and 40 seconds, plus 8 seconds to 25 seconds per level<br />
*Stamina Cost*: 4500, minus 135 per level to a minimum of 2250<br />
*Channeling Time*: 200 moves, minus 6 moves per level to a minimum of 125<br />
*Effects*: Increase the psion's range with ranged weapons by 1 square per 2 power levels and reduces weapon dispersion by 2.5% per power level.<br />
*Prerequisites*: Discern Weakness 7<br />

## Clairyovance
*Difficulty*: 5<br />
*Target*: 2 squares plus 1.2 squares per power level to a maximum of 80 squares, with an area of effect of 1.5 squares plus 1.2 squares per power level to a maximum of 50 squares<br />
*Duration*: 2.5 to 15 seconds, plus 0.5 seconds to 1.1 seconds per power level<br />
*Stamina Cost*: 6000, minus 195 per level to a minimum of 3500<br />
*Channeling Time*: 1000 moves, minus 25 moves per level to a minimum of 500<br />
*Effects*: Reveal the entire area of effect as though the psion were standing and able to see all of it at once. When the power duration expires, the effect will gradually fade over the next few seconds.<br />
*Prerequisites*: Premonition 6, Aura Sight 6 *or* Night Eyes 10<br />

## Combat Sense (C)
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 2 minutes to 7 minutes and 30 seconds, plus 9 seconds to 17 seconds per level<br />
*Stamina Cost*: 5500, minus 145 per level to a minimum of 2750<br />
*Channeling Time*: 150 moves, minus 9 moves per level to a minimum of 70<br />
*Effects*: Gaze a short time into the future to predict enemy movements.  Grants +1 bonus dodge and block, +1 addition bonus dodge and block per 6 power levels, prevents the psion from being grabbed, and applies the UNCANNY_DODGE flag.<br />
*Prerequisites*: Premonition 10 *or* Speed Reader 10 *or* Discern Weakness 6, Clairyovance 6<br />

## Intuitive Artisan (C)
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 20 minutes and 15 seconds to 45 minutes, plus 4 minutes and 10 seconds to 10 minutes per level<br />
*Stamina Cost*: 6500, minus 145 per level to a minimum of 3250<br />
*Channeling Time*: 500 moves, minus 3 moves per level to a minimum of 300<br />
*Effects*: Enter a trance and improve the psion's ability to craft, increasing crafting speed by 4% and skill level by 0.25 per 4 power levels. However, the psion's vision will be limited and their movement speed will be slowed while in the trance.<br />
*Prerequisites*: Speed Reader 8, Discern Weakness 4, Premonition 6<br />

## One Perfect Shot
*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 10 seconds or until a shot is fired<br />
*Stamina Cost*: 7500, minus 160 per level to a minimum of 5000<br />
*Channeling Time*: 100 moves, minus 4.5 moves per level to a minimum of 35<br />
*Effects*: Reduce weapon dispersion to 0 and increase ranged damage by 150% for a single attack.<br />
*Prerequisites*: Marksman's Eye 9<br />

## Satellite View
*Difficulty*: 7<br />
*Target*: Overmap between 4 and 11 squares plus 0.5 to 1 per power level <br />
*Duration*: Instant<br />
*Stamina Cost*: 9000<br />
*Channeling Time*: 60 seconds<br />
*Effects*: The psion gains a bird's eye (or mole's eye) view of surrouding terrain, revealing all locations within the power's radius.<br />
*Prerequisites*: Clairvoyance 8, Premonition 6 *or* Aura Sight 6<br />

## Clarity (C)
*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: 2 minutes and 30 seconds to 7 minutes and 30 seconds, plus 12 seconds to 25 seconds per level<br />
*Stamina Cost*: 8000, minus 150 per level to a minimum of 4500<br />
*Channeling Time*: 75 moves, minus 3.5 moves per level to a minimum of 25<br />
*Effects*: The psion prevents anything from interfering with their senses, becoming immune to being Dazed, Stunned (either physically or psionically), blinded, made to hallucinate, deafened, Blinding Venom, and also cannot get high or drunk.<br />
*Prerequisites*: Night Eyes 10, Speed Reader 8 *or* Aura Sight 8 *or* Combat Sense 5<br />

## Prescient Tactician (C)
*Difficulty*: 9<br />
*Target*: All allies within 20 squares<br />
*Duration*: 1 to 3 minutes, plus 9 seconds to 23 seconds per level<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 4000<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 60<br />
*Effects*: The psion enters a trance and predicts the flow of an entire group of combatants. While this inhibits their own combat ability, causing a -6 dodge and -5 hit penalty, the prescient orders they call out add a +4 dodge bonus and +1 block and dodge, +1 extra block and dodge to 8 power levels, to all allies who are close enough to hear the orders.<br />
*Prerequisites*: Combat Sense 8, Marksman's Eye 7, Clarity 5<br />

## Omniscience
*Difficulty*: 10<br />
*Target*: A radius of 40 squares around the psion<br />
*Duration*: 2 to 10 seconds, plus 0.75 to 1.5 seconds per power level<br />
*Stamina Cost*: 10000, minus 115 per level to a minimum of 7500<br />
*Channeling Time*: 75 moves, minus 3.5 moves per level to a minimum of 25<br />
*Effects*: The psion expands their senses to encompass the entire area around them, seeing everything within 40 squares and from Z level 10 to Z level -10 all simultaneously. Their powers allow them to process all the information simultaneously and not suffer any consequences from doing so.<br />
*Prerequisites*: Clairvoyance 14 *or* Satellite View 8, Clarity 9<br />

# Electrokinesis

**Passive Power: Galvanic Armor**: Reduces incoming electrical damage by 1 per four levels of the psion's highest-leveled electrokinetic power and reduces incoming pain by 0.7% times the level of the psion's highest-level electrokinetic power.

## Spark Sight (C)
*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 15 minutes to 30 minutes, plus 2 minutes 30 seconds to 5 minutes per level<br />
*Stamina Cost*: 2000, minus 75 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 80<br />
*Effects*: Allows the psion to see electrical creatures (electrical zombies, robots, and cyborgs) from further away, up to 6 squares + 1.5 squares per power level.<br />
*Prerequisites*: Starting power<br />

## Static Touch
*Difficulty*: 1<br />
*Target*: One target within Range 1<br />
*Duration*: 1 to 3 seconds<br />
*Stamina Cost*: 1500, minus 65 per level to a minimum of 450<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 35<br />
*Effects*: Zap a single target with a jolt of electricity, doing 2 to 7 plus 1 to 1.5 per power level electrical damage, as well as dazing them for the power's duration.<br />
*Prerequisites*: Starting power<br />

## Electrical Discharge
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 5 minutes to 13 minutes and 20 seconds, plus 1 minute and 20 seconds to 3 minutes and 45 seconds per power level<br />
*Stamina Cost*: 3500, minus 120 per level to a minimum of 1100<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 45<br />
*Effects*: Build up a charge in the psion's body, zapping anyone who attacks them 50% of the time for 1 to 5 damage, plus 1/4 (i.e., one point per four levels) to 1/2 damage per power level.  The power also renders the psion's gear and bionic power immune to EMP attacks.<br />
*Prerequisites*: Static Touch 4<br />

## Voltaic Strikes
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 4 minutes to 10 minutes, plus 55 seconds to 1 minute 30 seconds per power level.<br />
*Stamina Cost*: 3750, minus 115 per level to a minimum of 1450<br />
*Channeling Time*: 85 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Build up a charge in the psion's body, zapping their targets 50% of the time for 3 to 10 damage, plus 1/3 (i.e., one point per three levels) to 1/1.5 damage per power level, and leaves a lightning field of intensity 1 to 4 at the enemy's location 50% of the time.  The power also provides electrical armor equal to the power level.<br />
*Prerequisites*: Static Touch 5, Electrical Discharge 5<br />

## Electron Overflow (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 10 minutes to 30 minutes, plus 45 seconds to 90 seconds per power level<br />
*Stamina Cost*: 6500, minus 150 per level to a minimum of 3500<br />
*Channeling Time*: 350 moves, minus 9 moves per level to a minimum of 150<br />
*Effects*: Passively recharge any UPS-compatible devices on the psion's person.<br /> 
*Prerequisites*: Spark Sight 5, Electrical Discharge 8<br />

## Neural Spasms
*Difficulty*: 4<br />
*Target*: One target within 1 square plus 0.6 squares per power level<br />
*Duration*: Diminishing returns--stuns the target for 46.2 moves to 76.9 moves at level 1, 170.5 to 264.7 moves at level 5, 272.7 to 454.5 moves at level 10, and so on, following the formula ( (power level * 0.25) * 6) / ((power level * 0.25) + 3 ) to ( (power level * 0.25) * 10 ) / ((power level * 0.25) + 3 )<br />
*Stamina Cost*: 5500, minus 150 per level to a minimum of 2500<br />
*Channeling Time*: 150 moves, minus 5 moves per level to a minimum of 75<br />
*Effects*: Stuns the target by overloading their nervous system.  It cannot affect targets without a biological nervous system--plants, robots, Nether creatures, fungus, etc.<br />
*Prerequisites*: Spark Sight 6, Voltaic Strikes 5 *or* Static Touch 8<br />

## Pain Suppression (C)
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 10 minutes to 25 minutes, plus 2 minutes to 4 minutes and 40 seconds per power level.<br />
*Stamina Cost*: 4000, minus 105 per level to a minimum of 1250<br />
*Channeling Time*: 125 moves, minus 4 moves per level to a minimum of 75<br />
*Effects*: Reduces incoming pain by 15% plus 2% per power level, to a maximum of 50% reduction, and increases the chance to remove pain during pain reduction checks by 10% plus 2% per power level to a maximum of 50% increased chance.<br />
*Prerequisites*: Neural Spasms 4 *or* (Spark Sight 8 AND Electrical Discharge 8)<br />

## Electrocutioner
*Difficulty*: 5<br />
*Target*: Line stretching 3 squares plus 0.7 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 150 per level to a minimum of 1200<br />
*Channeling Time*: 100 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Hurls a lightning bolt at a target within range, doing 20 to 45 electrical damage plus 2 to 4 per power level and leaving intensity 1 to 2 lightning fields in its wake.  This power causes additional sound at the target location.<br />
*Prerequisites*: Voltaic Strikes 8 *or* Static Touch 12, Electrical Discharge 8<br />

## Re-energize
*Difficulty*: 6<br />
*Target*: Adjacent vehicle or appliance<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 150 per level to a minimum of 4500<br />
*Channeling Time*: 15 seconds<br />
*Effects*: Recharges the batteries of a vehicle or an electrical grid, restoring 250 to 500 power plus 125 to 250 per power level.<br />
*Prerequisites*: Electron Overflow 10, Electrical Discharge 9 *or* Neural Spasms 7<br />

## Analgesic Block
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 60 seconds to 2 minutes 30 seconds, plus 8 seconds to 13 seconds per power level<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 1750<br />
*Channeling Time*: 75 moves, minus 4.5 moves per level to a minimum of 25<br />
*Effects*: Removes all pain and makes the psion immune to pain for the power's duration. When the duration ends, the psion receives all the pain they put off, plus an additional 10%, back all at once.<br />
*Prerequisites*: Pain Suppression 9<br />

## Neuro-acceleration
*Difficulty*: 6<br />
*Target*: Self or ally within 1 square<br />
*Duration*: 1 minute 30 seconds to 7 minutes 30 seconds, plus 15 to 27 seconds per level<br />
*Stamina Cost*: 6000, minus 135 per level to a minimum of 2750<br />
*Channeling Time*: 165 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Increases the target's reflexes and response time, adding 5 learning focus plus 1 per power level to a maximum of 35 learning focus, as well as 10 speed plus 1.5 per power level to a maximum of 60 speed.<br />
*Prerequisites*: Electron Overflow 11 *or* Neural Spasms 6, Electrical Discharge 8 *or* Spark Sight 5<br />

## Short Circuit
*Difficulty*: 7<br />
*Target*: One robot or cyborg within 1 square plus 0.7 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 4500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 30<br />
*Effects*: Overloads a robot or cyborg, completely short-circuiting it and destroying it, and releasing a cloud of sparks within 1 square of the target plus 0.4 squares per power level.  Yrax constructs do not function based on electricity and are immune to this power.<br />
*Prerequisites*: Re-energize 8 *or* Electrocutioner 8 *or* Voltaic Strikes 13, Spark Sight 8<br />

## Galvanic Aura
*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: 60 seconds to 4 minutes 10 seconds, plus 15 seconds to 25 seconds per power level<br />
*Stamina Cost*: 9000, minus 200 per level to a minimum of 4500<br />
*Channeling Time*: 150 moves, minus 8.5 moves per level to a minimum of 55<br />
*Effects*: Supercharges the air around the psion, releasing blasts of 12 fields of intensity 10 lightning every few seconds. It also provides electric armor equal to the power level and makes the psion and their gear immune to EMP blasts.<br />
*Prerequisites*: Electrical Discharge 12, Electron Overflow 15 *or* Re-energize 6<br />

## Ion Blast
*Difficulty*: 9<br />
*Target*: Line stretching 2 squares plus 0.7 squares per power level, causing an explosion with an AoE of 1 plus 1 per 4 power levels<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 100 per level to a minimum of 4000<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 65<br />
*Effects*: Unleashes a lightning bolt that explodes at the target point. The explosion does 25 to 90 electrical damage plus 2 to 4.5 per power level. The bolt does 5 to 25 plus 0.5 to 2.5 per power level. Both the bolt and the explosion release lightning fields of intensity 3 to 7.<br />
*Prerequisites*: Electrocutioner 10 *or* Short Circuit 6, Voltaic Strikes 8 *or* Static Touch 12<br />

## Revivification
*Difficulty*: 10<br />
*Target*: One corpse within 2 squares plus 1 square per 4 power levels<br />
*Duration*: Random but no longer than 12 minutes. The target has an escalating chance to collapse every turn of the effect, beginning at 0.0005% per second in the first minute, climbing to 0.01% per second at minute 4, 1% per second at minute 8, and reaching certainty at minute 12<br />
*Stamina Cost*: 10000, minus 150 per level to a minimum of 6000<br />
*Channeling Time*: 250 moves, minus 6 moves per level to a minimum of 125<br />
*Effects*: Revives a single target with the REVIVES flag, charms it, and heals it for 50% to 80% of its hit points. The revived monster will be allied to you for the power's duration. You may repeatedly use Revivification on the same target as long as it's not pulped.<br />
*Prerequisites*: Neuro-acceleration 8, Analgesic Block 6 *or* Pain Suppression 13<br />

# Photokinesis

**Passive Power: Photon Regulation**: The photokinetic regulates the amount of light their eyes receive. They can sleep in any light level, are immune to flashbangs, and are not impacted by sun glare.

Powers causing photokinetic damage have a 40% chance to blind the target for 3 seconds and a 5% chance to blind the target for 10 seconds. Each of these is checked independently.

## Candle's Glow (C)
*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 26 minutes to 57 minutes, plus 4 minutes and 20 seconds to 14 minutes and 30 seconds per power level<br />
*Stamina Cost*: 1500, minus 80 per level to a minimum of 450<br />
*Channeling Time*: 125 moves, minus 7.5 moves per level to a minimum of 50<br />
*Effects*: Generate a small amount of photons near the psion, producing just enough light to read or work by. The light requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Starting power<br />

## Field of Light
*Difficulty*: 2<br />
*Target*: An area of 1 square plus 0.8 squares per power level to a maximum of 50 squares, out to a distance of 5 squares plus 1.2 squares per power level to a maximum of 80 squares<br />
*Duration*: Halflife of 5 minutes at levels 0-7, 15 minutes at levels 8-15, and 30 minutes at level 16+<br />
*Stamina Cost*: 2500, minus 115 per level to a minimum of 1000<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 75<br />
*Effects*: Creates a large glow over an area, filling the entire area with light.<br />
*Prerequisites*: Starting power<br />

## Blackout
*Difficulty*: 2<br />
*Target*: An area of 1 square plus 0.8 squares per power level to a maximum of 50 squares, out to a distance of 5 squares plus 1.2 squares per power level to a maximum of 80 squares<br />
*Duration*: Halflife of 5 minutes<br />
*Stamina Cost*: 2500, minus 115 per level to a minimum of 1000<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 75<br />
*Effects*: Snuffs out all light in the targeted area. Visibility is reduced to zero.<br />
*Prerequisites*: Candle's Glow 5 *or* Field of Light 4<br />

## Trick of the Light
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 28 seconds to 2 minutes and 5 seconds, plus 13 to 27 seconds per power level, or until hit in combat<br />
*Stamina Cost*: 2250, minus 135 per level to a minimum of 500<br />
*Channeling Time*: 200 moves, minus 9.5 moves per level to a minimum of 65<br />
*Effects*: Wreathe the psion on blurred illusions, confusing their form and making it unclear where exactly they are standing. Adds +6 to dodge, applies the UNCANNY_DODGE and HARDTOHIT flags, and provides a flat 15% + 2% per power level chance to evade the attack on top of normal dodge chance, to a maximum of 85% chance to evade. However, the power instantly ends if the psion is hit.<br />
*Prerequisites*: Field of Light 5, Blackout 5<br />

## Photon Beam
*Difficulty*: 3<br />
*Target*: A line up to 2 squares long plus 0.6 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 2750, minus 125 per level to a minimum of 800<br />
*Channeling Time*: 110 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Concentrate light into a searing beam, doing 3 to 15 damage plus 1.5 to 3.5 photokinetic damage to all enemies in the line of the power.<br />
*Prerequisites*: Candle's Glow 8 *or* Field of Light 6<br />

## Chameleoflage (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 11 minutes and 30 seconds to 23 minutes and 50 seconds, plus 48 seconds to 1 minute and 53 seconds per power level<br />
*Stamina Cost*: 3500, minus 75 per level to a minimum of 1500<br />
*Channeling Time*: 150 moves, minus 8 moves per level to a minimum of 75<br />
*Effects*: Warp light around the psion, making them blend into the nearby background.  This reduces the range at which monsters or hostile NPCs can see them by 15% from levels 1-3, 25% from levels 4-7, 35% from levels 8-11, 43% from levels 12-15, 50% from levels 16-19, and 55% at level 20+.<br />
*Prerequisites*: Trick of the Light 6<br />

## Lucent Barrier (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 6 minutes and 10 seconds to 13 minutes and 30 seconds, plus 18 seconds to 2 minutes and 22 seconds per power level<br />
*Stamina Cost*: 3000, minus 125 per level to a minimum of 800<br />
*Channeling Time*: 250 moves, minus 4.5 moves per level to a minimum of 100<br />
*Effects*: Control the light and electromagnetic radiation near the psion, effectively forming a shield. This renders the psion immune to photokinetic attack as well as laser weapons and radiation. The barrier glows softly when in effect.<br />
*Prerequisites*: Trick of the Light 9 *or* Blackout 6 *and* Chameleoflage 5<br />

## Refracted Arms
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 26 seconds to 1 minutea nd 11 seconds, plus 8 seconds to 41 seconds per power level<br />
*Stamina Cost*: 4000, minus 125 per level to a minimum of 1500<br />
*Channeling Time*: 125 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Create the illusion of multiple other arms, following and preceding the psion's movements, making it very difficult to determine where they will strike. Adds a +4 bonus to hit in melee combat.<br />
*Prerequisites*: Trick of the Light 8, Chameleoflage 6, Candle's Glow 6<br />

## Mirror-Mask (C)
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 7 minutes and 30 seconds to 14 minutes and 50 seconds, plus 22.5 seconds to 55 seconds per power level<br />
*Stamina Cost*: 6500, minus 150 per level to a minimum of 2000<br />
*Channeling Time*: 1500 moves, minus 75 moves per level to a minimum of 150<br />
*Effects*: Wrap the psion in illusions, concealing any mutations or visible bionics they may have. NPCs will react to them better, and certain people who might refuse to talk to a mutant will be happy to talk to them.<br />
*Prerequisites*: Chameleoflage 8, Lucent Barrier 5<br />

## Lucid Shadows
*Difficulty*: 5<br />
*Target*: A square up to squares aware plus 0.8 squares per power level to a maximum of 40 squares<br />
*Duration*: 48 seconds to 2 minutes and 16.5 seconds, plus 5.5 to 13.5 seconds per power level<br />
*Stamina Cost*: 4000, minus 145 per level to a minimum of 1750<br />
*Channeling Time*: 150 moves, minus 4 moves per level to a minimum of 90<br />
*Effects*: Create identical copies of the psion, anywhere from 1 to one-third of the power level copies. The copies will run around and confuse the psion's enemies while the power lasts.<br />
*Prerequisites*: Refracted Arms 6 *or* Chameleoflage 6, Photon Beam 6<br />

## Radio Transception (C)
*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 24 minutes and 12 seconds to 1 hour and 27 minutes, plus 2 minutes and 6 seconds to 12 minutes and 50 seconds per power level<br />
*Stamina Cost*: 5000, minus 100 per level to a minimum of 2250<br />
*Channeling Time*: 250 moves, minus 10 moves per level to a minimum of 75<br />
*Effects*: Open the psion up to radio waves, allowing them to scan any remaining radio broadcasts or broadcast to anyone with a functional radio.<br />
*Prerequisites*: Field of Light 8 *or* Photon Beam 7, Lucent Barrier 6<br />

## Veil of Light
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 16 seconds to 42 seconds, plus 6 seconds to 23 seconds per power level<br />
*Stamina Cost*: 3500, minus 125 per level to a minimum of 1200<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 35<br />
*Effects*: Warp light around the psion, making them completely invisible while still allowing them to perceive their surroundings. There is a chance when moving that the effect will break: 2% minus 0.1% per power level to a minmum of 0.4% per square when crawling or walking, and 8% minus 0.3% per power level to a minimum of 3% per square when running.<br />
*Prerequisites*: Lucent Barrier 6 *or* Lucid Shadows 6, Mirror-Mask 6 *or* Chameleoflage 10<br />

## Star Flash
*Difficulty*: 6<br />
*Target*: A line up to 2 squares long plus 0.6 squares per power level, and 1 additional square in breadth plus 0.3 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2750<br />
*Channeling Time*: 135 moves, minus 8.5 moves per level to a minimum of 40<br />
*Effects*: Unleash a high-powered laser blast, doing 20 to 54 photokinetic damage plus 2.5 to 6 photokinetic damage per level to everything within the targeted line.<br />
*Prerequisites*: Photon Beam 8, Lucent Barrier 6 *or* Refracted Arms 6<br />

## Blinding Radiance
*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 59 seconds to 2 minutes and 58 seconds, plus 11 seconds to 47 seconds per power level<br />
*Stamina Cost*: 6500, minus 95 per level to a minimum of 3250<br />
*Channeling Time*: 125 moves, minus 7.5 moves per level to a minimum of 25<br />
*Effects*: Begin glowing brighter than a floodlight, illuminating the ground out to XXXX squares and gaining a +4 dodge bonus as enemies have a hard time targeting the psion.  When hit or when attacking enemies, there is a 33% chance the psion will unleash an even brighter flash that blinds everyone within 5 squares plus 1.2 squares per power level for between 5 and 20 seconds.<br />
*Prerequisites*: Field of Light 12, Star Flash 6 *or* Lucent Barrier 10<br />

## Luminous Disintegration
*Difficulty*: 8<br />
*Target*: One target within 2 squares long plus 0.8 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 8000, minus 150 per level to a minimum of 4000<br />
*Channeling Time*: 200 moves, minus 10 moves per level to a minimum of 50<br />
*Effects*: Focus electromagnetic radiation onto a single point, doing immense damage to the target there.  This power does 45 to 135 photokinetic damage plus 5.5 to 17 photokinetic damage per power level<br />
*Prerequisites*: Star Flash 8 *or* Photon Beam 14, Blinding Radiance 5<br />


# Pyrokinesis

**Passive Power: Internal Fire**: The pyrokinetic slightly heats the air around themselves, gaining a small amount of warmth at all times (and more in colder temperatures) and becoming more comfortable when sleeping, as well as ignoring the first 10 points of wetness on any part of their body.

## Brilliant Flash
*Difficulty*: 1<br />
*Target*: An area of effect with radius 1 square, plus 1 square per 4 power levels to a maximum of 8 squares, at a range of 3 squares plus 1.2 squares per power level to a maximum of 50 squares<br />
*Duration*: 1 to 8 seconds, plus 0.5 to 1 seconds per power level<br />
*Stamina Cost*: 1750, minus 80 per level to a minimum of 550<br />
*Channeling Time*: 150 moves, minus 8 moves per level to a minimum of 50<br />
*Effects*: Excite air molecules and unleash a flash of light, blinding nearby targets for the power's duration.<br />
*Prerequisites*: Starting power<br />

## Fountain of Flames
*Difficulty*: 2<br />
*Target*: One target within 1 square plus 1 square per 10 power levels, to a maximum of 5 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 1950, minus 75 per level to a minimum of 700<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 35<br />
*Effects*: The pyrokinetic unleashes a blast of flame at a close-range target, doing 6 to 26 heat damage plus 1.5 to 3 heat damage per power level. This power also has a 50% chance of leaving a fire field of intensity 1 to 2 in the target square.<br />
*Prerequisites*: Starting power<br />

## Cauterize
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 2200, minus 95 per level to a minimum of 750<br />
*Channeling Time*: 600 moves<br />
*Effects*: The psion attempts to seal one of their bleeding wounds shut.This automatically succeeds if the psion is a physician or has the Burn Care proficiency, otherwise it is a check of the Health Care skill + 1d10 vs 7. If the check is failed, the psion suffers 3 damage to the target location and 1-3 pain and the bleeding continues. If the check succeeds, the psion suffers 1 daamge to the target location and 1-2 pain, but the bleeding stops. Bleeding of Intensity 30 or more cannot be stopped through Cauterize. There is also a 6.67% chance, independently checked per attempt, for the wound to become infected within 24 hours.<br />
*Prerequisites*: Fountain of Flames 6 AND Quell Fire 6 *or* Incandescent Lance 5 <br />

## Banked Flames (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 8 minutes and 30 seconds to 30 minutes, plus 50 seconds to 20 minutes and 40 seconds per level<br />
*Stamina Cost*: 2500, minus 150 per level to a minimum of 800<br />
*Channeling Time*: 250 moves, minus 10 moves per level to a minimum of 75 moves<br />
*Effects*: Summon a controlled fire in the palm of the psion's hand or nearby. The fire sheds a small amount of light and can be used for anything fire can normally be used for; heating food, cooking, lightning other fires, and so on. The banked flame requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Fountain of Flames 4<br />

## Quell Fire
*Difficulty*: 3<br />
*Target*: An area of effect with a radius of 1 square plus 1 square per 2 power levels to a maximum of 50 squares, at a range of 3 squares plus 0.8 squares per power level to a maximum of 70 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 120 per level to a minimum of 1000<br />
*Channeling Time*: 125 moves, minus 7.5 moves per level to a minimum of 50 moves<br />
*Effects*: As the psion can control fire, they can also extinguish it. Harmlessly disperses all flamees within the area of effect. The aftereffects of the fire (burned locations or people) are not reversed.<br />
*Prerequisites*: Banked Flames 5<br />

## Cloak of Warmth (C)
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 3 minutes to 24 minutes, plus 29 seconds to 3 minutes and 12 seconds seconds per power level<br />
*Stamina Cost*: 4500, minus 160 per level to a minimum of 2000<br />
*Channeling Time*: 250 moves, minus 11 moves per level to a minimum of 75 moves<br />
*Effects*: Heat the air around the psion to a more comfortable temperature, providing 1 point of armor against heat and 3 points of armor against heat per power level, as well as heating the air 10 degrees toward comfortable per power level (or cooling it 3 degrees per power level, if necessary). The cloak also heats the air around the psion by 26 degrees.<br />
*Prerequisites*: Banked Flames 6 *or* Fountain of Flames 6<br />

## Flamethrower
*Difficulty*: 5<br />
*Target*: A cone out to 3 squares plus 0.3 squares per power level to a maximum of 20 squares, with an arc length of 27 degrees plus 3 degrees per power level, to a maximum of 120 degrees<br />
*Duration*: Instant<br />
*Stamina Cost*: 4500, minus 150 per level to a minimum of 1600<br />
*Channeling Time*: 100 moves, minus 6 moves per level to a minimum of 35 moves<br />
*Effects*: Unleash a blast of flame, burning the psion's enemies for 15 to 40 heat damage, plus 1.5 to 2.5 damage per power level. There is a 20% chance that an affected square will be set on fire with a fire field of intensity 1 to 2.<br />
*Prerequisites*: Fountain of Flames 7, Brilliant Flash 5<br />

## Incandescent Lance (C)
*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 3 minutes 25 seconds to 41 minutes, plus 1 minute and 54 seconds to 8 minutes and 12 seconds per power level<br />
*Stamina Cost*: 5000, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 650 moves, minus 12 moves per level to a minimum of 320 moves<br />
*Effects*: Create a thin line of extremely hot fire, useful for welding or breaching metal doors. The lance requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Banked Flames 6 *or* Fountain of Flames 9 AND Quell Fire 6<br />

## Thermogenesis
*Difficulty*: 5<br />
*Target*: A space within 3 squares<br />
*Duration*: 1 to 2 hours, plus 2 minutes 30 seconds to 5 minutes per level<br />
*Stamina Cost*: 8000, minus 200 per level to a minimum of 4000<br />
*Channeling Time*: 1500 moves, minus 10 moves per level to a minimum of 1200 moves<br />
*Effects*: Heat nearby air to produce warmth. The spot chosen will shed heat for the duration of the power. Four different intensities are selectable: 6 degrees, 16 degrees, 40 degrees, and 75 degrees.<br />
*Prerequisites*: Banked Flames 10 *or* Cloak of Warmth 6, Brilliant Flash 7<br />

## Blazing Aura (C)
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 45 seconds to 3 minutes, plus 7 to 19 seconds per power level<br />
*Stamina Cost*: 6500, minus 175 per level to a minimum of 3500<br />
*Channeling Time*: 125 moves, minus 6.5 moves per level to a minimum of 50 moves<br />
*Effects*: Kindle the air around the psion, doing 5 to 20 heat damage to anyone attacking them in melee and causing 5 to 15 heat damage to anyone the psion attacks. The cloak also sheds light and heats the nearby air by 45 degrees.<br />
*Prerequisites*: Cloak of Warmth 8, Thermogenesis 5 *or* Flamethrower 6, Fountain of Flames 7<br />

## Flameshield (C)
*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 90 seconds to 9 minutes and 30 seconds, plus 11 to 47 seconds per power level<br />
*Stamina Cost*: 7750, minus 165 per level to a minimum of 4000<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 75 moves<br />
*Effects*: The psion becomes totally immune to heat and flame for the power's duration.  They could walk through a burning house or into a blast furnace without injury.<br />
*Prerequisites*: Cloak of Warmth 10 *or* Blazing Aura 6, Quell Fire 9, <br />

## Conflagration
*Difficulty*: 7<br />
*Target*: A radius of 2 squares plus 0.4 squares per power level to a maximum of 25 squares, to a range of 4 squares plus 0.9 squares per power level to a maximum range of 70 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 3500<br />
*Channeling Time*: 150 moves, minus 7 moves per level to a minimum of 35 moves<br />
*Effects*: The psion unleashes an explosion of flames in the target area, doing 37 to 115 heat damage to all targets in the power's area of effect, plus 2.5 to 5 heat damage per power level, with a 25% chance to set each affected square on fire with a fire field of intensity 1 to 2.<br />
*Prerequisites*: Flamethrower 8 *or* Fountain of Flames 13, Thermogenesis 6 *or* Blazing Aura 6<br />

## Hellfire
*Difficulty*: 9<br />
*Target*: A radius of 4 squares plus 0.9 squares per power level around the psion to a maximum of 35 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 9000, minus 220 per level to a minimum of 6000<br />
*Channeling Time*: 175 moves, minus 8 moves per level to a minimum of 55 moves<br />
*Effects*: Flames roar outward from the psion's position, engulfing the entire nearby area in flames. Does 65 to 169 heat damage to all targets in the power's area of effect, plus 5 to 8 heat damage per power level, with a 50% chance to set each affected square on fire with a fire field of intensity 1 to 3.<br />
*Prerequisites*: Flamethrower 12 *or* Conflagration 6, Thermogenesis 10 *or* Flameshield 6<br />

## Crucible
*Difficulty*: 10<br />
*Target*: One target within 2 squares plus 1 square per 2 power levels, to a maximum of 20 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 12000, minus 150 per level to a minimum of 8000<br />
*Channeling Time*: 200 moves, minus 4 moves per level to a minimum of 75<br />
*Effects*: The pyrokinetic concentrates all of their power onto a single point, heating it white-hot and incinerating whatever they are focusing on. Does 150 to 400 heat damage plus 10 to 25 heat damage per power level and has a 100% chance to leave a fire field of intensity 3 at the target location.<br />
*Prerequisites*: Conflagration 10, Hellfire 6, Flamethrower 10 *or* Fountain of Flames 14<br />

# Telekinesis

**Passive Power: Lifting Hand**: The telekinetic may carry a single item next to them in a field of telekinetic force. The item's weight increases proportional to their highest telekinetic power, though they must use the recipe Contemplate Lifting Field to increase it.

Powers causing telekinetic damage have a 40% chance to stagger the target for 2 seconds and a 20% chance to down the target. Each of these is checked independently.

## Far Hand 
*Difficulty*: 1<br />
*Target*: One enemy, ally, or the items in a space up to 3 squares away plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 1750, minus 80 per level to a minimum of 750<br />
*Channeling Time*: 50 moves, minus 4 moves per level to a minimum of 10<br />
*Effects*: The psion reaches out and pulls the target toward them, moving it 1 to 6 squares closer plus 0.5 to 1.5 squares per power level.<br />
*Prerequisites*: Starting power<br />

## Force Shove 
*Difficulty*: 1<br />
*Target*: One enemy, ally, or the items in a space up to 1 square away plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 1750, minus 80 per level to a minimum of 750<br />
*Channeling Time*: 50 moves, minus 4 moves per level to a minimum of 10<br />
*Effects*: The psion shoves a single target away, moving it 2 to 4 squares plus 0.5 to 1 squares per power level.<br />
*Prerequisites*: Starting power<br />

## Knockdown
*Difficulty*: 2<br />
*Target*: One target within to 2 squares away plus 0.5 squares per power level<br />
*Duration*: From 100 to 400 moves, plus 25 to 95 moves per power level<br />
*Stamina Cost*: 3000, minus 80 per level to a minimum of 1250<br />
*Channeling Time*: 75 moves, minus 4 moves per level to a minimum of 30<br />
*Effects*: Slam a single target to the ground, doing 5 to 15 telekinetic damage plus 0.5 plus 1.2 damage per power level, and downing the target for the power's duration.<br />
*Prerequisites*: Force Shove 4<br />

## Momentum Alteration (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 125 per level to a minimum of 1750<br />
*Channeling Time*: 300 moves, minus 7.5 moves per level to a minimum of 125<br />
*Effects*: Manipulate local momentum to the psion's advantage, speeding their own movements and slowing incoming dangerous objects. Reduces move cost by 0.5% per power level to a maximum of 15%, increases attack speed by 1% per power level, reduces incoming cutting and piercing damage by 0.5% per power level, reduces incoming bashing damage by 1% per power level, and reduces incoming ballistic damage by 2% per power level.<br />
*Prerequisites*: Far Hand 5, Force Shove 5<br />

## Slowfall (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: From 3 to 15 seconds, plus 1 to 4 seconds per power level<br />
*Stamina Cost*: 2250, minus 85 per level to a minimum of 650<br />
*Channeling Time*: 85 moves, minus 4.5 moves per level to a minimum of 25<br />
*Effects*: Reduce the psion's falling speed, taking 50% less falling damage, plus 4% per level to a maximum of 95% lower falling damage.  Also makes swimming 3 times easier due to increased buoyancy.<br />
*Prerequisites*: Momentum Alteration 6<br />

## Wave of Force
*Difficulty*: 4<br />
*Target*: All targets within range 1<br />
*Duration*: Instant<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 2250<br />
*Channeling Time*: 50 moves, minus 4 moves per level to a minimum of 20<br />
*Effects*: Unleash an indiscriminate wave of force, knocking back everything nearby by 2 to 6 squares, plus 1 square per 10 power levels to 1 square per four power levels. This power affects item and allies as well as enemies.<br />
*Prerequisites*: Force Shove 7, Knockdown 4 <br />

## Enhance Strength (C)
*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: From 30 seconds to 2 minutes, plus 15 to 30 seconds per power level<br />
*Stamina Cost*: 5000, minus 150 per level to a minimum of 2000<br />
*Channeling Time*: 300 moves<br />
*Effects*: Use telekinesis to enhance the psion's strength by 15 plus 3 per power level. This enhanced strength requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Force Shove 6 *or* Far Hand 6, Momentum Alteration 5<br />

## Mindhammer (C)
*Difficulty*: 5<br />
*Target*: One target within 3 squares plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 3750, minus 135 per level to a minimum of 1750<br />
*Channeling Time*: 50 moves, minus 2.5 moves per level to a minimum of 25<br />
*Effects*: Smashes a single target with a fist of telekinetic force, doing 18 to 55 telekinetic damage plus 1.25 to 3.5 damage per power level. Also smashes the terrain at the target tile for 25 to 55 bash damage plus 1.5 to 3 damage per power level.<br />
*Prerequisites*: Knockdown 6, Wave of Force 4 *or* Force Shove 8<br />

## Lift Vehicle (C)
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: From 10 minutes to 25 minutes, plus 3 minutes and 10 seconds to 7 minutes per power level<br />
*Stamina Cost*: 6500, minus 200 per level to a minimum of 3250<br />
*Channeling Time*: 250 moves, minus 8 moves per level to a minimum of 125<br />
*Effects*: Create a field to lift up a vehicle just enough to work on the wheels or undercarriage. This field requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Enhance Strength 10 *or* Far Hand 8 AND Slowfall 8<br />

## Inertial Barrier (C)
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: From 4 minutes and 40 seconds to 12 minutes, plus 14 to 37 seconds per power level<br />
*Stamina Cost*: 8000, minus 185 per level to a minimum of 3250<br />
*Channeling Time*: 250 moves, minus 8 moves per level to a minimum of 65<br />
*Effects*: Summon a telekinetic barrier around the psion, blunting incoming damage. Reduces bashing damage by 2 plus 0.5 per power level, cutting damage by 3 plus 1 per power level, piercing damage by 5 plus 1.5 per power level, and ballistic damage by 12 plus 2.5 per power level.<br />
*Prerequisites*: Wave of Force 8, Momentum Alteration 10<br />

## Wrecking Ball
*Difficulty*: 7<br />
*Target*: An area of effect of 2 squares plus 0.3 squares per power level, to a maximum AoE of 30, within 4 squares plus 0.9 squares per power level, to a maximum range of 60<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 200 per level to a minimum of 4500<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 75<br />
*Effects*: Thrashes an area with an explosion of telekinetic force, doing 22 to 99 telekinetic damage plus 3 to 7.5 to everything within the power's area of effect. It also smashes terrain for the same amount of damage.<br />
*Prerequisites*: Knockdown 12 *or* Mindhammer 7, Force Shove 10 *or* Far Hand 10<br />

## Levitation (C)
*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 1 to 5 seconds, plus 0.75 to 2 seconds per power level<br />
*Stamina Cost*: 7500, minus 165 per level to a minimum of 3500<br />
*Channeling Time*: 75 moves, minus 5.5 moves per level to a minimum of 15<br />
*Effects*: The psion can lift themselves with telekinesis. While not true flight since they are incapable of ascent, they can travel horizontally as long as they want and descend in complete safety. This power requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Slowfall 9, Force Push 12 *or* Lift Vehicle 5<br />

## Aegis
*Difficulty*: 9<br />
*Target*: Self<br />
*Duration*: 1 second to 2 seconds, plus 1 second maximum possible duration per 5 power levels (minimum does not change)<br />
*Stamina Cost*: 9500, minus 225 per level to a minimum of 5500<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 55<br />
*Effects*: Put up a nearly-impenetrable barrier of telekinetic force capable of withstanding the blast wave of a nuclear detonation (though not the heat or the radiation). Reduces all bashing, cutting, piercing, and ballistic damage by 100,000. The psion is unable to move while Aegis is in effect.<br />
*Prerequisites*: Inertial Barrier 7, Wave of Force 8 *or* Slowfall 9, Momentum Alteration 12 *or* Enhance Strength 8<br />

## Earthshaker
*Difficulty*: 10<br />
*Target*: A radius around the psion of 5 squares plus 0.8 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 11500, minus 200 per level to a minimum of 7000<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 45<br />
*Effects*: Grab the ground and *wrench* it with telekinesis, knocking everyone nearby off their feet and doing 30 to 80 plus 2.5 to 7 bash damage to the entirety of the terrain in the area of effect. Terrain in the area also has a 10% chance of cracking, becoming rubble or a pit.<br />
*Prerequisites*: Wrecking Ball 8 *or* Wave of Force 13, Mindhammer 10 *or* Enhance Strength 12 <br />

# Telepathy

**Passive Power: Telepathic Suggestion**: Influence the attitude of those the psion is speaking to, increasing Persuade, Lie, and Intimidate chances by 5% plus 1.5% times the psion's highest-leveled telepathy power.

Powers causing telepathic damage have a 5% chance to down the target, a 33% chance to stun the target for 1 second, and a 66% chance to daze the target for 1 second. Each of these is checked independently.

## Concentration Trance (C)
*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 9 minutes and 20 seconds to 17 minutes and 13 seconds, plus 2 minutes and 12 seconds to 10 minutes and 5 seconds per power level<br />
*Stamina Cost*: 4000, minus 175 per level to a minimum of 1500<br />
*Channeling Time*: 300 moves, minus 12 moves per level to a minimum of 150<br />
*Effects*: The psion enters a trance that facilitates learning, adding learning focus equal to 2.5 * the power level. The trance takes up most of the psion's concentration, however, increasing movement cost by 3x and reducing vision range the same as the nearsighted trait. The trance requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Starting power<br />

## Sense Minds (C)
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 1 minute 30 seconds to 10 minutes, plus 26 seconds to 2 minutes and 11 seconds per power level<br />
*Stamina Cost*: 3500, minus 115 per level to a minimum of 1500<br />
*Channeling Time*: 500 moves<br />
*Effects*: Sense all sapient living beings within 2 squares per power level around the psion.  This includes all humans, sapient aliens such as mi-go or triffids (but not the triffids' vegetal defense biotechnology), most mutants who are not too far gone, Nether beings, and cyborgs, and excludes animals and robots.<br />
*Prerequisites*: Starting power<br />

## Telepathic Shield (C)
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 3 minutes to 12 minutes, plus 15 to 36 seconds per power level<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 500<br />
*Channeling Time*: 100 moves, minus 6.5 moves per level to a minimum of 10<br />
*Effects*: Place a shield over the psion's mind, preventing telepathic assault and also rendering the psion immune to the attacks of flaming eyes and the personal effects of portal storms. The psion is immune to telepathic damag and most telepathy-related effects while this power is active.<br />
*Prerequisites*: Concentration Trance 5<br />

## Mood Stabilization (C)
*Difficulty*: 3<br />
*Target*: Self (or dialogue)<br />
*Duration*: 16 minutes and 21 seconds to 42 minutes, plus 6 minutes and 21 seconds to 14 minutes and 59 seconds per power level<br />
*Stamina Cost*: 5000, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 300 moves, minus 9.5 moves per level to a minimum of 150<br />
*Effects*: Further edit the psion's mind, removing negative thoughts and improving mood. Adds a morale bonus of +10 (building up to a maximum of 25). It may also be used in dialogue to calm down angry NPCs.<br />
*Prerequisites*: Concentration Trance 6, Sense Minds 5<br />

## Synaptic Blast
*Difficulty*: 4<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 125 per level to a minimum of 900<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 25<br />
*Effects*: Assault the target's mind, causing damage equal to a percentage of their current health, beginning at 5% and adding 1.5% to 3% per power level.  As such, Synaptic Blast is almost never capable of killing the target.<br />
*Prerequisites*: Sense Minds 7, Mood Stabilization 4<br />

## Beastmaster
*Difficulty*: 4<br />
*Target*: One mammal, bird, reptile, amphibian, or fish within target within 3 squares plus 1 square per power level<br />
*Duration*: 3 minutes to 7 minutes and 50 seconds, plus 11.25 seconds to 28 seconds per power level<br />
*Stamina Cost*: 4500, minus 155 per level to a minimum of 2000<br />
*Channeling Time*: 120 moves, minus 3.5 moves per level to a minimum of 75<br />
*Effects*: Take over the mind of an animal, making it friendly to you.  While still an animal and subject to its instincts, it will not be hostile to you or run while the power is active, and may fight to defend you, again subject to its instincts (a wolf is a much better battle companion than a lemming).<br />
*Prerequisites*: Mood Stabilization 8<br />

## Sensory Deprivation
*Difficulty*: 5<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: 2 to 8 seconds, plus 0.5 to 1.5 seconds per power level<br />
*Stamina Cost*: 3750, minus 150 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 25<br />
*Effects*: Assault the target's mind, disconnecting their senses. Blinds and stuns the target for the duration.<br />
*Prerequisites*: Synaptic Blast 6 *or* Mood Stabilization 6, Telepathic Shield 5<br />

## Primal Terror
*Difficulty*: 5<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: Aftereffects last from 2 to 5 seconds, plus 0.75 to 1.75 seconds per power level<br />
*Stamina Cost*: 6000, minus 100 per level to a minimum of 3500<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 50<br />
*Effects*: Assault the target's mind, unleashing their most elemental fears. Freezes the target in place for a number of moves depending on power level--the formula is from ((Power level / 4) * 6) / ((Power level / 4) + 3) to ((Power level / 4) * 10) / ((Power level / 4) + 3), and then multiply by 100 to get the moves subtracted from the target. Level 1 minimum is 46.5 moves lost, level 20 maximum is 625. For the aftereffect duration, the target suffers a -30 penalty to speed, a -2 penalty to dodge, a -2 penalty to hit, and a -8 penalty to bash damage.<br />
*Prerequisites*: Synaptic Blast 8, Mood Stabilization 8<br />

## Obscurity
*Difficulty*: 6<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: 2 minutes and 7 seconds to 8 minutes and 43 seconds, plus 13 to 52 seconds per power level<br />
*Stamina Cost*: 4500, minus 115 per level to a minimum of 2250<br />
*Channeling Time*: 100 moves, minus 6.5 moves per level to a minimum of 25<br />
*Effects*: The psion erases their presence from the target's mind. For the power's duration, the target will not be able to see the psion at all; they will react to any companions or allies the psion has as normal. Attacking the target will immediately cancel the power.<br />
*Prerequisites*: Sensory Deprivation 8, Mood Stabilization 6 *or* Synaptic Blast 11 *or* Telepathic Shield 8<br />

## Psychic Scream
*Difficulty*: 7<br />
*Target*: Everything within a radius of 2 squares plus 1.1 squares per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: Instant<br />
*Stamina Cost*: 7000, minus 275 per level to a minimum of 3250<br />
*Channeling Time*: 75 moves, minus 6.5 moves per level to a minimum of 30<br />
*Effects*: Unleash an undirected telepathic shriek, doing 3% of maximum health as damage plus 1% to 2% per power level, +1 flat damage. This second flat damage counts as an additional attack for the purposes of the side effects of telepathic damage.<br />
*Prerequisites*: Synaptic Blast 11 *or* Primal Fear 7, Telepathic Shield 5<br />

## Beast Tamer
*Difficulty*: 7<br />
*Target*: One friendly mammal, bird, reptile, amphibian, or fish within target within 3 squares plus 1 square per power level<br />
*Duration*: 28 days to 56 days, plus 1 day to 3 days per power level<br />
*Stamina Cost*: 8000, minus 185 per level to a minimum of 5500<br />
*Channeling Time*: 2 minutes<br />
*Effects*: Deepen the psion's influence over a friendly animal, making it well-disposed toward the them. The animal counts as tamed and may be tied up, played with, ridden, and all other functions available to tame animals.<br />
*Prerequisites*: Beastmaster 10<br />

## Mind Control
*Difficulty*: 8<br />
*Target*: One target within 3 squares plus 1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br /><br />
*Duration*: 6 to 52 seconds, plus 1.5 to 6.5 seconds per power level<br />
*Stamina Cost*: 7500, minus 165 per level to a minimum of 3500<br />
*Channeling Time*: 120 moves, minus 3.5 moves per level to a minimum of 65<br />
*Effects*: Take over the mind of your target.  The target will not be hostile to you or run while the power is active, and may fight to defend you, subject to its normal behaviors; mind controlling a salmon is unlikely to provide a significant edge in battle.  Due to engine limitations, does not currently work on NPCs.<br />
*Prerequisites*: Mood Stabilization 12 *or* Obscurity 6, Primal Terror 5 *or* Beastmaster 8 *or* Sensory Deprivation 7<br />

## Network Effect
*Difficulty*: 9<br />
*Target*: All nearby NPC allies<br /><br />
*Duration*: 1 minute and 40 seconds to 5 minutes, plus 7 to 34 seconds per power level<br />
*Stamina Cost*: 6500, minus 135 per level to a minimum of 3750<br />
*Channeling Time*: 500 moves, minus 9 moves per level to a minimum of 250<br />
*Effects*: Forge a telepathic connection between nearby allies, allowing immediate reaction to threats and better coordination against danger. This provides a large array of bonuses: +1 dodge and block and another +1 per 12 power levels, +1 Perception and another +1 per 5 power levels, +3 ranged weapon range and another +1 per 4 power levels, a 5% chance to evade incoming attacks and another +1% per 2 power levels, 5% increased damage and another +1% per 2 power levels, increased combat skill gain, and the UNCANNY DODGE flag. It applies to all targets, but may only be used when at least 1 NPC ally is nearby.<br />
*Prerequisites*: Mind Sense 10, Telepathic Concentration 10 *or* Mood Stabilization 8, Psychic Scream 6<br />

# Teleportation

**Passive Power: Spacial Recalibration**: Immunity to teleglow and a small chance to avoid incoming damage: a 1% chance per attack plus 0.5% times the psion's highest-leveled teleportation power.

## Blink 
*Difficulty*: 1<br />
*Target*: Between 5 and 15 squares away, with a variance of 1 to 5 squares from the initial point<br />
*Duration*: Instant<br />
*Stamina Cost*: 900, minus 55 per level to a minimum of 350<br />
*Channeling Time*: 50 moves, minus 3.5 moves per level to a minimum of 5<br />
*Effects*: The psion vanishes and reappears nearby. They cannot control exactly where they end up. While there is no danger of teleporting into a wall or solid rock, if above ground level it is possible to teleport into open air, after which the psion will fall normally.<br />
*Prerequisites*: Starting power<br />

## Stutterstep 
*Difficulty*: 2<br />
*Target*: One target within 3 squares plus 1.2 squares per power level, with an AoE increasing by 1 per 5 power levels<br />
*Duration*: 1.25 seconds to 15 seconds, plus 0.75 to 2 seconds per power level<br />
*Stamina Cost*: 2000, minus 75 per level to a minimum of 750<br />
*Channeling Time*: 80 moves, minus 4.5 moves per level to a minimum of 35<br />
*Effects*: Warp space around the target, increasing relative distances and reducing their speed by 40.<br />
*Prerequisites*: Starting power<br />

## Phase 
*Difficulty*: 2<br />
*Target*: 2 squares plus 1 square per 10 power levels to a maximum of 4 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 2500, minus 65 per level to a minimum of 1250<br />
*Channeling Time*: 65 moves, minus 3 moves per level to a minimum of 15<br />
*Effects*: Travel a short distance through the Nether and re-emerge nearby, allowing the psion to bypass a door or travel from the ground floor to the second floor.<br />
*Prerequisites*: Blink 6<br />

## Extended Stride (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 30 seconds to 5 minutes, plus 11 to 37 seconds per power level<br />
*Stamina Cost*: 3500, minus 95 per level to a minimum of 1750<br />
*Channeling Time*: 85 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Shorten relative distances nearby, allowing the psions to travel faster than their stride would indicate. Reduces move cost by 5% plus 2% per power level to a maximum of 60% reduced move cost.<br />
*Prerequisites*: Phase 4, Stutterstep 6<br />

## Transposition 
*Difficulty*: 4<br />
*Target*: One target within 1 square plus 1.5 squares per power levels<br />
*Duration*: Instant<br />
*Stamina Cost*: 2750, minus 85 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 30<br />
*Effects*: Extangle the psion's position with the target's and then swap places, exchanging positions.<br />
*Prerequisites*: Displacement 5, Extended Stride 5<br />

## Displacement 
*Difficulty*: 4<br />
*Target*: One target within range 1<br />
*Duration*: Instant<br />
*Stamina Cost*: 4000, minus 65 per level to a minimum of 1750<br />
*Channeling Time*: 95 moves, minus 4 moves per level to a minimum of 25<br />
*Effects*: Touch a single target and teleport them through the Nether, sending them anywhere within 5 to 15 squares with a variance of 1 to 5 squares from that point (the same as Blink).<br />
*Prerequisites*: Stutterstep 10, Phase 5 <br />

## Spacial Vortex 
*Difficulty*: 5<br />
*Target*: An area of 3 squares plus 1 square per 4 power levels, with a range of 5 squares plus 1.2 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 5500, minus 75 per level to a minimum of 3000<br />
*Channeling Time*: 80 moves, minus 2 moves per level to a minimum of 45<br />
*Effects*: Warp space and draw everyone within toward the central point. All targets within the AoE are pulled toward the center by 1 square per 4 power levels, to a maximum of 8 squares toward the center.<br />
*Prerequisites*: Stutterstep 10 *or* Transposition 6, Extended Stride 4<br />

## Farstep 
*Difficulty*: 6<br />
*Target*: Anywhere within 2 square plus 1.5 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 6500, minus 105 per level to a minimum of 2750<br />
*Channeling Time*: 75 moves, minus 3 moves per level to a minimum of 30<br />
*Effects*: Step into the Nether and re-emerge at a location nearby.  Farstep works through walls and across Z levels.<br />
*Prerequisites*: Phase 10, Extended Stride 8 *or* Spacial Vortex 6 <br />

## Oubliette 
*Difficulty*: 7<br />
*Target*: A single target within 2 squares plus 1.5 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 170 per level to a minimum of 4600<br />
*Channeling Time*: 150 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Teleports a single monster somewhere *else*, removing them and anything they might drop. The monster must have HP lower than 15 to 350, plus 15 to 35 per power level, randomly determined when the power is used.  Oubliette cannot currently affect NPCs.<br />
*Prerequisites*: Displacement 10, Farstep 6 *or* Transposition 8 *or * Spacial Vortex 8<br />

## Gateway 
*Difficulty*: 8<br />
*Target*: One attuned location<br />
*Duration*: Instant<br />
*Stamina Cost*: 10000, minus 200 per level to a minimum of 6000<br />
*Channeling Time*: 200 moves, minus 5.5 moves per level to a minimum of 75. Attunement takes 8 hours, minus 30 minutes per power level of Gateway to a minimum of 30 minutes<br />
*Effects*: Transport yourself through the Nether to an attuned location. This power works at any distance..<br />
*Prerequisites*: Farstep 10, Extended Stride 10 <br />

## Breach 
*Difficulty*: 9<br />
*Target*: A single target within 2 squares plus 1.3 squares per power level<br />
*Duration*: Indefinitet<br />
*Stamina Cost*: 9000, minus 250 per level to a minimum of 4500<br />
*Channeling Time*: 250 moves, minus 6.5 moves per level to a minimum of 125<br />
*Effects*: Opens a portal to the Nether and allows something to come through: from 1 to 3 monsters from the GROUP_NETHER_BREACH monster group. The psion has no control over what exactly comes through and no control over what they do when they arrive.<br />
*Prerequisites*: Displacement 12 *or* Oubliette 7, Gateway 6<br />

# Vitakinesis

**Passive Power: Bloom of Vitality**: Increased max HP equal to 5% plus 1% times the psion's highest-leveled vitakinetic power, faster healing equal to 10% plus 1% times the psion's highest-leveled vitakinetic power, the ability to heal broken limbs without a splint, and 5x faster processing of mutant toxins.

## Healthy Glow (C) 
*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 5 minutes and 54 seconds to 25 minutes and 50 seconds, plus 21 seconds to 4 minutes and 58 seconds per power level<br />
*Stamina Cost*: 2500, minus 75 per level to a minimum of 1000<br />
*Channeling Time*: 100 moves, minus 7.5 moves per level to a minimum of 25<br />
*Effects*: The psion improves their health. They are immune to the deleterious effects of vitamin deficiency and toxin buildup, heal twice as fast, and cannot suffer from an asthma attack while the power is in effect. In addition, their Health has a 7% chance of going up by 1 every 10 minutes.<br />
*Prerequisites*: Starting power<br />

## Staunch Wound
*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 3000, minus 125 per level to a minimum of 750<br />
*Channeling Time*: 50 moves, minus 3 moves per level to a minimum of 20<br />
*Effects*: With an act of will, the psion closes their wounds. From level 1 to 5, the power has "bandages_power": 1 and "bleed": 7. From level 6 to 11, the power has "bandages_power": 2 and "bleed": 14. At level 12 or above, the power has "bandages_power": 3 and "bleed": 20.<br />
*Prerequisites*: Starting Power<br />

## Medicinal Touch 
*Difficulty*: 3<br />
*Target*: One ally within range 1<br />
*Duration*: 5 minutes and 54 seconds to 25 minutes and 50 seconds, plus 21 seconds to 4 minutes and 58 seconds per power level<br />
*Stamina Cost*: 4000, minus 75 per level to a minimum of 2000<br />
*Channeling Time*: 100 moves, minus 7.5 moves per level to a minimum of 25<br />
*Effects*: Apply the effects of Healthy Glow to a friend or ally. The target gains all the benefits of Healthy Glow for as long as the power lasts.<br />
*Prerequisites*: Healthy Glow 6<br />

## Enervating Touch 
*Difficulty*: 3<br />
*Target*: One enemy within range 1<br />
*Duration*: 4 seconds to 30 seconds, plus 0.5 seconds to 1.5 seconds per power level<br />
*Stamina Cost*: 2000, minus 65 per level to a minimum of 950<br />
*Channeling Time*: 85 moves, minus 3 moves per level to a minimum of 55<br />
*Effects*: Cause decay in the target's tissues causing 1 point of biological damage per second for the power's duration. As well, while the power is in effect, any creature with regeneration has their rate of regeneration cut in half.<br />
*Prerequisites*: Medicinal Touch 5, Coagulation 5<br />

## Detoxification (C)
*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 2 minutes and 36 seconds to 6 minutes and 58 seconds, plus 4 seconds to 32 seconds per power level<br />
*Stamina Cost*: 3500, minus 115 per level to a minimum of 1750<br />
*Channeling Time*: 75 moves, minus 5 moves per level to a minimum of 25<br />
*Effects*: Cures any poison by sweating it out. A short time afer using the power, between 15 seconds (minute 1 second per power level to a minimum of 1) to 2 minutes (minus 2 seconds per power level to a minimum of 1), the psion will begin sweating and the poison will be removed. The psion gains the benefits of the Toxic Flesh trait for the power's duration.<br />
*Prerequisites*: Healthy Glow 8, Staunch Wound 3 *or* Coagulation 7<br />

## Immunostimulus (C) 
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 19 minutes and 8 seconds to 47 minutes and 14 seconds, plus 48 seconds to 5 minutes and 11 seconds per power level<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2500<br />
*Channeling Time*: 500 moves, minus 18 moves per level to a minimum of 50<br />
*Effects*: Kick the psion's immune system into overdrive, helping overcome any diseases they are suffering from. Every 10 minutes (minus 5 seconds per power level) to 60 minutes (minus 30 seconds per power level) while the power is active, the psion has a chance equal to 10% plus the power level to cure one disease they're suffering from. It may take some time before the psion's immune system manages to overcome the disease. In addition, if the psion is suffering from hay fever, the power will make it much worse.<br />
*Prerequisites*: Detoxification 5<br />

## Wakeful Rest
*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 1000<br />
*Channeling Time*: Indefinite<br />
*Effects*: Meditate in lieu of sleep. Using the power will begin the meditating, slowly lowering the psion's fatigue and sleep deprivation ratings. The rate of reduction increases per power level and with the psion's metaphysics skill, with the formula: 1 in (55 - ( Wakeful Rest power level * 2) - Metaphysics skill) ), 15 ) chance per second for fatigue, and 1 per second for sleep deprivation.  When fatigue hits zero, a prompt to cancel the meditation pops up.<br />
*Prerequisites*: Healthy Glow 8, Immunostimulus 4<br />

## Damage Balancing
*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 6500, minus 175 per level to a minimum of 1750<br />
*Channeling Time*: 200 moves, minus 8 moves per level to a minimum of 75<br />
*Effects*: Evens out the damage on all the psion's limbs.  Mechnically, this adds up all their hit points, divides the result by 6, and replaces that hit point total on each limb with that number.<br />
*Prerequisites*: Immunostimulus 5 *or* Detoxification 5, Healthy Glow 10 *or* Coagulation 8<br />

## Allay Infection
*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 5000, minus 145 per level to a minimum of 2250<br />
*Channeling Time*: 350 moves, minus 14 moves per level to a minimum of 125<br />
*Effects*: The psion encourages their immune system to focus entirely on their wounds for a brief period. From level 1 to 5, the power has "bite": 0.5, "disinfectant_power": 1, "infect": 0.4. From level 6 to 11, the power has "bite": 0.7, "disinfectant_power": 2, "infect": 0.6. At level 12 or above, the power has "bite": 0.9, "disinfectant_power": 3, "infect": 0.8.<br />
*Prerequisites*: Immunostimulus 7<br />

## Revitalizing Meditation
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 8000<br />
*Channeling Time*: 1 hour<br />
*Effects*: Sink deep into meditation and increase the speed of healing hundreds of times. When the channeling time ends, the psion heals from 3 to 8 damage to every body part, plus 0.5 to 2 per power level.<br />
*Prerequisites*: Damage Balancing 6, Allay Infection 5<br />

## Lacerating Touch 
*Difficulty*: 6<br />
*Target*: One enemy within range 1<br />
*Duration*: Instant<br />
*Stamina Cost*: 6000, minus 115 per level to a minimum of 2350<br />
*Channeling Time*: 85 moves, minus 3 moves per level to a minimum of 55<br />
*Effects*: Directly cause cellular breakdown in the target, doing 12 to 35 biological damage plus 2 to 4 biological damage per power level, and causing 1 biological damage per second for 4 to 8 seconds plus 0.5 to 1.5 seconds per power level afterwards.<br />
*Prerequisites*: Enervating Touch 8<br />

## Radiation Decontamination
*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 7000, minus 135 per level to a minimum of 4500<br />
*Channeling Time*: 1 minute<br />
*Effects*: Purge irradiated tissue. The duration depends on the exact amount of mSv the psion is suffering from. 500 or more means the power takes 4 hours and 10 minutes, between 499 and 250 takes 2 hours and 5 minutes, bewteen 249 to 125 takes 1 hour and 5 minutes, between 124 and 60 takes 30 minutes, between 59 and 30 takes 15 minutes, and 29 or less takes 7 minutes. During that time, the psion loses 1 mSv of radiation per minute. The psion also suffers increasingly serious side effects for the power duration, including -1 Srength and Dexterity and -0.7 Perception per tier above 29 mSv and incresing chances to vomit, suffer pain, or take Health score penalties.<br />
*Prerequisites*: Special<br />

## Blood Purge
*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 145 per level to a minimum of 4500<br />
*Channeling Time*: 250 moves, minus 8 moves per level to a minimum of 100<br />
*Effects*: Clean the psion's blood of all foreign substances or chemicals. Applies the cureall effect, the same as from Panacea, and also remove all mutagen as well.<br />
*Prerequisites*: Revitalizing Meditation 6, Allay Infection 8 *or* Detoxification 8<br />

## Banish Illness
*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 10000<br />
*Channeling Time*: 5 seconds<br />
*Effects*: Purge mundane illnesses with 100% success rate or have a chance to cure long-term or chronic conditions. The power allows the psion to attempt to cure asthma, chemical imbalance, kalupetic psychosis, jittery, mood swings, weakening, narcolepsy, seasonal allergies, or seasonable affective disorder. The chance depends on the particular condition and increases with power level.<br />
*Prerequisites*: Allay Infection 12, Damage Balancing 8 *or* Immunostimulus 12<br />

## Anabolic Rejuvenation
*Difficulty*: 9<br />
*Target*: Self<br />
*Duration*: 2 minutes and 26 seconds to 6 minutes and 12 seconds, plus 29 seconds to 1 minute and 50 seconds per power level<br />
*Stamina Cost*: 10000, minus 150 per level to a minimum of 6500<br />
*Channeling Time*: 10 seconds<br />
*Effects*: Use up the psion's bodily reserves to speed healing to a preternatural rate. Every 30 seconds, the psion heals one hit point to every body part, but whenever a healing tick occurs, the psion loses between 50 and 250 kCal, 50 to 200 units of iron, 100 to 200 units of calcium, 20 to 80 units of vitamin C, and gains 2 to 10 points of fatigue.<br />
*Prerequisites*: Healthy Glow 14 *or* Revitalizing Meditation 9, Damage Balancing 10 *or* Detoxification 7 *or* Blood Purge 5<br />

## Accelerated Resuscitation
*Difficulty*: 10<br />
*Target*: Self<br />
*Duration*: 1 hour 6 minutes and 2 minutes and 18 seconds to 3 hours and 26 minutes, plus 16 minutes and 2 seconds to 46 minutes and 59 seconds per power level<br />
*Stamina Cost*: 9000, minus 125 per level to a minimum of 6000<br />
*Channeling Time*: 30 seconds<br />
*Effects*: Prepare the psion's body for a potentially fatal shock. If the psion takes fatal damage while this power is maintained, any body part below 5 hit points will be healed to 5 hit points, their gain the effects of Damage Balancing, and a much faster Anabolic Rejuvenation is placed on them, ticking once every 2 seconds for 20 seconds. However, the psion's total stored kCal is reduced by 20% to fuel the resuscitation, and each Anabolic Rejuvenation costs 5x the kCal, iron, etc that it would if the psion had used Anabolic Rejuvenation.<br />
*Prerequisites*: Anabolic Rejuvenation 6 *or* Banish Illness 8 *and* Revitalizing Meditation 6<br />
