/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.DataTypeFilteringDTVImpl;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public final class SQLServerDatabaseMetaData
implements DatabaseMetaData,
Serializable {
    private SQLServerConnection connection;
    private SQLServerStatement stmt;
    static final String urlprefix = "jdbc:sqlserver://";
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char ESCAPE = '\\';
    static final char PERCENT = '%';
    static final char UNDERSCORE = '_';
    static final char[] DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};

    public SQLServerDatabaseMetaData(SQLServerConnection sQLServerConnection) {
        this.connection = sQLServerConnection;
    }

    private void checkClosed() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionClosed"), null, false);
        }
    }

    private ResultSet emptyResultSet() throws SQLServerException {
        this.stmt = this.connection.createInternalStatement();
        return new SQLServerResultSet(this.stmt);
    }

    private ResultSet getResultSet(String string) throws SQLServerException {
        this.stmt = this.connection.createInternalStatement();
        return this.stmt.executeQuery(string);
    }

    final String paramString(String string, String string2, String string3, String string4, boolean bl, String string5) {
        String string6 = " ";
        String string7 = string;
        if (string7 == null) {
            string7 = "";
        }
        String string8 = "";
        string8 = "table_";
        string6 = string2 != null ? string6 + "@" + string7 + string8 + "qualifier = '" + string2 + "'" : string6 + "@" + string7 + string8 + "qualifier = null";
        string6 = string3 != null ? string6 + ", @" + string7 + string8 + "owner" + " = '" + string3 + "'" : string6 + ", @" + string7 + string8 + "owner" + " = null";
        string6 = string4 != null ? string6 + ", @" + string7 + string8 + "name" + " = '" + string4 + "'" : string6 + ", @" + string7 + string8 + "name" + " = null";
        if (bl) {
            string6 = string5 != null ? string6 + ", @" + string7 + "column_name = '" + string5 + "'" : string6 + ", @" + string7 + "column_name = null";
        }
        return string6 + " ";
    }

    private String switchCatalogs(String string) throws SQLServerException {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = null;
        string3 = this.connection.getCatalog().trim();
        if (string3.equals(string2 = string.trim())) {
            return null;
        }
        this.connection.setCatalog(string2);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        return string3;
    }

    public boolean allProceduresAreCallable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public ResultSet getCatalogs() throws SQLServerException {
        this.checkClosed();
        String string = "SELECT name AS TABLE_CAT FROM master.dbo.sysdatabases order by name";
        return this.getResultSet(string);
    }

    public String getCatalogSeparator() throws SQLServerException {
        this.checkClosed();
        return ".";
    }

    public String getCatalogTerm() throws SQLServerException {
        this.checkClosed();
        return "database";
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String string5 = null;
        try {
            string5 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        string4 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        String string6 = "exec sp_column_privileges " + this.paramString(null, string, string2, string3, true, string4);
        ResultSet resultSet = this.getResultSet(string6);
        this.stmt.columns[0].name = "TABLE_CAT";
        this.stmt.columns[1].name = "TABLE_SCHEM";
        if (string5 != null) {
            this.connection.setCatalog(string5);
        }
        return resultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLServerException {
        Object object;
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String string5 = this.paramString(null, string, string2, string3, false, null);
        if (stringArray != null) {
            object = "'";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    object = (String)object + ",";
                }
                object = (String)object + "''" + stringArray[i] + "''";
            }
            object = (String)object + "'";
            string5 = string5 + ", @table_type = " + (String)object;
        }
        object = this.getResultSet("exec sp_tables " + string5);
        SQLServerStatement sQLServerStatement = this.stmt;
        if (sQLServerStatement != null && sQLServerStatement.columns != null) {
            if (sQLServerStatement.columns[0] != null) {
                sQLServerStatement.columns[0].name = "TABLE_CAT";
            }
            if (sQLServerStatement.columns[1] != null) {
                sQLServerStatement.columns[1].name = "TABLE_SCHEM";
            }
        }
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        return object;
    }

    private static String EscapeIDName(String string) throws SQLServerException {
        if (null == string) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\\' == c && ++i < string.length()) {
                c = string.charAt(i);
                switch (c) {
                    case '%': 
                    case '[': 
                    case '_': {
                        stringBuffer.append('[');
                        stringBuffer.append(c);
                        stringBuffer.append(']');
                        break;
                    }
                    case '\\': 
                    case ']': {
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String string5 = null;
        try {
            string5 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string6 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String string7 = "exec sp_columns ";
        String string8 = this.paramString(null, string, string2, string3, true, string6) + ",@ODBCVer=3";
        SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.getResultSet(string7 + string8);
        this.stmt.columns[0].name = "TABLE_CAT";
        this.stmt.columns[1].name = "TABLE_SCHEM";
        this.stmt.columns[6].name = "COLUMN_SIZE";
        this.stmt.columns[7].name = "BUFFER_LENGTH";
        this.stmt.columns[8].name = "DECIMAL_DIGITS";
        this.stmt.columns[9].name = "NUM_PREC_RADIX";
        if (string5 != null) {
            this.connection.setCatalog(string5);
        }
        sQLServerResultSet.getColumn(5).setFilter(new DataTypeFilteringDTVImpl());
        return sQLServerResultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = this.paramString(null, string, string2, string3, false, null) + ",@ODBCVer=3 ";
        string5 = string5 + ", @col_type = 'R'";
        if (n != 0) {
            string5 = string5 + ", @scope = 'T'";
        }
        string5 = bl ? string5 + ", @nullable = 'U'" : string5 + ", @nullable = 'O'";
        SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.getResultSet("exec sp_special_columns " + string5);
        this.stmt.columns[4].name = "COLUMN_SIZE";
        this.stmt.columns[5].name = "BUFFER_LENGTH";
        this.stmt.columns[6].name = "DECIMAL_DIGITS";
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        sQLServerResultSet.getColumn(3).setFilter(new DataTypeFilteringDTVImpl());
        return sQLServerResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLServerException {
        this.checkClosed();
        String string7 = null;
        try {
            string7 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string8 = this.paramString("pk", string, string2, string3, false, null);
        String string9 = this.paramString("fk", string4, string5, string6, false, null);
        ResultSet resultSet = this.getResultSet("exec sp_fkeys " + string8 + "," + string9);
        if (string7 != null) {
            this.connection.setCatalog(string7);
        }
        this.stmt.columns[0].name = "PKTABLE_CAT";
        this.stmt.columns[1].name = "PKTABLE_SCHEM";
        this.stmt.columns[4].name = "FKTABLE_CAT";
        this.stmt.columns[5].name = "FKTABLE_SCHEM";
        return resultSet;
    }

    public String getDatabaseProductName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft SQL Server";
    }

    public String getDatabaseProductVersion() throws SQLServerException {
        this.checkClosed();
        return this.connection.sqlServerVersion;
    }

    public int getDefaultTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return 2;
    }

    public int getDriverMajorVersion() {
        return Util.majorVersion();
    }

    public int getDriverMinorVersion() {
        try {
            Integer n = new Integer(Util.minorVersion());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getDriverName() throws SQLServerException {
        this.checkClosed();
        String string = "Microsoft SQL Server 2005 JDBC Driver";
        return string;
    }

    public String getDriverVersion() throws SQLServerException {
        int n = this.getDriverMinorVersion();
        String string = this.getDriverMajorVersion() + ".";
        string = string + "" + n;
        string = string + ".";
        string = string + 1501;
        string = string + ".";
        string = string + 101;
        return string;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = this.paramString("pk", string, string2, string3, false, null);
        ResultSet resultSet = this.getResultSet("exec sp_fkeys " + string5);
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        this.stmt.columns[0].name = "PKTABLE_CAT";
        this.stmt.columns[1].name = "PKTABLE_SCHEM";
        this.stmt.columns[4].name = "FKTABLE_CAT";
        this.stmt.columns[5].name = "FKTABLE_SCHEM";
        return resultSet;
    }

    public String getExtraNameCharacters() throws SQLServerException {
        this.checkClosed();
        return "$#@";
    }

    public String getIdentifierQuoteString() throws SQLServerException {
        this.checkClosed();
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = this.paramString("fk", string, string2, string3, false, null);
        ResultSet resultSet = this.getResultSet("exec sp_fkeys " + string5);
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        this.stmt.columns[0].name = "PKTABLE_CAT";
        this.stmt.columns[1].name = "PKTABLE_SCHEM";
        this.stmt.columns[4].name = "FKTABLE_CAT";
        this.stmt.columns[5].name = "FKTABLE_SCHEM";
        return resultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = this.paramString(null, string, string2, string3, false, null);
        string5 = bl ? string5 + ",@is_unique = 'Y'" : string5 + ",@is_unique = 'F'";
        ResultSet resultSet = this.getResultSet("exec sp_statistics " + string5);
        this.stmt.columns[0].name = "TABLE_CAT";
        this.stmt.columns[1].name = "TABLE_SCHEM";
        this.stmt.columns[7].name = "ORDINAL_POSITION";
        this.stmt.columns[9].name = "ASC_OR_DESC";
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        return resultSet;
    }

    public int getMaxBinaryLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxCharLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLServerException {
        this.checkClosed();
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLServerException {
        this.checkClosed();
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLServerException {
        this.checkClosed();
        return 1024;
    }

    public int getMaxConnections() throws SQLServerException {
        this.checkClosed();
        if (this.connection.getDbCom().getTDSVersion().isYukonOrLater()) {
            try {
                String string = "sp_configure 'user connections'";
                SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.getResultSet(string);
                if (!sQLServerResultSet.next()) {
                    return 0;
                }
                return sQLServerResultSet.getInt("maximum");
            }
            catch (SQLServerException sQLServerException) {
                return 0;
            }
        }
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxIndexLength() throws SQLServerException {
        this.checkClosed();
        return 900;
    }

    public int getMaxProcedureNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxRowSize() throws SQLServerException {
        this.checkClosed();
        return 8060;
    }

    public int getMaxSchemaNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxStatementLength() throws SQLServerException {
        this.checkClosed();
        return 65536 * this.connection.getTDSPacketSize();
    }

    public int getMaxStatements() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxTableNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLServerException {
        this.checkClosed();
        return 256;
    }

    public int getMaxUserNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public String getNumericFunctions() throws SQLServerException {
        this.checkClosed();
        if (this.connection.getDbCom().getTDSVersion().isYukonOrLater()) {
            return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
        }
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = this.paramString(null, string, string2, string3, false, null);
        ResultSet resultSet = this.getResultSet("exec sp_pkeys " + string5);
        this.stmt.columns[0].name = "TABLE_CAT";
        this.stmt.columns[1].name = "TABLE_SCHEM";
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        return resultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String string5 = null;
        try {
            string5 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string6 = " ";
        string6 = string != null ? string6 + "@procedure_qualifier = '" + string + "'" : string6 + "@procedure_qualifier = null";
        string6 = string2 != null ? string6 + ", @procedure_owner = '" + string2 + "'" : string6 + ", @procedure_owner = null";
        string6 = string3 != null ? string6 + ", @procedure_name = '" + string3 + "'" : string6 + ", @procedure_name = null";
        string6 = string4 != null ? string6 + ", @column_name = '" + string4 + "'" : string6 + ", @column_name = null";
        SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.getResultSet("exec sp_sproc_columns " + string6 + ", @ODBCVer=3");
        this.stmt.columns[0].name = "PROCEDURE_CAT";
        this.stmt.columns[1].name = "PROCEDURE_SCHEM";
        sQLServerResultSet.getColumn(6).setFilter(new DataTypeFilteringDTVImpl());
        if (string5 != null) {
            this.connection.setCatalog(string5);
        }
        return sQLServerResultSet;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = " ";
        string5 = string != null ? string5 + "@sp_qualifier = '" + string + "'" : string5 + "@sp_qualifier = null";
        string5 = string2 != null ? string5 + ", @sp_owner = '" + string2 + "'" : string5 + ", @sp_owner = null";
        string5 = string3 != null ? string5 + ", @sp_name = '" + string3 + "'" : string5 + ", @sp_name = null";
        ResultSet resultSet = this.getResultSet("exec sp_stored_procedures " + string5);
        this.stmt.columns[0].name = "PROCEDURE_CAT";
        this.stmt.columns[1].name = "PROCEDURE_SCHEM";
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        return resultSet;
    }

    public String getProcedureTerm() throws SQLServerException {
        this.checkClosed();
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLServerException {
        String string;
        this.checkClosed();
        if (this.connection.getDbCom().getTDSVersion().isYukonOrLater()) {
            string = "select sys.database_principals.name 'TABLE_SCHEM', sys.database_principals.default_schema_name 'TABLE_CATALOG' from sys.database_principals";
            string = string + " where not sid is null order by sys.database_principals.name";
        } else {
            string = "select sysusers.name 'TABLE_SCHEM' from sysusers where not ";
            string = string + "sid";
            string = string + " is null order by sysusers.name";
        }
        ResultSet resultSet = this.getResultSet(string);
        return resultSet;
    }

    public String getSchemaTerm() throws SQLServerException {
        this.checkClosed();
        return "schema";
    }

    public String getSearchStringEscape() throws SQLServerException {
        this.checkClosed();
        return "\\";
    }

    public String getSQLKeywords() throws SQLServerException {
        this.checkClosed();
        return "BACKUP,BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMPUTE,CONTAINS,CONTAINSTABLE,DATABASE,DBCC,DENY,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,EXIT,FILE,FILLFACTOR,FREETEXT,FREETEXTTABLE,FUNCTION,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,NOCHECK,NONCLUSTERED,OFF,OFFSETS,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OVER,PERCENT,PLAN,PRINT,PROC,RAISERROR,READTEXT,RECONFIGURE,REPLICATION,RESTORE,RETURN,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SETUSER,SHUTDOWN,STATISTICS,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUAL,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLServerException {
        this.checkClosed();
        return "ASCII,CHAR,CONCAT, DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLServerException {
        this.checkClosed();
        return "DATABASE,IFNULL,USER";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String string5 = "exec sp_table_privileges " + this.paramString(null, string, string2, string3, false, null);
        ResultSet resultSet = this.getResultSet(string5);
        this.stmt.columns[0].name = "TABLE_CAT";
        this.stmt.columns[1].name = "TABLE_SCHEM";
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        return resultSet;
    }

    public ResultSet getTableTypes() throws SQLServerException {
        this.checkClosed();
        String string = "SELECT 'VIEW' 'TABLE_TYPE' UNION SELECT 'TABLE' UNION SELECT 'SYSTEM TABLE'";
        ResultSet resultSet = this.getResultSet(string);
        return resultSet;
    }

    public String getTimeDateFunctions() throws SQLServerException {
        this.checkClosed();
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    public ResultSet getTypeInfo() throws SQLServerException {
        this.checkClosed();
        SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.getResultSet("sp_datatype_info @ODBCVer=3");
        this.stmt.columns[10].name = "FIXED_PREC_SCALE";
        sQLServerResultSet.getColumn(2).setFilter(new DataTypeFilteringDTVImpl());
        return sQLServerResultSet;
    }

    public String getURL() throws SQLServerException {
        this.checkClosed();
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.connection.activeConnectionProperties;
        String string = null;
        String string2 = null;
        String string3 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.equals("integratedSecurity") || string4.equals("user") || string4.equals("password")) continue;
            String string5 = properties.getProperty(string4);
            if (string4.equals("serverName")) {
                string = string5;
                continue;
            }
            if (string4.equals("instanceName")) {
                string3 = string5;
                continue;
            }
            if (string4.equals("portNumber")) {
                string2 = string5;
                continue;
            }
            stringBuffer.append(string4);
            stringBuffer.append("=");
            stringBuffer.append(string5);
            stringBuffer.append(";");
        }
        stringBuffer.insert(0, ";");
        stringBuffer.insert(0, string2);
        stringBuffer.insert(0, ":");
        if (null != string3) {
            stringBuffer.insert(0, string3);
            stringBuffer.insert(0, "\\");
        }
        stringBuffer.insert(0, string);
        stringBuffer.insert(0, urlprefix);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLServerException {
        String string;
        SQLServerStatement sQLServerStatement;
        block9: {
            SQLServerResultSet sQLServerResultSet;
            block7: {
                String string2;
                block8: {
                    this.checkClosed();
                    sQLServerStatement = null;
                    sQLServerResultSet = null;
                    string = "";
                    try {
                        sQLServerStatement = this.connection.createInternalStatement();
                        sQLServerResultSet = (SQLServerResultSet)sQLServerStatement.executeQuery("select system_user");
                        if (sQLServerResultSet.next()) break block7;
                        string2 = null;
                        Object var6_5 = null;
                        if (sQLServerResultSet == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (sQLServerResultSet != null) {
                            sQLServerResultSet.close();
                        }
                        if (sQLServerStatement != null) {
                            sQLServerStatement.close();
                        }
                        throw throwable;
                    }
                    sQLServerResultSet.close();
                }
                if (sQLServerStatement != null) {
                    sQLServerStatement.close();
                }
                return string2;
            }
            string = sQLServerResultSet.getString(1);
            Object var6_6 = null;
            if (sQLServerResultSet == null) break block9;
            sQLServerResultSet.close();
        }
        if (sQLServerStatement != null) {
            sQLServerStatement.close();
        }
        return string;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String string4 = null;
        try {
            string4 = this.switchCatalogs(string);
        }
        catch (SQLException sQLException) {
            return this.emptyResultSet();
        }
        String string5 = this.paramString(null, string, string2, string3, false, null);
        string5 = string5 + " ,@ODBCVer=3, @col_type= 'V', @scope ='T', @nullable = 'U'";
        SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.getResultSet("exec sp_special_columns " + string5);
        this.stmt.columns[4].name = "COLUMN_SIZE";
        this.stmt.columns[5].name = "BUFFER_LENGTH";
        this.stmt.columns[6].name = "DECIMAL_DIGITS";
        if (string4 != null) {
            this.connection.setCatalog(string4);
        }
        sQLServerResultSet.getColumn(3).setFilter(new DataTypeFilteringDTVImpl());
        return sQLServerResultSet;
    }

    public boolean isCatalogAtStart() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLServerException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 4096: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsUnion() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsUnionAll() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean usesLocalFiles() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLServerException {
        this.checkClosed();
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLServerException {
        this.checkClosed();
        switch (n) {
            case 1003: 
            case 1005: 
            case 1006: 
            case 2004: {
                return true;
            }
            case 1004: 
            case 2003: {
                return 1007 == n2;
            }
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        return n == 1006 || 1003 == n || 2004 == n;
    }

    public boolean updatesAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        return 1005 == n;
    }

    public boolean insertsAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLServerException {
        this.checkClosed();
        ResultSet resultSet = this.getResultSet("exec sp_tables @table_qualifier = null, @table_owner = null, @table_name = 'getUDTDummy'");
        int n = 7;
        Column[] columnArray = new Column[n];
        int n2 = 0;
        columnArray[n2++] = new Column("TYPE_CAT");
        columnArray[n2++] = new Column("TYPE_SCHEM");
        columnArray[n2++] = new Column("TYPE_NAME");
        columnArray[n2++] = new Column("CLASS_NAME");
        columnArray[n2++] = new Column("DATA_TYPE");
        columnArray[n2++] = new Column("REMARKS");
        columnArray[n2++] = new Column("BASE_TYPE");
        this.stmt.columns = columnArray;
        return resultSet;
    }

    public Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection;
    }

    public int getSQLStateType() throws SQLServerException {
        this.checkClosed();
        if (this.connection != null && this.connection.xopenStates) {
            return 1;
        }
        return 2;
    }

    public int getDatabaseMajorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getDatabaseMinorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        if (n > 0 && n2 > 0) {
            string = string.substring(n + 1, n2);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getJDBCMajorVersion() throws SQLServerException {
        this.checkClosed();
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return 1;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        return this.emptyResultSet();
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        return this.emptyResultSet();
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        return this.emptyResultSet();
    }

    public boolean supportsGetGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsNamedParameters() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSavepoints() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkClosed();
        return true;
    }
}

