/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.graalvm.visualvm.lib.ui.cpu.statistics.StatisticalModule;

public class StatisticalModuleContainer
implements CPUCCTProvider.Listener {
    private final Set modules = new HashSet();

    public Collection getAllModules() {
        return new ArrayList(this.modules);
    }

    public void addModule(StatisticalModule module) {
        this.modules.add(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cctEstablished(RuntimeCCTNode appNode, boolean empty) {
        HashSet tmpModules;
        if (empty) {
            return;
        }
        if (!(appNode instanceof RuntimeCPUCCTNode)) {
            return;
        }
        Set set = this.modules;
        synchronized (set) {
            if (this.modules.isEmpty()) {
                return;
            }
            tmpModules = new HashSet(this.modules);
        }
        Iterator iter = tmpModules.iterator();
        while (iter.hasNext()) {
            ((StatisticalModule)iter.next()).refresh((RuntimeCPUCCTNode)appNode);
        }
    }

    public void cctReset() {
        this.cctEstablished(null, false);
    }

    public void removeAllModules() {
        this.modules.clear();
    }

    public void removeModule(StatisticalModule module) {
        this.modules.remove(module);
    }
}

