/* riemann/communicate.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/riemann-client.h>

#ifdef __cplusplus
extern "C" {
#endif

int riemann_send (riemann_client_t *client,
                  riemann_event_field_t field, ...);
int riemann_send_va (riemann_client_t *client,
                     riemann_event_field_t field, va_list aq);

riemann_message_t *riemann_query (riemann_client_t *client,
                                  const char *query);

riemann_message_t *riemann_communicate (riemann_client_t *client,
                                        riemann_message_t *message);
riemann_message_t *riemann_communicate_query (riemann_client_t *client,
                                              const char *query_string);
riemann_message_t *riemann_communicate_event (riemann_client_t *client,
                                              riemann_event_field_t field, ...);
riemann_message_t *riemann_communicate_events_n (riemann_client_t *client,
                                                 size_t n_events,
                                                 riemann_event_t **events);

#ifdef __cplusplus
}
#endif
