/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 % 12) => 0
 * (12 % 76) => 12
 * (76 % 12) => 4
 * (76 % 76) => 0
 * (0 % 12) => 0
 * (0 % 76) => 0
 */
#version 130

void main()
{
  float[(12 % 12) == 0 ? 1 : -1] array0;
  float[(12 % 76) == 12 ? 1 : -1] array1;
  float[(76 % 12) == 4 ? 1 : -1] array2;
  float[(76 % 76) == 0 ? 1 : -1] array3;
  float[(0 % 12) == 0 ? 1 : -1] array4;
  float[(0 % 76) == 0 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
