/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getpreviousrowfield;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getpreviousrowfield.GetPreviousRowField;
import org.pentaho.di.trans.steps.getpreviousrowfield.GetPreviousRowFieldData;
import org.pentaho.di.trans.steps.getpreviousrowfield.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPreviousRowFieldMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String schema;
    private String[] fieldInStream;
    private String[] fieldOutStream;

    public String[] getFieldInStream() {
        return this.fieldInStream;
    }

    public void setFieldInStream(String[] keyStream) {
        this.fieldInStream = keyStream;
    }

    public String[] getFieldOutStream() {
        return this.fieldOutStream;
    }

    public void setFieldOutStream(String[] keyStream) {
        this.fieldOutStream = keyStream;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrkeys) {
        this.fieldInStream = new String[nrkeys];
        this.fieldOutStream = new String[nrkeys];
    }

    @Override
    public Object clone() {
        GetPreviousRowFieldMeta retval = (GetPreviousRowFieldMeta)super.clone();
        int nrkeys = this.fieldInStream.length;
        retval.allocate(nrkeys);
        for (int i = 0; i < nrkeys; ++i) {
            retval.fieldInStream[i] = this.fieldInStream[i];
            retval.fieldOutStream[i] = this.fieldOutStream[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"field");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"field", (int)i);
                this.fieldInStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"out_stream_name"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("GetPreviousRowFieldMeta.Exception.UnableToReadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldInStream = null;
        this.fieldOutStream = null;
        this.schema = "";
        int nrkeys = 0;
        this.allocate(nrkeys);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldInStream.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"in_stream_name", (String)this.fieldInStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"out_stream_name", (String)this.fieldOutStream[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.schema = rep.getStepAttributeString(id_step, "schema");
            int nrkeys = rep.countNrStepAttributes(id_step, "in_stream_name");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                this.fieldInStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "out_stream_name"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetPreviousRowFieldMeta.Exception.UnexpectedErrorInReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schema);
            for (int i = 0; i < this.fieldInStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "in_stream_name", this.fieldInStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "out_stream_name", this.fieldOutStream[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GetPreviousRowFieldMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.fieldOutStream.length; ++i) {
            int index;
            if (Const.isEmpty((String)this.fieldOutStream[i]) || (index = inputRowMeta.indexOfValue(this.fieldInStream[i])) < 0) continue;
            ValueMetaInterface in = inputRowMeta.getValueMeta(index);
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.fieldOutStream[i]), in.getType());
            v.setName(space.environmentSubstitute(this.fieldOutStream[i]));
            v.setLength(in.getLength());
            v.setPrecision(in.getPrecision());
            v.setConversionMask(in.getConversionMask());
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        String error_message = "";
        boolean first = true;
        boolean error_found = false;
        if (prev == null) {
            error_message = error_message + Messages.getString("TrimMeta.CheckResult.NoInputReceived") + Const.CR;
            CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            int idx;
            String field;
            int i;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                ValueMetaInterface v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + Messages.getString("GetPreviousRowFieldMeta.CheckResult.MissingInStreamFields") + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            CheckResult cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("GetPreviousRowFieldMeta.CheckResult.FoundInStreamFields"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            first = true;
            error_found = false;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldOutStream[i];
                if (!Const.isEmpty((String)field)) continue;
                if (first) {
                    first = false;
                    error_message = Messages.getString("GetPreviousRowFieldMeta.CheckResult.OutputFieldEmpty", "" + i) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("GetPreviousRowFieldMeta.CheckResult.OutputFieldSpecified"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            if (this.fieldInStream.length > 0) {
                for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                    if (!Const.isEmpty((String)this.fieldInStream[idx])) continue;
                    cr = new CheckResult(4, Messages.getString("GetPreviousRowFieldMeta.CheckResult.InStreamFieldMissing", new Integer(idx + 1).toString()), (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                for (int jdx = 0; jdx < this.fieldInStream.length; ++jdx) {
                    if (!this.fieldInStream[idx].equals(this.fieldInStream[jdx]) || idx == jdx || idx >= jdx) continue;
                    error_message = Messages.getString("GetPreviousRowFieldMeta.CheckResult.FieldInputError", this.fieldInStream[idx]);
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetPreviousRowField(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetPreviousRowFieldData();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schemaName) {
        this.schema = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

