/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

public abstract class TruffleType<O extends TruffleObject> {
    public static final DataType<String> TYPE_NAME = new DataType(String.class, null, null);
    private final String name;
    protected int count;
    protected long size;
    protected long retained = (Long)DataType.RETAINED_SIZE.getNotAvailableValue();

    public TruffleType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getObjectsCount() {
        return this.count;
    }

    public long getAllObjectsSize() {
        return this.size;
    }

    public long getRetainedSizeByType(Heap heap) {
        if (this.retained < 0L && DataType.RETAINED_SIZE.valuesAvailable(heap)) {
            this.retained = 0L;
            Iterator<O> objects = this.getObjectsIterator();
            while (objects.hasNext()) {
                this.retained += ((TruffleObject)objects.next()).getRetainedSize();
            }
        }
        return this.retained;
    }

    public abstract Iterator<O> getObjectsIterator();

    protected void addObject(O object, long objectSize, long objectRetainedSize) {
        ++this.count;
        this.size += objectSize;
        if (objectRetainedSize >= 0L) {
            if (this.retained < 0L) {
                this.retained = 0L;
            }
            this.retained += objectRetainedSize;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TruffleType)) {
            return false;
        }
        return this.name.equals(((TruffleType)o).name);
    }

    public static class TypesComputer<O extends TruffleObject, T extends TruffleType<O>> {
        private final boolean retainedAvailable;
        private final TruffleLanguage<O, T, ? extends TruffleLanguageHeapFragment<O, T>> language;
        private final Heap heap;
        private final Map<String, T> cache;
        private final Map<Long, String> typeCache;

        public TypesComputer(TruffleLanguage<O, T, ? extends TruffleLanguageHeapFragment<O, T>> language, Heap heap) {
            this.language = language;
            this.heap = heap;
            this.cache = new HashMap<String, T>();
            this.typeCache = new HashMap<Long, String>();
            this.retainedAvailable = DataType.RETAINED_SIZE.valuesAvailable(heap);
        }

        protected void addingObject(long size, long retained, String type) {
        }

        public final void addObject(O object) {
            long objectSize = ((TruffleObject)object).getSize();
            long objectRetainedSize = this.retainedAvailable ? ((TruffleObject)object).getRetainedSize() : ((Long)DataType.RETAINED_SIZE.getNotAvailableValue()).longValue();
            String typeName = this.getTypeName(object);
            this.addingObject(objectSize, objectRetainedSize, typeName);
            TruffleType<Object> type = (TruffleType)this.cache.get(typeName);
            if (type == null) {
                type = this.language.createType(typeName);
                this.cache.put(typeName, type);
            }
            type.addObject(object, objectSize, objectRetainedSize);
        }

        public final List<T> getTypes() {
            return Collections.unmodifiableList(new ArrayList<T>(this.cache.values()));
        }

        private String getTypeName(O object) {
            Long typeId = ((TruffleObject)object).getTypeId();
            String typeName = this.typeCache.get(typeId);
            if (typeName == null) {
                typeName = ((TruffleObject)object).getType();
                this.typeCache.put(typeId, typeName);
            }
            return typeName;
        }
    }

    public static abstract class InstanceBased<O extends TruffleObject.InstanceBased>
    extends TruffleType<O> {
        private final List<Instance> instances = new ArrayList<Instance>();

        public InstanceBased(String name) {
            super(name);
        }

        protected abstract O createObject(Instance var1);

        @Override
        protected void addObject(O object, long objectSize, long objectRetainedSize) {
            super.addObject(object, objectSize, objectRetainedSize);
            this.instances.add(((TruffleObject.InstanceBased)object).getInstance());
        }

        @Override
        public Iterator<O> getObjectsIterator() {
            return new Iterator<O>(){
                private final Iterator<Instance> i;
                {
                    this.i = instances.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public O next() {
                    return this.createObject(this.i.next());
                }
            };
        }
    }
}

