/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import java.util.Collections;
import java.util.Iterator;

public class EmptyNode
extends ChildrenNode
implements Node {
    private static final EmptyNode empty = new EmptyNode();

    private EmptyNode() {
    }

    public static EmptyNode Empty() {
        return empty;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public Node getPriority() {
        return this;
    }

    @Override
    public Node getChild(Path path) {
        return this;
    }

    @Override
    public Node getImmediateChild(ChildKey name) {
        return this;
    }

    @Override
    public Node updateImmediateChild(ChildKey name, Node node) {
        if (node.isEmpty()) {
            return this;
        }
        if (name.isPriorityChildName()) {
            return this;
        }
        return new ChildrenNode().updateImmediateChild(name, node);
    }

    @Override
    public Node updateChild(Path path, Node node) {
        if (path.isEmpty()) {
            return node;
        }
        ChildKey name = path.getFront();
        Node newImmediateChild = this.getImmediateChild(name).updateChild(path.popFront(), node);
        return this.updateImmediateChild(name, newImmediateChild);
    }

    @Override
    public EmptyNode updatePriority(Node priority) {
        return this;
    }

    @Override
    public boolean hasChild(ChildKey name) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Object getValue(boolean useExportFormat) {
        return null;
    }

    @Override
    public ChildKey getPredecessorChildKey(ChildKey childKey) {
        return null;
    }

    @Override
    public ChildKey getSuccessorChildKey(ChildKey childKey) {
        return null;
    }

    @Override
    public String getHash() {
        return "";
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        return "";
    }

    @Override
    public Iterator<NamedNode> iterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<NamedNode> reverseIterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int compareTo(Node o) {
        return o.isEmpty() ? 0 : -1;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof EmptyNode) {
            return true;
        }
        return o instanceof Node && ((Node)o).isEmpty() && this.getPriority().equals(((Node)o).getPriority());
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "<Empty Node>";
    }
}

