/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SQLServerPooledConnection
implements PooledConnection {
    private Vector listeners;
    private SQLServerDataSource factoryDataSource;
    private boolean connectionAvailable;
    private SQLServerConnection physicalConnection;
    private String factoryUser;
    private String factoryPassword;
    private Logger pcLogger;
    private static int basePooledConnectionID = 0;
    int pooledConnectionID = SQLServerPooledConnection.nextPooledConnectionID();

    SQLServerPooledConnection(SQLServerDataSource sQLServerDataSource, String string, String string2) throws SQLException {
        this.pcLogger = SQLServerDataSource.dsLogger;
        this.factoryDataSource = sQLServerDataSource.cloneInternal();
        this.factoryUser = string;
        this.factoryPassword = string2;
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " Start create new connection for pool.");
        }
        this.physicalConnection = this.createNewConnection();
        this.listeners = new Vector();
        this.connectionAvailable = true;
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " End create new connection for pool, cID:" + this.safeCID());
        }
    }

    private SQLServerConnection createNewConnection() throws SQLException {
        return this.factoryDataSource.getConnectionInternal(this.factoryUser, this.factoryPassword, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " user:(default).");
        }
        SQLServerPooledConnection sQLServerPooledConnection = this;
        synchronized (sQLServerPooledConnection) {
            if (this.physicalConnection == null) {
                throw new SQLException(SQLServerException.getErrString("R_physicalConnectionIsClosed"));
            }
            if (this.connectionAvailable) {
                this.physicalConnection.getSecurityManager().checkConnect();
                this.connectionAvailable = false;
                if (this.pcLogger.isLoggable(Level.FINE)) {
                    this.pcLogger.fine("pcID:" + this.pooledConnectionID + " Reusing physical connection, cID:" + this.safeCID());
                }
                this.physicalConnection.bIsOpen = true;
                return this.physicalConnection;
            }
            if (this.pcLogger.isLoggable(Level.FINE)) {
                this.pcLogger.fine("pcID:" + this.pooledConnectionID + " Detaching physical connection, cID:" + this.safeCID());
            }
            SQLServerConnection sQLServerConnection = this.physicalConnection;
            this.physicalConnection = null;
            sQLServerConnection.DetachFromPool();
            sQLServerConnection.close();
            if (this.pcLogger.isLoggable(Level.FINE)) {
                this.pcLogger.fine("pcID:" + this.pooledConnectionID + " Start create new connection for pool.");
            }
            this.physicalConnection = this.createNewConnection();
            if (this.pcLogger.isLoggable(Level.FINE)) {
                this.pcLogger.fine("pcID:" + this.pooledConnectionID + " End create new connection for pool, cID:" + this.safeCID());
            }
            return this.physicalConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEvent(Exception exception) {
        Object object;
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " Exception:" + exception + " cID:" + this.safeCID());
        }
        if (null == exception) {
            object = this;
            synchronized (object) {
                this.connectionAvailable = true;
            }
        }
        object = this.listeners;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.elementAt(i);
                if (connectionEventListener == null) continue;
                ConnectionEvent connectionEvent = new ConnectionEvent(this, (SQLException)exception);
                if (null == exception) {
                    if (this.pcLogger.isLoggable(Level.FINE)) {
                        this.pcLogger.fine("pcID:" + this.pooledConnectionID + " notifyEvent:connectionClosed cID:" + this.safeCID());
                    }
                    connectionEventListener.connectionClosed(connectionEvent);
                    continue;
                }
                if (this.pcLogger.isLoggable(Level.FINE)) {
                    this.pcLogger.fine("pcID:" + this.pooledConnectionID + " notifyEvent:connectionErrorOccurred cID:" + this.safeCID());
                }
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " cID:" + this.safeCID());
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " Closing physical connection, cID:" + this.safeCID());
        }
        Object object = this;
        synchronized (object) {
            if (null != this.physicalConnection) {
                this.physicalConnection.DetachFromPool();
                this.physicalConnection.close();
            }
            this.physicalConnection = null;
            this.connectionAvailable = false;
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine("pcID:" + this.pooledConnectionID + " cID:" + this.safeCID());
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(connectionEventListener);
        }
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private static synchronized int nextPooledConnectionID() {
        return ++basePooledConnectionID;
    }

    private String safeCID() {
        if (null == this.physicalConnection) {
            return "(null)";
        }
        return new Integer(this.physicalConnection.connectionID).toString();
    }
}

