#!/usr/bin/env python3

import os
import re
import sys
from concurrent.futures import ThreadPoolExecutor, as_completed

def remove_prefix(i, d=0):
    if d == 100:
        return 2
    s = os.popen('llvm-lit -a ' + i).read()
    r = re.search('no check strings found with (?:prefix|prefixes) \'([^:]+)', s)
    with open(i, 'r+') as f:
        s = f.read()
        if r:
            p = r.group(1)
            s = re.sub('=' + p + ',', '=', s)
            s = re.sub(',' + p + '([, \n])', '\\1', s)
            s = re.sub('\s+-?-check-prefix=' + p + '([ \n])', '\\1', s)
        else:
            s = re.sub('-?-check-prefixes=([\w-]+)(\Z|[ \t\n])', '--check-prefix=\\1\\2', s)
            t = re.search('-?-check-(?:prefix|prefixes)=([^ ]+)\s+-?-check-(?:prefix|prefixes)=([^ ]+)', s)
            while t:
                s = re.sub(t.group(), '--check-prefixes=' + t.group(1) + ',' + t.group(2), s)
                t = re.search('-?-check-(?:prefix|prefixes)=([^ ]+)\s+-?-check-(?:prefix|prefixes)=([^ ]+)', s)
            s = re.sub('\s+-?-check-prefix=CHECK[ \t]*\n', '\n', s)
        f.truncate(0)
        f.seek(0)
        f.write(s)
    if not r:
        t = re.search('Assertions have been autogenerated by (.*)', s)
        if t:
            s = os.popen('llvm/' + t.group(1) + ' ' + i + ' 2>&1').read()
            if 'had conflicting output from different RUN lines for all functions' in s:
                return -1
            s = os.popen('git diff ' + i).read()
            if re.search('\n(?:-+)\n', s) or re.search('\n[+-].*(?<!RUN):', s):
                return 1
        return 0
    return remove_prefix(i, d+1)

with ThreadPoolExecutor(max_workers=32) as e:
    f = []
    c = []
    a = []
    t = { e.submit(remove_prefix, i): i for i in sys.argv[1:] }
    for i in as_completed(t):
        if i.result() == 0:
            print('DONE:', end=' ')
        elif i.result() == -1:
            print('FAIL:', end=' ')
            f.append(t[i])
        elif i.result() == 1:
            print('CHANGE:', end=' ')
            c.append(t[i])
        else:
            print('ABORT:', end=' ')
            a.append(t[i])
        print(t[i])
    for i in [ (f, 'Failed'), (c, 'Changed'), (a, 'Aborted') ]:
        if i[0]:
            print('********************\n%s Tests (%d):' % (i[1], len(i[0])))
            for j in i[0]:
                print('  ' + j)
