/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.tlsattacker.core.constants.BulkCipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CipherType;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.PublicKeyAlgorithm;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgorithmResolver {
    private static final Logger LOGGER = LogManager.getLogger();

    public static PRFAlgorithm getPRFAlgorithm(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        if (protocolVersion == ProtocolVersion.SSL3 || protocolVersion == ProtocolVersion.SSL2) {
            return null;
        }
        PRFAlgorithm result = cipherSuite.usesGOSTR3411() ? PRFAlgorithm.TLS_PRF_GOSTR3411 : (cipherSuite.usesGOSTR34112012() ? PRFAlgorithm.TLS_PRF_GOSTR3411_2012_256 : (protocolVersion == ProtocolVersion.TLS10 || protocolVersion == ProtocolVersion.TLS11 || protocolVersion == ProtocolVersion.DTLS10 ? PRFAlgorithm.TLS_PRF_LEGACY : (cipherSuite.usesSHA384() ? PRFAlgorithm.TLS_PRF_SHA384 : PRFAlgorithm.TLS_PRF_SHA256)));
        LOGGER.debug("Using the following PRF Algorithm: {}", (Object)result);
        return result;
    }

    public static DigestAlgorithm getDigestAlgorithm(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        if (protocolVersion == ProtocolVersion.SSL3 || protocolVersion == ProtocolVersion.SSL2) {
            throw new UnsupportedOperationException("SSL3 and SSL2 PRF currently not supported");
        }
        DigestAlgorithm result = cipherSuite.usesGOSTR3411() ? DigestAlgorithm.GOSTR3411 : (cipherSuite.usesGOSTR34112012() ? DigestAlgorithm.GOSTR34112012_256 : (protocolVersion == ProtocolVersion.TLS10 || protocolVersion == ProtocolVersion.TLS11 || protocolVersion == ProtocolVersion.DTLS10 ? DigestAlgorithm.LEGACY : (cipherSuite.usesSHA384() ? DigestAlgorithm.SHA384 : DigestAlgorithm.SHA256)));
        LOGGER.debug("Using the following Digest Algorithm: {}", (Object)result);
        return result;
    }

    public static KeyExchangeAlgorithm getKeyExchangeAlgorithm(CipherSuite cipherSuite) {
        if (cipherSuite.isTLS13()) {
            return null;
        }
        String cipher = cipherSuite.toString().toUpperCase();
        if (cipher.contains("TLS_RSA_WITH") || cipher.contains("TLS_RSA_EXPORT")) {
            return KeyExchangeAlgorithm.RSA;
        }
        if (cipher.contains("TLS_RSA_PSK_")) {
            return KeyExchangeAlgorithm.PSK_RSA;
        }
        if (cipher.startsWith("TLS_DH_DSS_")) {
            return KeyExchangeAlgorithm.DH_DSS;
        }
        if (cipher.startsWith("TLS_DH_RSA_")) {
            return KeyExchangeAlgorithm.DH_RSA;
        }
        if (cipher.startsWith("TLS_DHE_DSS_")) {
            return KeyExchangeAlgorithm.DHE_DSS;
        }
        if (cipher.contains("TLS_DHE_RSA_")) {
            return KeyExchangeAlgorithm.DHE_RSA;
        }
        if (cipher.contains("TLS_DHE_PSK") || cipher.contains("TLS_PSK_DHE")) {
            return KeyExchangeAlgorithm.DHE_PSK;
        }
        if (cipher.startsWith("TLS_DH_ANON_")) {
            return KeyExchangeAlgorithm.DH_ANON;
        }
        if (cipher.contains("TLS_ECDHE_RSA")) {
            return KeyExchangeAlgorithm.ECDHE_RSA;
        }
        if (cipher.contains("TLS_ECDHE_ECDSA")) {
            return KeyExchangeAlgorithm.ECDHE_ECDSA;
        }
        if (cipher.contains("TLS_ECDH_ANON")) {
            return KeyExchangeAlgorithm.ECDH_ANON;
        }
        if (cipher.contains("TLS_ECDH_ECDSA")) {
            return KeyExchangeAlgorithm.ECDH_ECDSA;
        }
        if (cipher.contains("TLS_ECDH_RSA")) {
            return KeyExchangeAlgorithm.ECDH_RSA;
        }
        if (cipher.contains("TLS_ECDHE_PSK")) {
            return KeyExchangeAlgorithm.ECDHE_PSK;
        }
        if (cipher.startsWith("TLS_NULL_")) {
            return KeyExchangeAlgorithm.NULL;
        }
        if (cipher.startsWith("TLS_KRB5_")) {
            return KeyExchangeAlgorithm.KRB5;
        }
        if (cipher.contains("TLS_PSK_")) {
            return KeyExchangeAlgorithm.PSK;
        }
        if (cipher.startsWith("TLS_SRP_SHA_RSA")) {
            return KeyExchangeAlgorithm.SRP_SHA_RSA;
        }
        if (cipher.startsWith("TLS_SRP_SHA_DSS")) {
            return KeyExchangeAlgorithm.SRP_SHA_DSS;
        }
        if (cipher.startsWith("TLS_SRP_SHA")) {
            return KeyExchangeAlgorithm.SRP_SHA;
        }
        if (cipher.startsWith("TLS_GOSTR341001_")) {
            return KeyExchangeAlgorithm.VKO_GOST01;
        }
        if (cipher.startsWith("TLS_GOSTR341112_")) {
            return KeyExchangeAlgorithm.VKO_GOST12;
        }
        if (cipher.startsWith("TLS_CECPQ1_")) {
            return KeyExchangeAlgorithm.CECPQ1_ECDSA;
        }
        if (cipher.contains("SSL_FORTEZZA_KEA")) {
            return KeyExchangeAlgorithm.FORTEZZA_KEA;
        }
        if (cipher.contains("ECMQV_ECNRA")) {
            return KeyExchangeAlgorithm.ECMQV_ECNRA;
        }
        if (cipher.contains("ECMQV_ECDSA")) {
            return KeyExchangeAlgorithm.ECMQV_ECDSA;
        }
        if (cipher.contains("ECDH_ECNRA")) {
            return KeyExchangeAlgorithm.ECDH_ECNRA;
        }
        if (cipher.contains("ECCPWD")) {
            return KeyExchangeAlgorithm.ECCPWD;
        }
        if (cipherSuite == CipherSuite.TLS_FALLBACK_SCSV || cipherSuite == CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) {
            throw new UnsupportedOperationException("The CipherSuite:" + cipherSuite.name() + " does not specify a KeyExchangeAlgorithm");
        }
        throw new UnsupportedOperationException("The key exchange algorithm in " + cipherSuite.toString() + " is not supported yet.");
    }

    public static Set<PublicKeyAlgorithm> getRequiredKeystoreAlgorithms(CipherSuite cipherSuite) {
        String cipher = cipherSuite.toString().toUpperCase();
        HashSet<PublicKeyAlgorithm> result = new HashSet<PublicKeyAlgorithm>();
        if (cipher.contains("RSA")) {
            result.add(PublicKeyAlgorithm.RSA);
        } else if (cipher.contains("ECDSA")) {
            result.add(PublicKeyAlgorithm.EC);
        } else if (cipher.contains("DSS")) {
            result.add(PublicKeyAlgorithm.DH);
        } else if (cipher.contains("GOSTR341112")) {
            result.add(PublicKeyAlgorithm.GOST12);
        } else if (cipher.contains("GOSTR341001")) {
            result.add(PublicKeyAlgorithm.GOST01);
        }
        if (cipher.contains("_ECDH_")) {
            result.add(PublicKeyAlgorithm.EC);
        } else if (cipher.contains("_DH_")) {
            result.add(PublicKeyAlgorithm.DH);
        }
        return result;
    }

    public static CipherAlgorithm getCipher(CipherSuite cipherSuite) {
        String cipher = cipherSuite.toString().toUpperCase();
        if (cipher.contains("NULL")) {
            return CipherAlgorithm.NULL;
        }
        if (cipher.contains("IDEA")) {
            return CipherAlgorithm.IDEA_128;
        }
        if (cipher.contains("RC2")) {
            return CipherAlgorithm.RC2_128;
        }
        if (cipher.contains("RC4")) {
            return CipherAlgorithm.RC4_128;
        }
        if (cipher.contains("DES_EDE_CBC")) {
            return CipherAlgorithm.DES_EDE_CBC;
        }
        if (cipher.contains("AES_128_CBC")) {
            return CipherAlgorithm.AES_128_CBC;
        }
        if (cipher.contains("AES_256_CBC")) {
            return CipherAlgorithm.AES_256_CBC;
        }
        if (cipher.contains("AES_128_GCM")) {
            return CipherAlgorithm.AES_128_GCM;
        }
        if (cipher.contains("AES_256_GCM")) {
            return CipherAlgorithm.AES_256_GCM;
        }
        if (cipher.contains("AES_128_CCM")) {
            return CipherAlgorithm.AES_128_CCM;
        }
        if (cipher.contains("AES_256_CCM")) {
            return CipherAlgorithm.AES_256_CCM;
        }
        if (cipher.contains("CAMELLIA_128_CBC")) {
            return CipherAlgorithm.CAMELLIA_128_CBC;
        }
        if (cipher.contains("CAMELLIA_256_CBC")) {
            return CipherAlgorithm.CAMELLIA_256_CBC;
        }
        if (cipher.contains("CAMELLIA_128_GCM")) {
            return CipherAlgorithm.CAMELLIA_128_GCM;
        }
        if (cipher.contains("CAMELLIA_256_GCM")) {
            return CipherAlgorithm.CAMELLIA_256_GCM;
        }
        if (cipher.contains("SEED_CBC")) {
            return CipherAlgorithm.SEED_CBC;
        }
        if (cipher.contains("DES40_CBC")) {
            return CipherAlgorithm.DES40_CBC;
        }
        if (cipher.contains("DES_CBC")) {
            return CipherAlgorithm.DES_CBC;
        }
        if (cipher.contains("WITH_FORTEZZA_CBC")) {
            return CipherAlgorithm.FORTEZZA_CBC;
        }
        if (cipher.contains("ARIA_128_CBC")) {
            return CipherAlgorithm.ARIA_128_CBC;
        }
        if (cipher.contains("ARIA_256_CBC")) {
            return CipherAlgorithm.ARIA_256_CBC;
        }
        if (cipher.contains("ARIA_128_GCM")) {
            return CipherAlgorithm.ARIA_128_GCM;
        }
        if (cipher.contains("ARIA_256_GCM")) {
            return CipherAlgorithm.ARIA_256_GCM;
        }
        if (cipher.contains("28147_CNT")) {
            return CipherAlgorithm.GOST_28147_CNT;
        }
        if (cipher.contains("CHACHA20_POLY1305")) {
            return CipherAlgorithm.ChaCha20Poly1305;
        }
        if (cipherSuite == CipherSuite.TLS_FALLBACK_SCSV || cipherSuite == CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) {
            throw new UnsupportedOperationException("The CipherSuite:" + cipherSuite.name() + " does not specify a Cipher");
        }
        throw new UnsupportedOperationException("The cipher algorithm in " + (Object)((Object)cipherSuite) + " is not supported yet.");
    }

    public static BulkCipherAlgorithm getBulkCipherAlgorithm(CipherSuite cipherSuite) {
        return BulkCipherAlgorithm.getBulkCipherAlgorithm(cipherSuite);
    }

    public static CipherType getCipherType(CipherSuite cipherSuite) {
        String cs = cipherSuite.toString().toUpperCase();
        if (cipherSuite.isGCM() || cipherSuite.isCCM() || cipherSuite.isOCB() || cipherSuite.usesStrictExplicitIv()) {
            return CipherType.AEAD;
        }
        if (cs.contains("AES") || cs.contains("DES") || cs.contains("IDEA") || cs.contains("WITH_FORTEZZA") || cs.contains("CAMELLIA") || cs.contains("WITH_SEED") || cs.contains("WITH_ARIA") || cs.contains("RC2")) {
            return CipherType.BLOCK;
        }
        if (cs.contains("RC4") || cs.contains("WITH_NULL") || cs.contains("28147_CNT")) {
            return CipherType.STREAM;
        }
        if (cipherSuite == CipherSuite.TLS_FALLBACK_SCSV || cipherSuite == CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) {
            throw new UnsupportedOperationException("The CipherSuite:" + cipherSuite.name() + " does not specify a CipherType");
        }
        throw new UnsupportedOperationException("Cipher suite " + (Object)((Object)cipherSuite) + " is not supported yet.");
    }

    public static MacAlgorithm getMacAlgorithm(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        MacAlgorithm result = null;
        if (AlgorithmResolver.getCipherType(cipherSuite) == CipherType.AEAD) {
            result = MacAlgorithm.AEAD;
        } else {
            String cipher = cipherSuite.toString();
            if (cipher.contains("MD5")) {
                result = protocolVersion.isSSL() ? MacAlgorithm.SSLMAC_MD5 : MacAlgorithm.HMAC_MD5;
            } else if (cipher.endsWith("SHA")) {
                result = protocolVersion.isSSL() ? MacAlgorithm.SSLMAC_SHA1 : MacAlgorithm.HMAC_SHA1;
            } else if (cipher.contains("SHA256")) {
                result = MacAlgorithm.HMAC_SHA256;
            } else if (cipher.contains("SHA384")) {
                result = MacAlgorithm.HMAC_SHA384;
            } else if (cipher.contains("SHA512")) {
                result = MacAlgorithm.HMAC_SHA512;
            } else if (cipher.endsWith("NULL")) {
                result = MacAlgorithm.NULL;
            } else if (cipher.endsWith("IMIT")) {
                result = MacAlgorithm.IMIT_GOST28147;
            } else if (cipherSuite.usesGOSTR3411()) {
                result = MacAlgorithm.HMAC_GOSTR3411;
            } else if (cipherSuite.usesGOSTR34112012()) {
                result = MacAlgorithm.HMAC_GOSTR3411_2012_256;
            }
        }
        if (cipherSuite == CipherSuite.TLS_FALLBACK_SCSV || cipherSuite == CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) {
            throw new UnsupportedOperationException("The CipherSuite:" + cipherSuite.name() + " does not specify a MAC-Algorithm");
        }
        if (result != null) {
            LOGGER.debug("Using the following Mac Algorithm: {}", (Object)result);
            return result;
        }
        throw new UnsupportedOperationException("The Mac algorithm for cipher " + (Object)((Object)cipherSuite) + " is not supported yet");
    }

    public static HKDFAlgorithm getHKDFAlgorithm(CipherSuite cipherSuite) {
        HKDFAlgorithm result = null;
        String cipher = cipherSuite.toString();
        if (cipher.endsWith("SHA256")) {
            result = HKDFAlgorithm.TLS_HKDF_SHA256;
        } else if (cipher.endsWith("SHA384")) {
            result = HKDFAlgorithm.TLS_HKDF_SHA384;
        }
        if (result != null) {
            LOGGER.debug("Using the following HKDF Algorithm: {}", (Object)result);
            return result;
        }
        LOGGER.warn("The HKDF algorithm for cipher suite " + (Object)((Object)cipherSuite) + " is not supported yet or is undefined. Using \"TLS_HKDF_SHA256\"");
        return HKDFAlgorithm.TLS_HKDF_SHA256;
    }

    private AlgorithmResolver() {
    }
}

