/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStream
extends TupleStream
implements Expressible {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String BATCH_INDEXED_FIELD_NAME = "batchIndexed";
    private String collection;
    protected String zkHost;
    private int updateBatchSize;
    private boolean pruneVersionField;
    private int batchNumber;
    private long totalDocsIndex;
    private PushBackStream tupleSource;
    private List<SolrInputDocument> documentBatch = new ArrayList<SolrInputDocument>();
    private String coreName;
    protected transient SolrClientCache clientCache;
    private transient boolean doCloseCache;

    public UpdateStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        this.verifyCollectionName(collectionName, expression);
        String zkHost = this.findZkHost(factory, collectionName, expression);
        this.verifyZkHost(zkHost, collectionName, expression);
        int updateBatchSize = this.extractBatchSize(expression, factory);
        this.pruneVersionField = factory.getBooleanOperand(expression, "pruneVersionField", this.defaultPruneVersionField());
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        StreamExpression sourceStreamExpression = streamExpressions.get(0);
        this.init(collectionName, factory.constructStream(sourceStreamExpression), zkHost, updateBatchSize);
    }

    public UpdateStream(String collectionName, TupleStream tupleSource, String zkHost, int updateBatchSize) throws IOException {
        if (updateBatchSize <= 0) {
            throw new IOException(String.format(Locale.ROOT, "batchSize '%d' must be greater than 0.", updateBatchSize));
        }
        this.pruneVersionField = this.defaultPruneVersionField();
        this.init(collectionName, tupleSource, zkHost, updateBatchSize);
    }

    private void init(String collectionName, TupleStream tupleSource, String zkHost, int updateBatchSize) {
        this.collection = collectionName;
        this.zkHost = zkHost;
        this.updateBatchSize = updateBatchSize;
        this.tupleSource = new PushBackStream(tupleSource);
    }

    protected String getCollectionName() {
        return this.collection;
    }

    @Override
    public void open() throws IOException {
        if (this.clientCache == null) {
            this.doCloseCache = true;
            this.clientCache = new SolrClientCache();
        } else {
            this.doCloseCache = false;
        }
        this.tupleSource.open();
    }

    @Override
    public Tuple read() throws IOException {
        for (int i = 0; i < this.updateBatchSize; ++i) {
            Tuple tuple = this.tupleSource.read();
            if (tuple.EOF) {
                if (this.documentBatch.isEmpty()) {
                    return tuple;
                }
                this.tupleSource.pushBack(tuple);
                this.uploadBatchToCollection(this.documentBatch);
                int b = this.documentBatch.size();
                this.documentBatch.clear();
                return this.createBatchSummaryTuple(b);
            }
            this.documentBatch.add(this.convertTupleToSolrDocument(tuple));
        }
        this.uploadBatchToCollection(this.documentBatch);
        int b = this.documentBatch.size();
        this.documentBatch.clear();
        return this.createBatchSummaryTuple(b);
    }

    @Override
    public void close() throws IOException {
        if (this.doCloseCache) {
            this.clientCache.close();
        }
        this.tupleSource.close();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.tupleSource.getStreamSort();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> sourceList = new ArrayList<TupleStream>(1);
        sourceList.add(this.tupleSource);
        return sourceList;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        expression.addParameter(new StreamExpressionNamedParameter("batchSize", Integer.toString(this.updateBatchSize)));
        if (includeStreams) {
            if (this.tupleSource == null) throw new IOException("This ParallelStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(this.tupleSource.toExpression(factory));
            return expression;
        } else {
            expression.addParameter("<stream>");
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        explanation.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        explanation.setImplementingClass("Solr/Lucene");
        explanation.setExpressionType("datastore");
        explanation.setExpression("Update into " + this.collection);
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId().toString());
        child.setFunctionName(String.format(Locale.ROOT, factory.getFunctionName(this.getClass()), new Object[0]));
        child.setImplementingClass(this.getClass().getName());
        child.setExpressionType("stream-decorator");
        child.setExpression(this.toExpression(factory, false).toString());
        child.addChild(this.tupleSource.toExplanation(factory));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.clientCache = context.getSolrClientCache();
        this.coreName = (String)context.get("core");
        this.tupleSource.setStreamContext(context);
    }

    private void verifyCollectionName(String collectionName, StreamExpression expression) throws IOException {
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
    }

    private String findZkHost(StreamFactory factory, String collectionName, StreamExpression expression) {
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == zkHostExpression) {
            String zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                return factory.getDefaultZkHost();
            }
            return zkHost;
        }
        if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            return ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        return null;
    }

    private void verifyZkHost(String zkHost, String collectionName, StreamExpression expression) throws IOException {
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
    }

    private int extractBatchSize(StreamExpression expression, StreamFactory factory) throws IOException {
        StreamExpressionNamedParameter batchSizeParam = factory.getNamedOperand(expression, "batchSize");
        if (batchSizeParam == null) {
            return 250;
        }
        String batchSizeStr = ((StreamExpressionValue)batchSizeParam.getParameter()).getValue();
        return this.parseBatchSize(batchSizeStr, expression);
    }

    private int parseBatchSize(String batchSizeStr, StreamExpression expression) throws IOException {
        try {
            int batchSize = Integer.parseInt(batchSizeStr);
            if (batchSize <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - batchSize '%d' must be greater than 0.", expression, batchSize));
            }
            return batchSize;
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - batchSize '%s' is not a valid integer.", expression, batchSizeStr));
        }
    }

    protected boolean defaultPruneVersionField() {
        return true;
    }

    private SolrInputDocument convertTupleToSolrDocument(Tuple tuple) {
        SolrInputDocument doc = new SolrInputDocument();
        for (String field : tuple.getFields().keySet()) {
            if (field.equals("_version_") && this.pruneVersionField) continue;
            Object value = tuple.get(field);
            if (value instanceof List) {
                this.addMultivaluedField(doc, field, (List)value);
                continue;
            }
            doc.addField(field, value);
        }
        log.debug("Tuple [{}] was converted into SolrInputDocument [{}].", (Object)tuple, (Object)doc);
        return doc;
    }

    private void addMultivaluedField(SolrInputDocument doc, String fieldName, List<?> values) {
        for (Object value : values) {
            doc.addField(fieldName, value);
        }
    }

    protected void uploadBatchToCollection(List<SolrInputDocument> documentBatch) throws IOException {
        if (documentBatch.size() == 0) {
            return;
        }
        try {
            CloudSolrClient cloudSolrClient = this.clientCache.getCloudSolrClient(this.zkHost);
            cloudSolrClient.add(this.collection, documentBatch);
        }
        catch (IOException | SolrServerException e) {
            log.warn("Unable to add documents to collection due to unexpected error.", e);
            String className = e.getClass().getName();
            String message = e.getMessage();
            throw new IOException(String.format(Locale.ROOT, "Unexpected error when adding documents to collection %s- %s:%s", this.collection, className, message));
        }
    }

    private Tuple createBatchSummaryTuple(int batchSize) {
        assert (batchSize > 0);
        Tuple tuple = new Tuple();
        this.totalDocsIndex += (long)batchSize;
        ++this.batchNumber;
        tuple.put(BATCH_INDEXED_FIELD_NAME, batchSize);
        tuple.put("totalIndexed", this.totalDocsIndex);
        tuple.put("batchNumber", this.batchNumber);
        if (this.coreName != null) {
            tuple.put("worker", this.coreName);
        }
        return tuple;
    }
}

