/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.collector;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.solr.search.DocSet;

public class FilterCollector
extends org.apache.lucene.search.FilterCollector {
    private final DocSet filter;
    private int matches;

    public FilterCollector(DocSet filter, Collector delegate) {
        super(delegate);
        this.filter = filter;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final int docBase = context.docBase;
        return new FilterLeafCollector(super.getLeafCollector(context)){

            public void collect(int doc) throws IOException {
                ++FilterCollector.this.matches;
                if (FilterCollector.this.filter.exists(doc + docBase)) {
                    super.collect(doc);
                }
            }
        };
    }

    public int getMatches() {
        return this.matches;
    }

    public Collector getDelegate() {
        return this.in;
    }
}

