/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog.util;

import com.projectlibre1.dialog.FieldDialog;
import com.projectlibre1.dialog.util.ComponentFactory;
import com.projectlibre1.dialog.util.ExtDateField;
import com.projectlibre1.dialog.util.LookupField;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.field.ObjectRef;
import com.projectlibre1.options.EditOption;
import com.projectlibre1.undo.FieldEdit;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.DateTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEditSupport;

public class FieldVerifier
extends InputVerifier {
    protected FieldContext context = null;
    protected Field field;
    protected ObjectRef objectRef = null;
    protected Object source;
    protected Object value;
    protected Exception exception = null;
    protected boolean updating = false;
    boolean testing = false;

    public FieldVerifier(Field field, ObjectRef objectRef, Object object) {
        this.field = field;
        this.objectRef = objectRef;
        this.setValue(object);
        this.source = this;
    }

    static JComponent valueHoldingComponent(JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container != null && container instanceof LookupField) {
            container = ((LookupField)container).getDisplay();
        } else if (container != null && container instanceof Component) {
            container = ((Component)container).getParent();
        }
        if (container instanceof JSpinner || container instanceof ExtDateField) {
            jComponent = (JComponent)container;
        }
        return jComponent;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        Object object;
        block24: {
            Object object2;
            if (this.updating) {
                return true;
            }
            FieldDialog fieldDialog = ComponentFactory.getParentFieldDialog(jComponent);
            if (fieldDialog != null) {
                fieldDialog.setDirtyComponent(null);
            }
            JComponent jComponent2 = jComponent;
            jComponent = FieldVerifier.valueHoldingComponent(jComponent);
            jComponent.setForeground(Color.BLACK);
            jComponent2.setForeground(Color.BLACK);
            object = ComponentFactory.getValueFromComponent(jComponent, this.field);
            if (object == this.value || object != null && object.equals(this.value)) {
                if (jComponent instanceof JSpinner || jComponent instanceof ExtDateField) {
                    object2 = ((JTextField)jComponent2).getText();
                    try {
                        if (!(jComponent instanceof ExtDateField) || ((String)object2).trim().length() > 0) {
                            object = this.field.getFormat().parseObject((String)object2);
                        }
                        ((JTextField)jComponent2).setText("");
                        object = null;
                    }
                    catch (ParseException parseException) {
                        this.exception = new FieldParseException(this.field.syntaxErrorForField());
                        jComponent.setForeground(Color.RED);
                        jComponent2.setForeground(Color.RED);
                        if (fieldDialog != null) {
                            fieldDialog.setDirtyComponent(jComponent2);
                        }
                        return false;
                    }
                } else {
                    return true;
                }
            }
            if (object != null && this.value != null && object.toString().equals(this.value.toString())) {
                return true;
            }
            this.exception = null;
            try {
                if (this.field.hasOptions()) {
                    if (object == null) {
                        object = " ";
                    }
                    this.field.setText(this.objectRef, object.toString(), this.context);
                    break block24;
                }
                if (this.field.isDate()) {
                    if (object != null && object instanceof String) {
                        try {
                            object = EditOption.getInstance().getDateFormat().parseObject((String)object);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (object == null || object.toString().trim().equals("")) {
                        object = DateTime.getZeroDate();
                    }
                }
                if (object != this.value) {
                    object2 = this.field.getValue(this.objectRef, this.context);
                    if (this.field.isMoney()) {
                        this.field.setText(this.objectRef, "" + object, this.context);
                    } else {
                        this.field.setValue(this.objectRef, this.source, object, this.context);
                    }
                    UndoableEditSupport undoableEditSupport = this.objectRef.getDataFactory().getUndoController().getEditSupport();
                    if (undoableEditSupport != null) {
                        undoableEditSupport.postEdit(new FieldEdit(this.field, this.objectRef, this.value, object2, this, this.context));
                    }
                }
            }
            catch (FieldParseException fieldParseException) {
                this.exception = fieldParseException;
                jComponent.setForeground(Color.RED);
                jComponent2.setForeground(Color.RED);
                if (fieldDialog != null) {
                    fieldDialog.setDirtyComponent(jComponent2);
                }
                return false;
            }
        }
        this.setValue(object);
        return true;
    }

    @Override
    public boolean shouldYieldFocus(JComponent jComponent) {
        if (this.testing) {
            return true;
        }
        this.testing = true;
        boolean bl = super.shouldYieldFocus(jComponent);
        if (!bl) {
            Alert.error(this.exception.getMessage(), jComponent);
        }
        this.testing = false;
        return bl;
    }

    void setValue(Object object) {
        this.value = object;
    }

    public final void setUpdating(boolean bl) {
        this.updating = bl;
    }

    final Object getValue() {
        return this.value;
    }

    final boolean isUpdating() {
        return this.updating;
    }

    public final Exception getException() {
        return this.exception;
    }

    public static class VerifierListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            InputVerifier inputVerifier = jComponent.getInputVerifier();
            if (inputVerifier != null) {
                inputVerifier.verify(jComponent);
            }
        }
    }
}

