/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataAntenna
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -4959721095331063491L;
    private static final int LENGTH = 1;
    private final byte antenna;

    public static RadiotapDataAntenna newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataAntenna(rawData, offset, length);
    }

    private RadiotapDataAntenna(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 1) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapRate (").append(1).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.antenna = ByteArrays.getByte(rawData, offset);
    }

    private RadiotapDataAntenna(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.antenna = builder2.antenna;
    }

    public byte getAntenna() {
        return this.antenna;
    }

    public int getAntennaAsInt() {
        return this.antenna & 0xFF;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.antenna);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Antenna: ").append(ls).append(indent).append("  Antenna: ").append(this.getAntennaAsInt()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.antenna;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataAntenna other = (RadiotapDataAntenna)obj;
        return this.antenna == other.antenna;
    }

    public static final class Builder {
        private byte antenna;

        public Builder() {
        }

        private Builder(RadiotapDataAntenna obj) {
            this.antenna = obj.antenna;
        }

        public Builder antenna(byte antenna) {
            this.antenna = antenna;
            return this;
        }

        public RadiotapDataAntenna build() {
            return new RadiotapDataAntenna(this);
        }
    }
}

