/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;

public class Java7ZlibInputOutputStream
extends XMPPInputOutputStream {
    private static final int compressionLevel = -1;

    public Java7ZlibInputOutputStream() {
        super("zlib");
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream) {
        return new InflaterInputStream(inputStream, new Inflater(), 512){

            @Override
            public int available() throws IOException {
                if (this.inf.needsInput()) {
                    return 0;
                }
                return super.available();
            }
        };
    }

    @Override
    public OutputStream getOutputStream(OutputStream outputStream) {
        int flushMethodInt;
        switch (flushMethod) {
            case SYNC_FLUSH: {
                flushMethodInt = 2;
                break;
            }
            case FULL_FLUSH: {
                flushMethodInt = 3;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new DeflaterOutputStream(outputStream, new Deflater(-1)){

            @Override
            public void flush() throws IOException {
                int count2;
                while ((count2 = this.def.deflate(this.buf, 0, this.buf.length, flushMethodInt)) > 0) {
                    this.out.write(this.buf, 0, count2);
                }
                super.flush();
            }
        };
    }
}

