/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionOrientedMessageProcessor
extends MessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(ConnectionOrientedMessageProcessor.class);
    protected int nConnections;
    protected boolean isRunning;
    protected final Map<String, ConnectionOrientedMessageChannel> messageChannels;
    protected final Map<String, ConnectionOrientedMessageChannel> incomingMessageChannels;
    protected ServerSocket sock;
    protected int useCount;

    public ConnectionOrientedMessageProcessor(InetAddress ipAddress, int port2, String transport, SIPTransactionStack sipStack) {
        super(ipAddress, port2, transport, sipStack);
        this.sipStack = sipStack;
        this.messageChannels = new ConcurrentHashMap<String, ConnectionOrientedMessageChannel>();
        this.incomingMessageChannels = new ConcurrentHashMap<String, ConnectionOrientedMessageChannel>();
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    protected synchronized void remove(ConnectionOrientedMessageChannel messageChannel) {
        String key = messageChannel.getKey();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(Thread.currentThread() + " removing " + key + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
        }
        if (this.messageChannels.get(key) == messageChannel) {
            this.messageChannels.remove(key);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(Thread.currentThread() + " Removing incoming channel " + key + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
        }
        this.incomingMessageChannels.remove(key);
    }

    protected synchronized void cacheMessageChannel(ConnectionOrientedMessageChannel messageChannel) {
        String key = messageChannel.getKey();
        ConnectionOrientedMessageChannel currentChannel = this.messageChannels.get(key);
        if (currentChannel != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing " + key);
            }
            currentChannel.close();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Caching " + key);
        }
        this.messageChannels.put(key, messageChannel);
    }

    @Override
    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean inUse() {
        return this.useCount != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeReliableConnection(String peerAddress, int peerPort) throws IllegalArgumentException {
        this.validatePortInRange(peerPort);
        HostPort hostPort = new HostPort();
        hostPort.setHost(new Host(peerAddress));
        hostPort.setPort(peerPort);
        String messageChannelKey = MessageChannel.getKey(hostPort, "TCP");
        ConnectionOrientedMessageProcessor connectionOrientedMessageProcessor = this;
        synchronized (connectionOrientedMessageProcessor) {
            ConnectionOrientedMessageChannel foundMessageChannel = this.messageChannels.get(messageChannelKey);
            if (foundMessageChannel != null) {
                foundMessageChannel.close();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug(Thread.currentThread() + " Removing channel " + messageChannelKey + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
                }
                this.incomingMessageChannels.remove(messageChannelKey);
                this.messageChannels.remove(messageChannelKey);
                return true;
            }
            foundMessageChannel = this.incomingMessageChannels.get(messageChannelKey);
            if (foundMessageChannel != null) {
                foundMessageChannel.close();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug(Thread.currentThread() + " Removing incoming channel " + messageChannelKey + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
                }
                this.incomingMessageChannels.remove(messageChannelKey);
                this.messageChannels.remove(messageChannelKey);
                return true;
            }
        }
        return false;
    }

    public boolean setKeepAliveTimeout(String peerAddress, int peerPort, long keepAliveTimeout) {
        this.validatePortInRange(peerPort);
        HostPort hostPort = new HostPort();
        hostPort.setHost(new Host(peerAddress));
        hostPort.setPort(peerPort);
        String messageChannelKey = MessageChannel.getKey(hostPort, "TCP");
        ConnectionOrientedMessageChannel foundMessageChannel = this.messageChannels.get(messageChannelKey);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(Thread.currentThread() + " checking channel with key " + messageChannelKey + " : " + foundMessageChannel + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
        }
        if (foundMessageChannel != null) {
            foundMessageChannel.setKeepAliveTimeout(keepAliveTimeout);
            return true;
        }
        foundMessageChannel = this.incomingMessageChannels.get(messageChannelKey);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(Thread.currentThread() + " checking incoming channel with key " + messageChannelKey + " : " + foundMessageChannel + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
        }
        if (foundMessageChannel != null) {
            foundMessageChannel.setKeepAliveTimeout(keepAliveTimeout);
            return true;
        }
        return false;
    }

    protected void validatePortInRange(int port2) throws IllegalArgumentException {
        if (port2 < 1 || port2 > 65535) {
            throw new IllegalArgumentException("Peer port should be greater than 0 and less 65535, port = " + port2);
        }
    }
}

