/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.FileInputStream;
import java.security.AccessController;
import java.security.CryptoPrimitive;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.AbstractKeyManagerWrapper;
import sun.security.ssl.AbstractTrustManagerWrapper;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.HelloCookieManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.StatusResponseManager;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.TrustStoreManager;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public abstract class SSLContextImpl
extends SSLContextSpi {
    private final EphemeralKeyManager ephemeralKeyManager;
    private final SSLSessionContextImpl clientCache;
    private final SSLSessionContextImpl serverCache;
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private volatile HelloCookieManager.Builder helloCookieManagerBuilder;
    private final boolean clientEnableStapling = Utilities.getBooleanProperty("jdk.tls.client.enableStatusRequestExtension", false);
    private final boolean serverEnableStapling = Utilities.getBooleanProperty("jdk.tls.server.enableStatusRequestExtension", false);
    private static final Collection<CipherSuite> clientCustomizedCipherSuites = SSLContextImpl.getCustomizedCipherSuites("jdk.tls.client.cipherSuites");
    private static final Collection<CipherSuite> serverCustomizedCipherSuites = SSLContextImpl.getCustomizedCipherSuites("jdk.tls.server.cipherSuites");
    private volatile StatusResponseManager statusResponseManager;

    SSLContextImpl() {
        this.ephemeralKeyManager = new EphemeralKeyManager();
        this.clientCache = new SSLSessionContextImpl();
        this.serverCache = new SSLSessionContextImpl();
    }

    @Override
    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(trustManagerArray);
        if (secureRandom == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && secureRandom.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.secureRandom = secureRandom;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,sslctx")) {
            SSLLogger.finest("trigger seeding of SecureRandom", new Object[0]);
        }
        this.secureRandom.nextInt();
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,sslctx")) {
            SSLLogger.finest("done seeding of SecureRandom", new Object[0]);
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        for (int i = 0; trustManagerArray != null && i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(trustManagerArray[i] instanceof X509TrustManagerImpl)) {
                throw new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used");
            }
            if (trustManagerArray[i] instanceof X509ExtendedTrustManager) {
                return (X509TrustManager)trustManagerArray[i];
            }
            return new AbstractTrustManagerWrapper((X509TrustManager)trustManagerArray[i]);
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        for (int i = 0; keyManagerArray != null && i < keyManagerArray.length; ++i) {
            KeyManager keyManager = keyManagerArray[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (keyManager instanceof X509KeyManagerImpl || keyManager instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)keyManager;
                }
                throw new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used");
            }
            if (keyManager instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)keyManager;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,sslctx")) {
                SSLLogger.warning("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use", new Object[0]);
            }
            return new AbstractKeyManagerWrapper((X509KeyManager)keyManager);
        }
        return DummyX509KeyManager.INSTANCE;
    }

    abstract SSLEngine createSSLEngineImpl();

    abstract SSLEngine createSSLEngineImpl(String var1, int var2);

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return this.createSSLEngineImpl();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String string, int n) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return this.createSSLEngineImpl(string, n);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HelloCookieManager getHelloCookieManager(ProtocolVersion protocolVersion) {
        if (this.helloCookieManagerBuilder == null) {
            SSLContextImpl sSLContextImpl = this;
            synchronized (sSLContextImpl) {
                if (this.helloCookieManagerBuilder == null) {
                    this.helloCookieManagerBuilder = new HelloCookieManager.Builder(this.secureRandom);
                }
            }
        }
        return this.helloCookieManagerBuilder.valueOf(protocolVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusResponseManager getStatusResponseManager() {
        if (this.serverEnableStapling && this.statusResponseManager == null) {
            SSLContextImpl sSLContextImpl = this;
            synchronized (sSLContextImpl) {
                if (this.statusResponseManager == null) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,sslctx")) {
                        SSLLogger.finest("Initializing StatusResponseManager", new Object[0]);
                    }
                    this.statusResponseManager = new StatusResponseManager();
                }
            }
        }
        return this.statusResponseManager;
    }

    abstract List<ProtocolVersion> getSupportedProtocolVersions();

    abstract List<ProtocolVersion> getServerDefaultProtocolVersions();

    abstract List<ProtocolVersion> getClientDefaultProtocolVersions();

    abstract List<CipherSuite> getSupportedCipherSuites();

    abstract List<CipherSuite> getServerDefaultCipherSuites();

    abstract List<CipherSuite> getClientDefaultCipherSuites();

    List<ProtocolVersion> getDefaultProtocolVersions(boolean bl) {
        return bl ? this.getServerDefaultProtocolVersions() : this.getClientDefaultProtocolVersions();
    }

    List<CipherSuite> getDefaultCipherSuites(boolean bl) {
        return bl ? this.getServerDefaultCipherSuites() : this.getClientDefaultCipherSuites();
    }

    boolean isDefaultProtocolVesions(List<ProtocolVersion> list) {
        return list == this.getServerDefaultProtocolVersions() || list == this.getClientDefaultProtocolVersions();
    }

    boolean isDefaultCipherSuiteList(List<CipherSuite> list) {
        return list == this.getServerDefaultCipherSuites() || list == this.getClientDefaultCipherSuites();
    }

    boolean isStaplingEnabled(boolean bl) {
        return bl ? this.clientEnableStapling : this.serverEnableStapling;
    }

    private static List<CipherSuite> getApplicableSupportedCipherSuites(List<ProtocolVersion> list) {
        return SSLContextImpl.getApplicableCipherSuites(CipherSuite.allowedCipherSuites(), list);
    }

    private static List<CipherSuite> getApplicableEnabledCipherSuites(List<ProtocolVersion> list, boolean bl) {
        if (bl) {
            if (!clientCustomizedCipherSuites.isEmpty()) {
                return SSLContextImpl.getApplicableCipherSuites(clientCustomizedCipherSuites, list);
            }
        } else if (!serverCustomizedCipherSuites.isEmpty()) {
            return SSLContextImpl.getApplicableCipherSuites(serverCustomizedCipherSuites, list);
        }
        return SSLContextImpl.getApplicableCipherSuites(CipherSuite.defaultCipherSuites(), list);
    }

    private static List<CipherSuite> getApplicableCipherSuites(Collection<CipherSuite> collection, List<ProtocolVersion> list) {
        LinkedHashSet<CipherSuite> linkedHashSet = new LinkedHashSet<CipherSuite>();
        if (list != null && !list.isEmpty()) {
            for (CipherSuite cipherSuite : collection) {
                if (!cipherSuite.isAvailable()) continue;
                boolean bl = false;
                for (ProtocolVersion protocolVersion : list) {
                    if (!cipherSuite.supports(protocolVersion) || !cipherSuite.bulkCipher.isAvailable()) continue;
                    if (SSLAlgorithmConstraints.DEFAULT.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), cipherSuite.name, null)) {
                        linkedHashSet.add(cipherSuite);
                        bl = true;
                        break;
                    }
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,sslctx,verbose")) break;
                    SSLLogger.fine("Ignore disabled cipher suite: " + cipherSuite.name, new Object[0]);
                    break;
                }
                if (bl || !SSLLogger.isOn || !SSLLogger.isOn("ssl,sslctx,verbose")) continue;
                SSLLogger.finest("Ignore unsupported cipher suite: " + (Object)((Object)cipherSuite), new Object[0]);
            }
        }
        return new ArrayList<CipherSuite>(linkedHashSet);
    }

    private static Collection<CipherSuite> getCustomizedCipherSuites(String string) {
        String string2 = GetPropertyAction.privilegedGetProperty(string);
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,sslctx")) {
            SSLLogger.fine("System property " + string + " is set to '" + string2 + "'", new Object[0]);
        }
        if (string2 != null && !string2.isEmpty() && string2.length() > 1 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2 != null && !string2.isEmpty()) {
            String[] stringArray = string2.split(",");
            ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                CipherSuite cipherSuite;
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].isEmpty()) continue;
                try {
                    cipherSuite = CipherSuite.nameOf(stringArray[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,sslctx")) continue;
                    SSLLogger.fine("Unknown or unsupported cipher suite name: " + stringArray[i], new Object[0]);
                    continue;
                }
                if (cipherSuite != null && cipherSuite.isAvailable()) {
                    arrayList.add(cipherSuite);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,sslctx")) continue;
                SSLLogger.fine("The current installed providers do not support cipher suite: " + stringArray[i], new Object[0]);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static List<ProtocolVersion> getAvailableProtocols(ProtocolVersion[] protocolVersionArray) {
        List<ProtocolVersion> list = Collections.emptyList();
        if (protocolVersionArray != null && protocolVersionArray.length != 0) {
            list = new ArrayList<ProtocolVersion>(protocolVersionArray.length);
            for (ProtocolVersion protocolVersion : protocolVersionArray) {
                if (!protocolVersion.isAvailable) continue;
                list.add(protocolVersion);
            }
        }
        return list;
    }

    public static final class DefaultSSLContext
    extends CustomizedTLSContext {
        public DefaultSSLContext() throws Exception {
            if (DefaultManagersHolder.reservedException != null) {
                throw DefaultManagersHolder.reservedException;
            }
            try {
                super.engineInit(DefaultManagersHolder.keyManagers, DefaultManagersHolder.trustManagers, null);
            }
            catch (Exception exception) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                    SSLLogger.fine("default context init failed: ", exception);
                }
                throw exception;
            }
        }

        @Override
        protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
            throw new KeyManagementException("Default SSLContext is initialized automatically");
        }

        static SSLContextImpl getDefaultImpl() throws Exception {
            if (DefaultSSLContextHolder.reservedException != null) {
                throw DefaultSSLContextHolder.reservedException;
            }
            return DefaultSSLContextHolder.sslContext;
        }
    }

    private static final class DefaultSSLContextHolder {
        private static final SSLContextImpl sslContext;
        static Exception reservedException;

        private DefaultSSLContextHolder() {
        }

        static {
            reservedException = null;
            DefaultSSLContext defaultSSLContext = null;
            if (DefaultManagersHolder.reservedException != null) {
                reservedException = DefaultManagersHolder.reservedException;
            } else {
                try {
                    defaultSSLContext = new DefaultSSLContext();
                }
                catch (Exception exception) {
                    reservedException = exception;
                }
            }
            sslContext = defaultSSLContext;
        }
    }

    private static final class DefaultManagersHolder {
        private static final String NONE = "NONE";
        private static final String P11KEYSTORE = "PKCS11";
        private static final TrustManager[] trustManagers;
        private static final KeyManager[] keyManagers;
        private static final Exception reservedException;

        private DefaultManagersHolder() {
        }

        private static TrustManager[] getTrustManagers() throws Exception {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if ("SunJSSE".equals(trustManagerFactory.getProvider().getName())) {
                trustManagerFactory.init((KeyStore)null);
            } else {
                KeyStore keyStore = TrustStoreManager.getTrustedKeyStore();
                trustManagerFactory.init(keyStore);
            }
            return trustManagerFactory.getTrustManagers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static KeyManager[] getKeyManagers() throws Exception {
            Object object;
            final HashMap hashMap = new HashMap();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    hashMap.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    hashMap.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    hashMap.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                    hashMap.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            final String string = (String)hashMap.get("keyStore");
            String string2 = (String)hashMap.get("keyStoreType");
            String string3 = (String)hashMap.get("keyStoreProvider");
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                SSLLogger.fine("keyStore is : " + string, new Object[0]);
                SSLLogger.fine("keyStore type is : " + string2, new Object[0]);
                SSLLogger.fine("keyStore provider is : " + string3, new Object[0]);
            }
            if (P11KEYSTORE.equals(string2) && !NONE.equals(string)) {
                throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
            }
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            char[] cArray = null;
            try {
                if (!string.isEmpty() && !NONE.equals(string)) {
                    fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                        @Override
                        public FileInputStream run() throws Exception {
                            return new FileInputStream(string);
                        }
                    });
                }
                if (!((String)(object = (String)hashMap.get("keyStorePasswd"))).isEmpty()) {
                    cArray = ((String)object).toCharArray();
                }
                if (string2.length() != 0) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                        SSLLogger.finest("init keystore", new Object[0]);
                    }
                    keyStore = string3.isEmpty() ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
                    keyStore.load(fileInputStream, cArray);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,defaultctx")) {
                SSLLogger.fine("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm(), new Object[0]);
            }
            object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(string2)) {
                ((KeyManagerFactory)object).init(keyStore, null);
            } else {
                ((KeyManagerFactory)object).init(keyStore, cArray);
            }
            return ((KeyManagerFactory)object).getKeyManagers();
        }

        static {
            TrustManager[] trustManagerArray;
            Exception exception = null;
            try {
                trustManagerArray = DefaultManagersHolder.getTrustManagers();
            }
            catch (Exception exception2) {
                exception = exception2;
                trustManagerArray = new TrustManager[]{};
            }
            trustManagers = trustManagerArray;
            if (exception == null) {
                KeyManager[] keyManagerArray;
                try {
                    keyManagerArray = DefaultManagersHolder.getKeyManagers();
                }
                catch (Exception exception3) {
                    exception = exception3;
                    keyManagerArray = new KeyManager[]{};
                }
                keyManagers = keyManagerArray;
            } else {
                keyManagers = new KeyManager[0];
            }
            reservedException = exception;
        }
    }

    public static final class TLSContext
    extends CustomizedTLSContext {
    }

    private static class CustomizedTLSContext
    extends AbstractTLSContext {
        private static final List<ProtocolVersion> clientDefaultProtocols;
        private static final List<ProtocolVersion> serverDefaultProtocols;
        private static final List<CipherSuite> clientDefaultCipherSuites;
        private static final List<CipherSuite> serverDefaultCipherSuites;
        private static final IllegalArgumentException reservedException;

        private static List<ProtocolVersion> customizedProtocols(boolean bl, List<ProtocolVersion> list) {
            ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>();
            for (ProtocolVersion protocolVersion : list) {
                arrayList.add(protocolVersion);
            }
            ProtocolVersion[] protocolVersionArray = arrayList.isEmpty() ? (bl ? CustomizedTLSContext.getProtocols() : CustomizedTLSContext.getSupportedProtocols()) : arrayList.toArray(new ProtocolVersion[arrayList.size()]);
            return SSLContextImpl.getAvailableProtocols(protocolVersionArray);
        }

        static ProtocolVersion[] getProtocols() {
            if (SunJSSE.isFIPS()) {
                return new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10};
            }
            return new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30};
        }

        protected CustomizedTLSContext() {
            if (reservedException != null) {
                throw reservedException;
            }
        }

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<ProtocolVersion> getServerDefaultProtocolVersions() {
            return serverDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }

        @Override
        List<CipherSuite> getServerDefaultCipherSuites() {
            return serverDefaultCipherSuites;
        }

        static {
            reservedException = CustomizedSSLProtocols.reservedException;
            if (reservedException == null) {
                clientDefaultProtocols = CustomizedTLSContext.customizedProtocols(true, CustomizedSSLProtocols.customizedClientProtocols);
                serverDefaultProtocols = CustomizedTLSContext.customizedProtocols(false, CustomizedSSLProtocols.customizedServerProtocols);
                clientDefaultCipherSuites = SSLContextImpl.getApplicableEnabledCipherSuites(CustomizedTLSContext.clientDefaultProtocols, true);
                serverDefaultCipherSuites = SSLContextImpl.getApplicableEnabledCipherSuites(CustomizedTLSContext.serverDefaultProtocols, false);
            } else {
                clientDefaultProtocols = null;
                serverDefaultProtocols = null;
                clientDefaultCipherSuites = null;
                serverDefaultCipherSuites = null;
            }
        }
    }

    private static class CustomizedSSLProtocols {
        private static final String JDK_TLS_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
        private static final String JDK_TLS_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
        static IllegalArgumentException reservedException = null;
        static final ArrayList<ProtocolVersion> customizedClientProtocols = new ArrayList();
        static final ArrayList<ProtocolVersion> customizedServerProtocols = new ArrayList();

        private CustomizedSSLProtocols() {
        }

        private static void populate(String string, ArrayList<ProtocolVersion> arrayList) {
            String string2 = GetPropertyAction.privilegedGetProperty(string);
            if (string2 == null) {
                return;
            }
            if (!string2.isEmpty() && string2.length() > 1 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!string2.isEmpty()) {
                String[] stringArray = string2.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                    ProtocolVersion protocolVersion = ProtocolVersion.nameOf(stringArray[i]);
                    if (protocolVersion == null) {
                        reservedException = new IllegalArgumentException(string + ": " + stringArray[i] + " is not a supported SSL protocol name");
                    }
                    if (SunJSSE.isFIPS() && (protocolVersion == ProtocolVersion.SSL30 || protocolVersion == ProtocolVersion.SSL20Hello)) {
                        reservedException = new IllegalArgumentException(string + ": " + (Object)((Object)protocolVersion) + " is not FIPS compliant");
                        break;
                    }
                    if (arrayList.contains((Object)protocolVersion)) continue;
                    arrayList.add(protocolVersion);
                }
            }
        }

        static {
            CustomizedSSLProtocols.populate(JDK_TLS_CLIENT_PROTOCOLS, customizedClientProtocols);
            CustomizedSSLProtocols.populate(JDK_TLS_SERVER_PROTOCOLS, customizedServerProtocols);
        }
    }

    public static final class TLS13Context
    extends AbstractTLSContext {
        private static final List<ProtocolVersion> clientDefaultProtocols = SunJSSE.isFIPS() ? SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10}) : SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30});
        private static final List<CipherSuite> clientDefaultCipherSuites = SSLContextImpl.access$200(clientDefaultProtocols, true);

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }
    }

    public static final class TLS12Context
    extends AbstractTLSContext {
        private static final List<ProtocolVersion> clientDefaultProtocols = SunJSSE.isFIPS() ? SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10}) : SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30});
        private static final List<CipherSuite> clientDefaultCipherSuites = SSLContextImpl.access$200(clientDefaultProtocols, true);

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }
    }

    public static final class TLS11Context
    extends AbstractTLSContext {
        private static final List<ProtocolVersion> clientDefaultProtocols = SunJSSE.isFIPS() ? SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS11, ProtocolVersion.TLS10}) : SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30});
        private static final List<CipherSuite> clientDefaultCipherSuites = SSLContextImpl.access$200(clientDefaultProtocols, true);

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }
    }

    public static final class TLS10Context
    extends AbstractTLSContext {
        private static final List<ProtocolVersion> clientDefaultProtocols = SunJSSE.isFIPS() ? SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10}) : SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.SSL30});
        private static final List<CipherSuite> clientDefaultCipherSuites = SSLContextImpl.access$200(clientDefaultProtocols, true);

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }
    }

    private static abstract class AbstractTLSContext
    extends SSLContextImpl {
        private static final List<ProtocolVersion> supportedProtocols;
        private static final List<ProtocolVersion> serverDefaultProtocols;
        private static final List<CipherSuite> supportedCipherSuites;
        private static final List<CipherSuite> serverDefaultCipherSuites;

        private AbstractTLSContext() {
        }

        @Override
        List<ProtocolVersion> getSupportedProtocolVersions() {
            return supportedProtocols;
        }

        @Override
        List<CipherSuite> getSupportedCipherSuites() {
            return supportedCipherSuites;
        }

        @Override
        List<ProtocolVersion> getServerDefaultProtocolVersions() {
            return serverDefaultProtocols;
        }

        @Override
        List<CipherSuite> getServerDefaultCipherSuites() {
            return serverDefaultCipherSuites;
        }

        @Override
        SSLEngine createSSLEngineImpl() {
            return new SSLEngineImpl(this);
        }

        @Override
        SSLEngine createSSLEngineImpl(String string, int n) {
            return new SSLEngineImpl(this, string, n);
        }

        static ProtocolVersion[] getSupportedProtocols() {
            if (SunJSSE.isFIPS()) {
                return new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10};
            }
            return new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30, ProtocolVersion.SSL20Hello};
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedProtocols = Arrays.asList(ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10);
                serverDefaultProtocols = SSLContextImpl.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10});
            } else {
                supportedProtocols = Arrays.asList(ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30, ProtocolVersion.SSL20Hello);
                serverDefaultProtocols = SSLContextImpl.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10, ProtocolVersion.SSL30, ProtocolVersion.SSL20Hello});
            }
            supportedCipherSuites = SSLContextImpl.getApplicableSupportedCipherSuites(AbstractTLSContext.supportedProtocols);
            serverDefaultCipherSuites = SSLContextImpl.getApplicableEnabledCipherSuites(AbstractTLSContext.serverDefaultProtocols, false);
        }
    }
}

