/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.events;

import jdk.jfr.Category;
import jdk.jfr.DataAmount;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.events.AbstractJDKEvent;

@Name(value="jdk.FileRead")
@Label(value="File Read")
@Category(value={"Java Application"})
@Description(value="Reading data from a file")
public final class FileReadEvent
extends AbstractJDKEvent {
    public static final ThreadLocal<FileReadEvent> EVENT = new ThreadLocal<FileReadEvent>(){

        @Override
        protected FileReadEvent initialValue() {
            return new FileReadEvent();
        }
    };
    @Label(value="Path")
    @Description(value="Full path of the file")
    public String path;
    @Label(value="Bytes Read")
    @Description(value="Number of bytes read from the file (possibly 0)")
    @DataAmount
    public long bytesRead;
    @Label(value="End of File")
    @Description(value="If end of file was reached")
    public boolean endOfFile;

    public void reset() {
        this.path = null;
        this.endOfFile = false;
        this.bytesRead = 0L;
    }
}

