/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

public class Page {
    private long baseAddress;
    private byte[] data;
    private Page prev;
    private Page next;
    private long unmappedPageLength;

    public Page(long baseAddress, byte[] data) {
        this.baseAddress = baseAddress;
        this.data = data;
    }

    public Page(long baseAddress, long unmappedPageLength) {
        this.baseAddress = baseAddress;
        this.unmappedPageLength = unmappedPageLength;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public long getSize() {
        if (this.data != null) {
            return this.data.length;
        }
        return this.unmappedPageLength;
    }

    public boolean isMapped() {
        return this.data != null;
    }

    public Page getPrev() {
        return this.prev;
    }

    public void setPrev(Page prev) {
        this.prev = prev;
    }

    public Page getNext() {
        return this.next;
    }

    public void setNext(Page next) {
        this.next = next;
    }

    public void getData(long startAddress, long numBytes, int[] destBuf, long destBufOffset) throws IndexOutOfBoundsException {
        int startOffset = (int)(startAddress - this.baseAddress);
        if (this.data == null && (startOffset < 0 || (long)startOffset + numBytes > this.baseAddress + this.unmappedPageLength)) {
            throw new IndexOutOfBoundsException("startAddress = " + startAddress + ", baseAddress = " + this.baseAddress + ", unmappedPageLength = " + this.unmappedPageLength);
        }
        for (int i = 0; i < (int)numBytes; ++i) {
            destBuf[i + (int)destBufOffset] = this.data != null ? this.data[i + startOffset] & 0xFF : -1;
        }
    }

    public void getDataAsBytes(long startAddress, long numBytes, byte[] destBuf, long destBufOffset) throws IndexOutOfBoundsException {
        long startOffset = startAddress - this.baseAddress;
        if (this.data == null) {
            throw new RuntimeException("Bug in PageCache; should not fetch from unmapped pages using getDataAsBytes");
        }
        System.arraycopy(this.data, (int)startOffset, destBuf, (int)destBufOffset, (int)numBytes);
    }

    public boolean getBoolean(long address) {
        return this.getByte(address) != 0;
    }

    public byte getByte(long address) {
        return this.data[(int)address - (int)this.baseAddress];
    }

    public short getShort(long address, boolean bigEndian) {
        int start = (int)address - (int)this.baseAddress;
        if (bigEndian) {
            return (short)(this.data[start + 1] & 0xFF | (this.data[start] & 0xFF) << 8);
        }
        return (short)((this.data[start + 1] & 0xFF) << 8 | this.data[start] & 0xFF);
    }

    public char getChar(long address, boolean bigEndian) {
        return (char)this.getShort(address, bigEndian);
    }

    public int getInt(long address, boolean bigEndian) {
        int start = (int)address - (int)this.baseAddress;
        if (bigEndian) {
            return this.data[start + 3] & 0xFF | (this.data[start + 2] & 0xFF) << 8 | (this.data[start + 1] & 0xFF) << 16 | (this.data[start] & 0xFF) << 24;
        }
        return (this.data[start + 3] & 0xFF) << 24 | (this.data[start + 2] & 0xFF) << 16 | (this.data[start + 1] & 0xFF) << 8 | this.data[start] & 0xFF;
    }

    public long getLong(long address, boolean bigEndian) {
        int start = (int)address - (int)this.baseAddress;
        if (bigEndian) {
            return (long)this.data[start + 7] & 0xFFL | ((long)this.data[start + 6] & 0xFFL) << 8 | ((long)this.data[start + 5] & 0xFFL) << 16 | ((long)this.data[start + 4] & 0xFFL) << 24 | ((long)this.data[start + 3] & 0xFFL) << 32 | ((long)this.data[start + 2] & 0xFFL) << 40 | ((long)this.data[start + 1] & 0xFFL) << 48 | ((long)this.data[start] & 0xFFL) << 56;
        }
        return ((long)this.data[start + 7] & 0xFFL) << 56 | ((long)this.data[start + 6] & 0xFFL) << 48 | ((long)this.data[start + 5] & 0xFFL) << 40 | ((long)this.data[start + 4] & 0xFFL) << 32 | ((long)this.data[start + 3] & 0xFFL) << 24 | ((long)this.data[start + 2] & 0xFFL) << 16 | ((long)this.data[start + 1] & 0xFFL) << 8 | (long)this.data[start] & 0xFFL;
    }

    public float getFloat(long address, boolean bigEndian) {
        return Float.intBitsToFloat(this.getInt(address, bigEndian));
    }

    public double getDouble(long address, boolean bigEndian) {
        return Double.longBitsToDouble(this.getLong(address, bigEndian));
    }
}

