/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.util.CurveDB;
import sun.security.util.DerValue;
import sun.security.util.ECKeySizeParameterSpec;
import sun.security.util.NamedCurve;
import sun.security.util.ObjectIdentifier;

public final class ECParameters
extends AlgorithmParametersSpi {
    private NamedCurve namedCurve;

    public static AlgorithmParameters getAlgorithmParameters(ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC", "SunEC");
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("EC parameters error", generalSecurityException);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec == null) {
            throw new InvalidParameterSpecException("paramSpec must not be null");
        }
        if (algorithmParameterSpec instanceof NamedCurve) {
            this.namedCurve = (NamedCurve)algorithmParameterSpec;
            return;
        }
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.namedCurve = CurveDB.lookup((ECParameterSpec)algorithmParameterSpec);
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
            this.namedCurve = CurveDB.lookup(string);
        } else if (algorithmParameterSpec instanceof ECKeySizeParameterSpec) {
            int n = ((ECKeySizeParameterSpec)algorithmParameterSpec).getKeySize();
            this.namedCurve = CurveDB.lookup(n);
        } else {
            throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
        }
        if (this.namedCurve == null) {
            throw new InvalidParameterSpecException("Not a supported curve: " + algorithmParameterSpec);
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag == 6) {
            ObjectIdentifier objectIdentifier = derValue.getOID();
            NamedCurve namedCurve = CurveDB.lookup(objectIdentifier.toString());
            if (namedCurve == null) {
                throw new IOException("Unknown named curve: " + objectIdentifier);
            }
            this.namedCurve = namedCurve;
            return;
        }
        throw new IOException("Only named ECParameters supported");
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(this.namedCurve));
        }
        if (clazz.isAssignableFrom(ECGenParameterSpec.class)) {
            String string = this.namedCurve.getObjectId();
            return (T)((AlgorithmParameterSpec)clazz.cast(new ECGenParameterSpec(string)));
        }
        if (clazz.isAssignableFrom(ECKeySizeParameterSpec.class)) {
            int n = this.namedCurve.getCurve().getField().getFieldSize();
            return (T)((AlgorithmParameterSpec)clazz.cast(new ECKeySizeParameterSpec(n)));
        }
        throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.namedCurve.getEncoded();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        if (this.namedCurve == null) {
            return "Not initialized";
        }
        return this.namedCurve.toString();
    }
}

