/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpPacket;

public final class JdpBroadcaster {
    private final InetAddress addr;
    private final int port;
    private final DatagramChannel channel;

    public JdpBroadcaster(InetAddress inetAddress, InetAddress inetAddress2, int n, int n2) throws IOException, JdpException {
        this.addr = inetAddress;
        this.port = n;
        StandardProtocolFamily standardProtocolFamily = inetAddress instanceof Inet6Address ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.channel = DatagramChannel.open(standardProtocolFamily);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)n2);
        if (inetAddress2 != null) {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress2);
            try {
                this.channel.bind(new InetSocketAddress(inetAddress2, 0));
            }
            catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
                throw new JdpException("Unable to bind to source address");
            }
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, networkInterface);
        }
    }

    public JdpBroadcaster(InetAddress inetAddress, int n, int n2) throws IOException, JdpException {
        this(inetAddress, null, n, n2);
    }

    public void sendPacket(JdpPacket jdpPacket) throws IOException {
        byte[] byArray = jdpPacket.getPacketData();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.channel.send(byteBuffer, new InetSocketAddress(this.addr, this.port));
    }

    public void shutdown() throws IOException {
        this.channel.close();
    }
}

