/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.osgi.repo.AbstractOSGiResolver;
import org.apache.ivy.osgi.updatesite.UpdateSiteLoader;
import org.xml.sax.SAXException;

public class UpdateSiteResolver
extends AbstractOSGiResolver {
    private String url;
    private Long metadataTtl;
    private Boolean forceMetadataUpdate;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMetadataTtl(Long metadataTtl) {
        this.metadataTtl = metadataTtl;
    }

    public void setForceMetadataUpdate(Boolean forceMetadataUpdate) {
        this.forceMetadataUpdate = forceMetadataUpdate;
    }

    protected void init() {
        if (this.url == null) {
            throw new RuntimeException("Missing url");
        }
        CacheResourceOptions options = new CacheResourceOptions();
        if (this.metadataTtl != null) {
            options.setTtl(this.metadataTtl);
        }
        if (this.forceMetadataUpdate != null) {
            options.setForce(this.forceMetadataUpdate);
        }
        UpdateSiteLoader loader = new UpdateSiteLoader(this.getRepositoryCacheManager(), this.getEventManager(), options);
        try {
            this.setRepoDescriptor(loader.load(new URI(this.url)));
        }
        catch (IOException e) {
            throw new RuntimeException("IO issue while trying to read the update site (" + e.getMessage() + ")");
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse the updatesite (" + e.getMessage() + ")");
        }
        catch (SAXException e) {
            throw new RuntimeException("Illformed updatesite (" + e.getMessage() + ")");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Illformed url (" + e.getMessage() + ")");
        }
    }
}

