/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TileTypeChange;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomChoice;

public final class TileImprovementType
extends FreeColSpecObjectType {
    public static final String TAG = "tile-improvement-type";
    private boolean natural;
    private int magnitude;
    private int addWorkTurns;
    private TileImprovementType requiredImprovementType;
    private Role requiredRole;
    private int expendedAmount;
    private int movementCost = -1;
    private int exposeResourcePercent;
    private int zIndex;
    private Set<String> allowedWorkers = null;
    private Map<TileType, TileTypeChange> tileTypeChanges = null;
    private List<RandomChoice<Disaster>> disasters = null;
    private static final String ADD_WORK_TURNS_TAG = "add-work-turns";
    private static final String DISASTER_TAG = "disaster";
    private static final String EXPENDED_AMOUNT_TAG = "expended-amount";
    private static final String EXPOSE_RESOURCE_PERCENT_TAG = "expose-resource-percent";
    private static final String FROM_TAG = "from";
    private static final String MAGNITUDE_TAG = "magnitude";
    private static final String MOVEMENT_COST_TAG = "movement-cost";
    private static final String NATURAL_TAG = "natural";
    private static final String PROBABILITY_TAG = "probability";
    private static final String REQUIRED_IMPROVEMENT_TAG = "required-improvement";
    private static final String REQUIRED_ROLE_TAG = "required-role";
    private static final String TILE_TYPE_CHANGE_TAG = "tile-type-change";
    private static final String TO_TAG = "to";
    private static final String WORKER_TAG = "worker";
    private static final String ZINDEX_TAG = "zIndex";
    private static final String OLD_EXPENDED_EQUIPMENT_TYPE_TAG = "expended-equipment-type";
    private static final String OLD_EXPOSE_RESOURCE_PERCENT_TAG = "exposeResourcePercent";
    private static final String OLD_CHANGE_TAG = "change";

    public TileImprovementType(String id, Specification specification) {
        super(id, specification);
    }

    public boolean isNatural() {
        return this.natural;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public int getAddWorkTurns() {
        return this.addWorkTurns;
    }

    public TileImprovementType getRequiredImprovementType() {
        return this.requiredImprovementType;
    }

    public Role getRequiredRole() {
        return this.requiredRole;
    }

    public int getExpendedAmount() {
        return this.expendedAmount;
    }

    public int getMoveCost() {
        return this.movementCost;
    }

    public int getMoveCost(int originalCost) {
        return this.movementCost > 0 && this.movementCost < originalCost ? this.movementCost : originalCost;
    }

    public int getExposeResourcePercent() {
        return this.exposeResourcePercent;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int newZIndex) {
        this.zIndex = newZIndex;
    }

    protected Set<String> getAllowedWorkers() {
        if (this.allowedWorkers == null) {
            this.allowedWorkers = new HashSet<String>();
        }
        return this.allowedWorkers;
    }

    protected void setAllowedWorkers(Set<String> allowed) {
        if (this.allowedWorkers == null) {
            this.allowedWorkers = new HashSet<String>();
        } else {
            this.allowedWorkers.clear();
        }
        this.allowedWorkers.addAll(allowed);
    }

    private void addAllowedWorker(String id) {
        this.getAllowedWorkers().add(id);
    }

    private boolean isWorkerTypeAllowed(UnitType unitType) {
        return this.allowedWorkers == null || this.allowedWorkers.isEmpty() || this.allowedWorkers.contains(unitType.getId());
    }

    public boolean isWorkerAllowed(Unit unit) {
        return this.isWorkerTypeAllowed(unit.getType()) && (this.requiredRole == null || unit.getRole() == this.requiredRole);
    }

    public boolean isTileTypeAllowed(TileType tileType) {
        return CollectionUtils.all(this.getScopes(), s -> s.appliesTo(tileType));
    }

    public int getBonus(GoodsType goodsType) {
        Modifier result = this.getProductionModifier(goodsType);
        if (result == null) {
            return 0;
        }
        return (int)result.getValue();
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        return CollectionUtils.first(this.getModifiers(goodsType.getId()));
    }

    protected Map<TileType, TileTypeChange> getTileTypeChanges() {
        if (this.tileTypeChanges == null) {
            this.tileTypeChanges = new HashMap<TileType, TileTypeChange>();
        }
        return this.tileTypeChanges;
    }

    protected void setTileTypeChanges(Map<TileType, TileTypeChange> changes) {
        if (this.tileTypeChanges == null) {
            this.tileTypeChanges = new HashMap<TileType, TileTypeChange>();
        } else {
            this.tileTypeChanges.clear();
        }
        this.tileTypeChanges.putAll(changes);
    }

    public boolean isChangeType() {
        return this.tileTypeChanges != null && !this.tileTypeChanges.isEmpty();
    }

    public AbstractGoods getProduction(TileType from) {
        if (this.tileTypeChanges == null) {
            return null;
        }
        TileTypeChange change = this.tileTypeChanges.get(from);
        return change == null ? null : change.getProduction();
    }

    public TileType getChange(TileType tileType) {
        if (this.tileTypeChanges == null) {
            return null;
        }
        TileTypeChange change = this.tileTypeChanges.get(tileType);
        return change == null ? null : change.getTo();
    }

    public boolean changeContainsTarget(TileType tileType) {
        return this.tileTypeChanges == null ? false : CollectionUtils.any(this.tileTypeChanges.values(), CollectionUtils.matchKey(tileType, TileTypeChange::getTo));
    }

    private void addChange(TileTypeChange change) {
        if (this.tileTypeChanges == null) {
            this.tileTypeChanges = new HashMap<TileType, TileTypeChange>();
        }
        this.tileTypeChanges.put(change.getFrom(), change);
    }

    public int getImprovementValue(Tile tile, GoodsType goodsType) {
        UnitType colonistType = this.getSpecification().getDefaultUnitType();
        return this.getImprovementValue(tile, goodsType, colonistType);
    }

    public int getImprovementValue(Tile tile, GoodsType goodsType, UnitType unitType) {
        int value = 0;
        if (goodsType.isFarmed()) {
            int oldProduction = tile.getType().getPotentialProduction(goodsType, unitType);
            TileType tt = this.getChange(tile.getType());
            if (tt == null) {
                int production = tile.getPotentialProduction(goodsType, unitType);
                if (production > 0) {
                    float chg = this.apply(production, null, goodsType.getId());
                    value = (int)(chg - (float)production);
                }
            } else {
                int chg;
                value = chg = tt.getPotentialProduction(goodsType, unitType) - oldProduction;
            }
        }
        return value;
    }

    public int getImprovementValue(TileType tileType, GoodsType goodsType, UnitType unitType) {
        int value = 0;
        if (goodsType.isFarmed()) {
            int oldProduction = tileType.getPotentialProduction(goodsType, unitType);
            TileType tt = this.getChange(tileType);
            if (tt == null) {
                int production = tileType.getPotentialProduction(goodsType, unitType);
                if (production > 0) {
                    float chg = this.apply(production, null, goodsType.getId());
                    value = (int)(chg - (float)production);
                }
            } else {
                int chg;
                value = chg = tt.getPotentialProduction(goodsType, unitType) - oldProduction;
            }
        }
        return value;
    }

    protected List<RandomChoice<Disaster>> getDisasters() {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        }
        return this.disasters;
    }

    protected void setDisasters(List<RandomChoice<Disaster>> disasters) {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        } else {
            this.disasters.clear();
        }
        this.disasters.addAll(disasters);
    }

    public Stream<RandomChoice<Disaster>> getDisasterChoices() {
        return this.disasters == null ? Stream.empty() : this.disasters.stream();
    }

    private void addDisaster(Disaster disaster, int probability) {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        }
        this.disasters.add(new RandomChoice<Disaster>(disaster, probability));
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TileImprovementType o = this.copyInCast(other, TileImprovementType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.natural = o.isNatural();
        this.magnitude = o.getMagnitude();
        this.addWorkTurns = o.getAddWorkTurns();
        this.requiredImprovementType = o.getRequiredImprovementType();
        this.requiredRole = o.getRequiredRole();
        this.expendedAmount = o.getExpendedAmount();
        this.movementCost = o.getMoveCost();
        this.exposeResourcePercent = o.getExposeResourcePercent();
        this.zIndex = o.getZIndex();
        this.setAllowedWorkers(o.getAllowedWorkers());
        this.setTileTypeChanges(o.getTileTypeChanges());
        this.setDisasters(o.getDisasters());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NATURAL_TAG, this.natural);
        xw.writeAttribute(MAGNITUDE_TAG, this.magnitude);
        xw.writeAttribute(ADD_WORK_TURNS_TAG, this.addWorkTurns);
        if (this.requiredImprovementType != null) {
            xw.writeAttribute(REQUIRED_IMPROVEMENT_TAG, this.requiredImprovementType);
        }
        if (this.requiredRole != null) {
            xw.writeAttribute(REQUIRED_ROLE_TAG, this.requiredRole);
        }
        if (this.expendedAmount != 0) {
            xw.writeAttribute(EXPENDED_AMOUNT_TAG, this.expendedAmount);
        }
        xw.writeAttribute(MOVEMENT_COST_TAG, this.movementCost);
        xw.writeAttribute(ZINDEX_TAG, this.zIndex);
        xw.writeAttribute(EXPOSE_RESOURCE_PERCENT_TAG, this.exposeResourcePercent);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.allowedWorkers != null) {
            for (String string : this.allowedWorkers) {
                xw.writeStartElement(WORKER_TAG);
                xw.writeAttribute("id", string);
                xw.writeEndElement();
            }
        }
        if (this.tileTypeChanges != null) {
            for (Map.Entry entry : CollectionUtils.mapEntriesByValue(this.tileTypeChanges)) {
                ((TileTypeChange)entry.getValue()).toXML(xw);
            }
        }
        for (RandomChoice randomChoice : CollectionUtils.iterable(this.getDisasterChoices())) {
            xw.writeStartElement(DISASTER_TAG);
            xw.writeAttribute("id", ((Disaster)randomChoice.getObject()).getId());
            xw.writeAttribute(PROBABILITY_TAG, randomChoice.getProbability());
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.natural = xr.getAttribute(NATURAL_TAG, false);
        this.magnitude = xr.getAttribute(MAGNITUDE_TAG, 1);
        this.addWorkTurns = xr.getAttribute(ADD_WORK_TURNS_TAG, 0);
        this.requiredImprovementType = xr.getType(spec, REQUIRED_IMPROVEMENT_TAG, TileImprovementType.class, null);
        this.requiredRole = xr.getType(spec, REQUIRED_ROLE_TAG, Role.class, null);
        if (xr.hasAttribute(OLD_EXPENDED_EQUIPMENT_TYPE_TAG)) {
            this.requiredRole = spec.getRole("model.role.pioneer");
        }
        this.expendedAmount = xr.getAttribute(EXPENDED_AMOUNT_TAG, 0);
        this.movementCost = xr.getAttribute(MOVEMENT_COST_TAG, 0);
        this.zIndex = xr.getAttribute(ZINDEX_TAG, 0);
        this.exposeResourcePercent = xr.hasAttribute(OLD_EXPOSE_RESOURCE_PERCENT_TAG) ? xr.getAttribute(OLD_EXPOSE_RESOURCE_PERCENT_TAG, 0) : xr.getAttribute(EXPOSE_RESOURCE_PERCENT_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.allowedWorkers = null;
            this.tileTypeChanges = null;
            this.disasters = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (TILE_TYPE_CHANGE_TAG.equals(tag) || OLD_CHANGE_TAG.equals(tag)) {
            this.addChange(new TileTypeChange(xr, spec));
        } else if (DISASTER_TAG.equals(tag)) {
            Disaster disaster = xr.getType(spec, "id", Disaster.class, null);
            int probability = xr.getAttribute(PROBABILITY_TAG, 100);
            this.addDisaster(disaster, probability);
            xr.closeTag(DISASTER_TAG);
        } else if (WORKER_TAG.equals(tag)) {
            this.addAllowedWorker(xr.readId());
            xr.closeTag(WORKER_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

