/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.groupby.Messages;

public class GroupBy
extends BaseStep
implements StepInterface {
    private GroupByMeta meta = (GroupByMeta)this.getStepMeta().getStepMetaInterface();
    private GroupByData data;

    public GroupBy(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (GroupByData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GroupByMeta)smi;
        this.data = (GroupByData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            int i;
            this.data.inputRowMeta = this.getInputRowMeta();
            if (this.data.inputRowMeta == null) {
                this.data.inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
            }
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.counts = new long[this.meta.getSubjectField().length];
            this.data.subjectnrs = new int[this.meta.getSubjectField().length];
            this.data.cumulativeSumSourceIndexes = new ArrayList<Integer>();
            this.data.cumulativeSumTargetIndexes = new ArrayList<Integer>();
            this.data.cumulativeAvgSourceIndexes = new ArrayList<Integer>();
            this.data.cumulativeAvgTargetIndexes = new ArrayList<Integer>();
            for (i = 0; i < this.meta.getSubjectField().length; ++i) {
                this.data.subjectnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getSubjectField()[i]);
                if (this.data.subjectnrs[i] < 0) {
                    this.logError(Messages.getString("GroupBy.Log.AggregateSubjectFieldCouldNotFound", this.meta.getSubjectField()[i]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (this.meta.getAggregateType()[i] == 11) {
                    this.data.cumulativeSumSourceIndexes.add(this.data.subjectnrs[i]);
                    this.data.cumulativeSumTargetIndexes.add(this.data.inputRowMeta.size() + i);
                }
                if (this.meta.getAggregateType()[i] != 12) continue;
                this.data.cumulativeAvgSourceIndexes.add(this.data.subjectnrs[i]);
                this.data.cumulativeAvgTargetIndexes.add(this.data.inputRowMeta.size() + i);
            }
            this.data.previousSums = new Object[this.data.cumulativeSumTargetIndexes.size()];
            this.data.previousAvgSum = new Object[this.data.cumulativeAvgTargetIndexes.size()];
            this.data.previousAvgCount = new long[this.data.cumulativeAvgTargetIndexes.size()];
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (i = 0; i < this.meta.getGroupField().length; ++i) {
                this.data.groupnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getGroupField()[i]);
                if (this.data.groupnrs[i] >= 0) continue;
                this.logError(Messages.getString("GroupBy.Log.GroupFieldCouldNotFound", this.meta.getGroupField()[i]));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.valueMetaInteger = new ValueMeta("count", 5);
            this.data.valueMetaNumber = new ValueMeta("sum", 1);
            this.initGroupMeta(this.data.inputRowMeta);
            this.newAggregate(r);
            this.data.groupAggMeta = new RowMeta();
            this.data.groupAggMeta.addRowMeta(this.data.groupMeta);
            this.data.groupAggMeta.addRowMeta(this.data.aggMeta);
        }
        if (r == null) {
            if (this.meta.passAllRows()) {
                if (this.data.previous != null) {
                    this.calcAggregate(this.data.previous);
                    this.addToBuffer(this.data.previous);
                }
                this.data.groupResult = this.getAggregateResult();
                Object[] row = this.getRowFromBuffer();
                long lineNr = 0L;
                while (row != null) {
                    int size = this.data.inputRowMeta.size();
                    row = RowDataUtil.addRowData((Object[])row, (int)size, (Object[])this.data.groupResult);
                    size += this.data.groupResult.length;
                    ++lineNr;
                    if (this.meta.isAddingLineNrInGroup() && !Const.isEmpty((String)this.meta.getLineNrInGroupField())) {
                        Long lineNrValue = new Long(lineNr);
                        row = RowDataUtil.addValueData((Object[])row, (int)size, (Object)lineNrValue);
                        ++size;
                    }
                    this.addCumulativeSums(row);
                    this.addCumulativeAverages(row);
                    this.putRow(this.data.outputRowMeta, row);
                    row = this.getRowFromBuffer();
                }
                this.closeInput();
            } else {
                Object[] result;
                if (this.data.previous != null) {
                    this.calcAggregate(this.data.previous);
                }
                if ((result = this.buildResult(this.data.previous)) != null) {
                    this.putRow(this.data.groupAggMeta, result);
                }
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
        } else {
            this.calcAggregate(this.data.previous);
            if (this.meta.passAllRows()) {
                this.addToBuffer(this.data.previous);
            }
        }
        if (!this.sameGroup(this.data.previous, r)) {
            if (this.meta.passAllRows()) {
                this.closeOutput();
                this.data.groupResult = this.getAggregateResult();
                Object[] row = this.getRowFromBuffer();
                long lineNr = 0L;
                while (row != null) {
                    int size = this.data.inputRowMeta.size();
                    row = RowDataUtil.addRowData((Object[])row, (int)size, (Object[])this.data.groupResult);
                    size += this.data.groupResult.length;
                    ++lineNr;
                    if (this.meta.isAddingLineNrInGroup() && !Const.isEmpty((String)this.meta.getLineNrInGroupField())) {
                        Long lineNrValue = new Long(lineNr);
                        row = RowDataUtil.addValueData((Object[])row, (int)size, (Object)lineNrValue);
                        ++size;
                    }
                    this.addCumulativeSums(row);
                    this.addCumulativeAverages(row);
                    this.putRow(this.data.outputRowMeta, row);
                    row = this.getRowFromBuffer();
                }
                this.closeInput();
            } else {
                Object[] result = this.buildResult(this.data.previous);
                if (result != null) {
                    this.putRow(this.data.groupAggMeta, result);
                }
            }
            this.newAggregate(r);
        }
        this.data.previous = this.data.inputRowMeta.cloneRow(r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("GroupBy.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    private void addCumulativeSums(Object[] row) throws KettleValueException {
        for (int i = 0; i < this.data.cumulativeSumSourceIndexes.size(); ++i) {
            int sourceIndex = this.data.cumulativeSumSourceIndexes.get(i);
            Object previousTarget = this.data.previousSums[i];
            Object sourceValue = row[sourceIndex];
            int targetIndex = this.data.cumulativeSumTargetIndexes.get(i);
            ValueMetaInterface sourceMeta = this.data.inputRowMeta.getValueMeta(sourceIndex);
            ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(targetIndex);
            row[targetIndex] = targetMeta.isNull(previousTarget) ? sourceMeta.convertToNormalStorageType(sourceValue) : (sourceMeta.isNull(sourceValue) ? previousTarget : ValueDataUtil.plus((ValueMetaInterface)targetMeta, (Object)this.data.previousSums[i], (ValueMetaInterface)sourceMeta, (Object)row[sourceIndex]));
            this.data.previousSums[i] = row[targetIndex];
        }
    }

    private void addCumulativeAverages(Object[] row) throws KettleValueException {
        for (int i = 0; i < this.data.cumulativeAvgSourceIndexes.size(); ++i) {
            int sourceIndex = this.data.cumulativeAvgSourceIndexes.get(i);
            Object previousTarget = this.data.previousAvgSum[i];
            Object sourceValue = row[sourceIndex];
            int targetIndex = this.data.cumulativeAvgTargetIndexes.get(i);
            ValueMetaInterface sourceMeta = this.data.inputRowMeta.getValueMeta(sourceIndex);
            ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(targetIndex);
            Object sum = null;
            sum = targetMeta.isNull(previousTarget) ? sourceMeta.convertToNormalStorageType(sourceValue) : (sourceMeta.isNull(sourceValue) ? previousTarget : (sourceMeta.isInteger() ? ValueDataUtil.plus((ValueMetaInterface)this.data.valueMetaInteger, (Object)this.data.previousAvgSum[i], (ValueMetaInterface)sourceMeta, (Object)row[sourceIndex]) : ValueDataUtil.plus((ValueMetaInterface)targetMeta, (Object)this.data.previousAvgSum[i], (ValueMetaInterface)sourceMeta, (Object)row[sourceIndex])));
            this.data.previousAvgSum[i] = sum;
            if (!sourceMeta.isNull(sourceValue)) {
                int n = i;
                this.data.previousAvgCount[n] = this.data.previousAvgCount[n] + 1L;
            }
            if (sourceMeta.isInteger()) {
                if (sum == null) {
                    row[targetIndex] = null;
                    continue;
                }
                row[targetIndex] = new Double(((Long)sum).doubleValue() / (double)this.data.previousAvgCount[i]);
                continue;
            }
            row[targetIndex] = ValueDataUtil.divide((ValueMetaInterface)targetMeta, (Object)sum, (ValueMetaInterface)this.data.valueMetaInteger, (Object)this.data.previousAvgCount[i]);
        }
    }

    private boolean sameGroup(Object[] previous, Object[] r) throws KettleValueException {
        return this.data.inputRowMeta.compare(previous, r, this.data.groupnrs) == 0;
    }

    private void calcAggregate(Object[] r) throws KettleValueException {
        block15: for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            Object subj = r[this.data.subjectnrs[i]];
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Object value = this.data.agg[i];
            ValueMetaInterface valueMeta = this.data.aggMeta.getValueMeta(i);
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    this.data.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    continue block15;
                }
                case 2: {
                    if (subjMeta.isNull(subj)) continue block15;
                    this.data.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block15;
                }
                case 13: {
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    double n2 = this.data.counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = (Double)value;
                    double mean = this.data.mean[i];
                    double delta = x - mean;
                    this.data.mean[i] = mean;
                    this.data.agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block15;
                }
                case 15: {
                    if (!subjMeta.isNull(subj)) {
                        Object obj;
                        if (this.data.distinctObjs == null) {
                            this.data.distinctObjs = new Set[this.meta.getSubjectField().length];
                        }
                        if (this.data.distinctObjs[i] == null) {
                            this.data.distinctObjs[i] = new TreeSet<Object>();
                        }
                        if (!this.data.distinctObjs[i].contains(obj = subjMeta.convertToNormalStorageType(subj))) {
                            this.data.distinctObjs[i].add(obj);
                            this.data.agg[i] = (Long)value + 1L;
                        }
                    }
                }
                case 5: {
                    if (subjMeta.isNull(subj)) continue block15;
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block15;
                }
                case 3: {
                    if (subjMeta.compare(subj, valueMeta, value) >= 0) continue block15;
                    this.data.agg[i] = subj;
                    continue block15;
                }
                case 4: {
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block15;
                    this.data.agg[i] = subj;
                    continue block15;
                }
                case 7: {
                    if (subj == null || value != null) continue block15;
                    this.data.agg[i] = subj;
                    continue block15;
                }
                case 8: {
                    if (subj == null) continue block15;
                    this.data.agg[i] = subj;
                    continue block15;
                }
                case 9: {
                    continue block15;
                }
                case 10: {
                    this.data.agg[i] = subj;
                    continue block15;
                }
                case 6: {
                    if (subj == null) continue block15;
                    String vString = valueMeta.getString(value);
                    if (vString.length() > 0) {
                        vString = vString + ", ";
                    }
                    this.data.agg[i] = vString + subjMeta.getString(subj);
                    continue block15;
                }
                case 14: {
                    String vString;
                    if (subj == null) continue block15;
                    String separator = "";
                    if (!Const.isEmpty((String)this.meta.getValueField()[i])) {
                        separator = this.environmentSubstitute(this.meta.getValueField()[i]);
                    }
                    if ((vString = valueMeta.getString(value)).length() > 0) {
                        vString = vString + separator;
                    }
                    this.data.agg[i] = vString + subjMeta.getString(subj);
                    continue block15;
                }
            }
        }
    }

    private void newAggregate(Object[] r) {
        int i;
        for (i = 0; i < this.data.counts.length; ++i) {
            this.data.counts[i] = 0L;
        }
        this.data.distinctObjs = null;
        this.data.agg = new Object[this.data.subjectnrs.length];
        this.data.mean = new double[this.data.subjectnrs.length];
        this.data.aggMeta = new RowMeta();
        for (i = 0; i < this.data.subjectnrs.length; ++i) {
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Object v = null;
            ValueMetaInterface vMeta = null;
            block0 : switch (this.meta.getAggregateType()[i]) {
                case 1: 
                case 2: 
                case 11: 
                case 12: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], subjMeta.isNumeric() ? subjMeta.getType() : 1);
                    switch (subjMeta.getType()) {
                        case 6: {
                            v = new BigDecimal("0");
                            break block0;
                        }
                        case 5: {
                            v = new Long(0L);
                            break block0;
                        }
                    }
                    v = new Double(0.0);
                    break;
                }
                case 13: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 1);
                    v = new Double(0.0);
                    break;
                }
                case 5: 
                case 15: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 5);
                    v = new Long(0L);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(this.meta.getAggregateField()[i]);
                    v = r == null ? null : r[this.data.subjectnrs[i]];
                    break;
                }
                case 6: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 2);
                    v = "";
                    break;
                }
                case 14: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 2);
                    v = "";
                    break;
                }
            }
            if (this.meta.getAggregateType()[i] != 5 && this.meta.getAggregateType()[i] != 15) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            if (v != null) {
                this.data.agg[i] = v;
            }
            this.data.aggMeta.addValueMeta(vMeta);
        }
        for (i = 0; i < this.data.previousSums.length; ++i) {
            this.data.previousSums[i] = null;
        }
        for (i = 0; i < this.data.previousAvgCount.length; ++i) {
            this.data.previousAvgCount[i] = 0L;
            this.data.previousAvgSum[i] = null;
        }
    }

    private Object[] buildResult(Object[] r) throws KettleValueException {
        Object[] result = null;
        if (r != null || this.meta.isAlwaysGivingBackOneRow()) {
            result = RowDataUtil.allocateRowData((int)this.data.groupnrs.length);
            if (r != null) {
                for (int i = 0; i < this.data.groupnrs.length; ++i) {
                    result[i] = r[this.data.groupnrs[i]];
                }
            }
            result = RowDataUtil.addRowData((Object[])result, (int)this.data.groupnrs.length, (Object[])this.getAggregateResult());
        }
        return result;
    }

    private void initGroupMeta(RowMetaInterface previousRowMeta) throws KettleValueException {
        this.data.groupMeta = new RowMeta();
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            this.data.groupMeta.addValueMeta(previousRowMeta.getValueMeta(this.data.groupnrs[i]));
        }
    }

    private Object[] getAggregateResult() throws KettleValueException {
        Object[] result = new Object[this.data.subjectnrs.length];
        if (this.data.subjectnrs != null) {
            for (int i = 0; i < this.data.subjectnrs.length; ++i) {
                Object ag = this.data.agg[i];
                switch (this.meta.getAggregateType()[i]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ag = ValueDataUtil.divide((ValueMetaInterface)this.data.aggMeta.getValueMeta(i), (Object)ag, (ValueMetaInterface)new ValueMeta("c", 5), (Object)new Long(this.data.counts[i]));
                        break;
                    }
                    case 5: {
                        ag = new Long(this.data.counts[i]);
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 13: {
                        double sum = (Double)ag / (double)this.data.counts[i];
                        ag = Math.sqrt(sum);
                        break;
                    }
                }
                result[i] = ag;
            }
        }
        return result;
    }

    private void addToBuffer(Object[] row) throws KettleFileException {
        this.data.bufferList.add(row);
        if (this.data.bufferList.size() > 5000) {
            if (this.data.rowsOnFile == 0) {
                try {
                    this.data.tempFile = File.createTempFile(this.meta.getPrefix(), ".tmp", new File(this.environmentSubstitute(this.meta.getDirectory())));
                    this.data.fos = new FileOutputStream(this.data.tempFile);
                    this.data.dos = new DataOutputStream(this.data.fos);
                    this.data.firstRead = true;
                }
                catch (IOException e) {
                    throw new KettleFileException(Messages.getString("GroupBy.Exception.UnableToCreateTemporaryFile"), (Throwable)e);
                }
            }
            Object[] oldest = this.data.bufferList.get(0);
            this.data.inputRowMeta.writeData(this.data.dos, oldest);
            this.data.bufferList.remove(0);
            ++this.data.rowsOnFile;
        }
    }

    private Object[] getRowFromBuffer() throws KettleFileException {
        if (this.data.rowsOnFile > 0) {
            Object[] row;
            if (this.data.firstRead) {
                try {
                    this.data.fis = new FileInputStream(this.data.tempFile);
                    this.data.dis = new DataInputStream(this.data.fis);
                    this.data.firstRead = false;
                }
                catch (IOException e) {
                    throw new KettleFileException(Messages.getString("GroupBy.Exception.UnableToReadBackRowFromTemporaryFile"), (Throwable)e);
                }
            }
            try {
                row = this.data.inputRowMeta.readData(this.data.dis);
            }
            catch (SocketTimeoutException e) {
                throw new KettleFileException((Throwable)e);
            }
            --this.data.rowsOnFile;
            return row;
        }
        if (this.data.bufferList.size() > 0) {
            Object[] row = this.data.bufferList.get(0);
            this.data.bufferList.remove(0);
            return row;
        }
        return null;
    }

    private void closeOutput() throws KettleFileException {
        try {
            if (this.data.dos != null) {
                this.data.dos.close();
                this.data.dos = null;
            }
            if (this.data.fos != null) {
                this.data.fos.close();
                this.data.fos = null;
            }
            this.data.firstRead = true;
        }
        catch (IOException e) {
            throw new KettleFileException(Messages.getString("GroupBy.Exception.UnableToCloseInputStream"), (Throwable)e);
        }
    }

    private void closeInput() throws KettleFileException {
        try {
            if (this.data.fis != null) {
                this.data.fis.close();
                this.data.fis = null;
            }
            if (this.data.dis != null) {
                this.data.dis.close();
                this.data.dis = null;
            }
        }
        catch (IOException e) {
            throw new KettleFileException(Messages.getString("GroupBy.Exception.UnableToCloseInputStream"), (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GroupByMeta)smi;
        this.data = (GroupByData)sdi;
        if (super.init(smi, sdi)) {
            this.data.bufferList = new ArrayList();
            this.data.rowsOnFile = 0;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.tempFile != null) {
            this.data.tempFile.delete();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

