# -*- coding: utf-8 -*-
# Copyright 2024 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the iosxr_route_maps module
"""


class Route_mapsArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_route_maps module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str"},
                "global": {
                    "type": "dict",
                    "options": {
                        "add": {
                            "type": "dict",
                            "options": {
                                "eigrp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "delay": {"type": "int"},
                                        "reliability": {"type": "int"},
                                        "effective_bandwith": {"type": "int"},
                                        "max_transmission": {"type": "int"},
                                    },
                                },
                                "rip_metric": {"type": "int"},
                            },
                        },
                        "apply": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "route_policy": {"type": "str"},
                                "route_policy_input": {"type": "str"},
                            },
                        },
                        "drop": {"type": "bool"},
                        "pass": {"type": "bool"},
                        "prepend": {
                            "type": "dict",
                            "options": {
                                "number_of_times": {"type": "int"},
                                "as_path": {"type": "int"},
                                "most_recent": {"type": "bool"},
                                "own_as": {"type": "bool"},
                            },
                        },
                        "suppress_route": {"type": "bool"},
                        "unsuppress_route": {"type": "bool"},
                        "remove": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "entire_aspath": {"type": "bool"},
                            },
                        },
                        "set": {
                            "type": "dict",
                            "options": {
                                "administrative_distance": {"type": "int"},
                                "aigp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "icrement": {"type": "bool"},
                                        "decrement": {"type": "bool"},
                                        "metric_number": {"type": "int"},
                                        "igp_cost": {"type": "bool"},
                                    },
                                },
                                "local_preference": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "multiply": {"type": "bool"},
                                        "increment": {"type": "bool"},
                                        "decrement": {"type": "bool"},
                                        "metric_number": {
                                            "type": "int",
                                            "required": True,
                                        },
                                    },
                                },
                                "attribute_set": {"type": "str"},
                                "c_multicast_routing": {
                                    "type": "dict",
                                    "options": {
                                        "bgp": {"type": "bool"},
                                        "pim": {"type": "bool"},
                                    },
                                },
                                "community": {
                                    "type": "dict",
                                    "options": {
                                        "community_name": {"type": "str"},
                                        "additive": {"type": "bool"},
                                    },
                                },
                                "core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "ingress_replication_default": {
                                            "type": "bool",
                                        },
                                        "ingress_replication_partitioned": {
                                            "type": "bool",
                                        },
                                        "mldp": {"type": "bool"},
                                        "mldp_default": {"type": "bool"},
                                        "mldp_inband": {"type": "bool"},
                                        "mldp_partitioned_mp2mp": {"type": "bool"},
                                        "mldp_partitioned_p2mp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "p2mp_te_default": {"type": "bool"},
                                        "p2mp_te_partitioned": {"type": "bool"},
                                        "pim_default": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "dampening": {
                                    "type": "dict",
                                    "options": {
                                        "halflife": {"type": "int"},
                                        "max_suppress": {"type": "int"},
                                        "reuse": {"type": "int"},
                                        "suppress": {"type": "int"},
                                    },
                                },
                                "downstream_core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "eigrp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "delay": {"type": "int"},
                                        "reliability": {"type": "int"},
                                        "effective_bandwith": {"type": "int"},
                                        "max_transmission": {"type": "int"},
                                    },
                                },
                                "fallback_vrf_lookup": {"type": "bool"},
                                "flow_tag": {"type": "int"},
                                "forward_class": {"type": "int"},
                                "ip_precedence": {"type": "int"},
                                "isis_metric": {"type": "int"},
                                "label": {"type": "int"},
                                "label_index": {"type": "int"},
                                "label_mode": {
                                    "type": "dict",
                                    "options": {
                                        "per_ce": {"type": "bool"},
                                        "per_prefix": {"type": "bool"},
                                        "per_vrf": {"type": "bool"},
                                    },
                                },
                                "large_community": {"type": "str"},
                                "level": {
                                    "type": "dict",
                                    "options": {
                                        "level_1": {"type": "bool"},
                                        "level_1_2": {"type": "bool"},
                                        "level_2": {"type": "bool"},
                                    },
                                },
                                "load_balance": {"type": "bool"},
                                "lsm_root": {"type": "str"},
                                "metric_type": {
                                    "type": "dict",
                                    "options": {
                                        "external": {"type": "bool"},
                                        "internal": {"type": "bool"},
                                        "rib_metric_as_external": {"type": "bool"},
                                        "rib_metric_as_internal": {"type": "bool"},
                                        "type_1": {"type": "bool"},
                                        "type_2": {"type": "bool"},
                                    },
                                },
                                "mpls": {"type": "str"},
                                "next_hop": {
                                    "type": "dict",
                                    "options": {"address": {"type": "str"}},
                                },
                                "origin": {
                                    "type": "dict",
                                    "options": {
                                        "egp": {"type": "bool"},
                                        "igp": {"type": "bool"},
                                        "rincomplete": {"type": "bool"},
                                    },
                                },
                                "ospf_metric": {"type": "int"},
                                "path_selection": {
                                    "type": "dict",
                                    "options": {
                                        "all": {"type": "bool"},
                                        "backup": {
                                            "type": "dict",
                                            "options": {
                                                "backup_decimal": {"type": "int"},
                                                "advertise": {"type": "bool"},
                                                "install": {"type": "bool"},
                                            },
                                        },
                                        "best_path": {"type": "bool"},
                                        "group_best": {"type": "bool"},
                                        "multiplath": {"type": "bool"},
                                    },
                                },
                                "path_color": {"type": "bool"},
                                "qos_group": {"type": "int"},
                                "rib_metric": {"type": "int"},
                                "rip_metric": {"type": "int"},
                                "rip_tag": {"type": "int"},
                                "rt_set": {"type": "int"},
                                "s_pmsi": {"type": "bool"},
                                "spf_priority": {
                                    "type": "dict",
                                    "options": {
                                        "critical": {"type": "bool"},
                                        "high": {"type": "bool"},
                                        "medium": {"type": "bool"},
                                    },
                                },
                                "static_p2mp_te": {"type": "str"},
                                "tag": {"type": "int"},
                                "traffic_index": {
                                    "type": "dict",
                                    "options": {
                                        "index_number": {"type": "int"},
                                        "ignore": {"type": "bool"},
                                    },
                                },
                                "upstream_core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "vpn_distinguisher": {"type": "int"},
                                "weight": {"type": "int"},
                            },
                        },
                    },
                },
                "if_section": {
                    "type": "dict",
                    "options": {
                        "condition": {"type": "str"},
                        "add": {
                            "type": "dict",
                            "options": {
                                "eigrp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "delay": {"type": "int"},
                                        "reliability": {"type": "int"},
                                        "effective_bandwith": {"type": "int"},
                                        "max_transmission": {"type": "int"},
                                    },
                                },
                                "rip_metric": {"type": "int"},
                            },
                        },
                        "apply": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "route_policy": {"type": "str"},
                                "route_policy_input": {"type": "str"},
                            },
                        },
                        "drop": {"type": "bool"},
                        "pass": {"type": "bool"},
                        "prepend": {
                            "type": "dict",
                            "options": {
                                "number_of_times": {"type": "int"},
                                "as_path": {"type": "int"},
                                "most_recent": {"type": "bool"},
                                "own_as": {"type": "bool"},
                            },
                        },
                        "suppress_route": {"type": "bool"},
                        "unsuppress_route": {"type": "bool"},
                        "remove": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "entire_aspath": {"type": "bool"},
                            },
                        },
                        "set": {
                            "type": "dict",
                            "options": {
                                "administrative_distance": {"type": "int"},
                                "local_preference": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "multiply": {"type": "bool"},
                                        "increment": {"type": "bool"},
                                        "decrement": {"type": "bool"},
                                        "metric_number": {
                                            "type": "int",
                                            "required": True,
                                        },
                                    },
                                },
                                "aigp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "icrement": {"type": "bool"},
                                        "decrement": {"type": "bool"},
                                        "metric_number": {"type": "int"},
                                        "igp_cost": {"type": "bool"},
                                    },
                                },
                                "attribute_set": {"type": "str"},
                                "c_multicast_routing": {
                                    "type": "dict",
                                    "options": {
                                        "bgp": {"type": "bool"},
                                        "pim": {"type": "bool"},
                                    },
                                },
                                "community": {
                                    "type": "dict",
                                    "options": {
                                        "community_name": {"type": "str"},
                                        "additive": {"type": "bool"},
                                    },
                                },
                                "core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "ingress_replication_default": {
                                            "type": "bool",
                                        },
                                        "ingress_replication_partitioned": {
                                            "type": "bool",
                                        },
                                        "mldp": {"type": "bool"},
                                        "mldp_default": {"type": "bool"},
                                        "mldp_inband": {"type": "bool"},
                                        "mldp_partitioned_mp2mp": {"type": "bool"},
                                        "mldp_partitioned_p2mp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "p2mp_te_default": {"type": "bool"},
                                        "p2mp_te_partitioned": {"type": "bool"},
                                        "pim_default": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "dampening": {
                                    "type": "dict",
                                    "options": {
                                        "halflife": {"type": "int"},
                                        "max_suppress": {"type": "int"},
                                        "reuse": {"type": "int"},
                                        "suppress": {"type": "int"},
                                    },
                                },
                                "downstream_core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "eigrp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "delay": {"type": "int"},
                                        "reliability": {"type": "int"},
                                        "effective_bandwith": {"type": "int"},
                                        "max_transmission": {"type": "int"},
                                    },
                                },
                                "fallback_vrf_lookup": {"type": "bool"},
                                "flow_tag": {"type": "int"},
                                "forward_class": {"type": "int"},
                                "ip_precedence": {"type": "int"},
                                "isis_metric": {"type": "int"},
                                "label": {"type": "int"},
                                "label_index": {"type": "int"},
                                "label_mode": {
                                    "type": "dict",
                                    "options": {
                                        "per_ce": {"type": "bool"},
                                        "per_prefix": {"type": "bool"},
                                        "per_vrf": {"type": "bool"},
                                    },
                                },
                                "large_community": {"type": "str"},
                                "level": {
                                    "type": "dict",
                                    "options": {
                                        "level_1": {"type": "bool"},
                                        "level_1_2": {"type": "bool"},
                                        "level_2": {"type": "bool"},
                                    },
                                },
                                "load_balance": {"type": "bool"},
                                "lsm_root": {"type": "str"},
                                "metric_type": {
                                    "type": "dict",
                                    "options": {
                                        "external": {"type": "bool"},
                                        "internal": {"type": "bool"},
                                        "rib_metric_as_external": {"type": "bool"},
                                        "rib_metric_as_internal": {"type": "bool"},
                                        "type_1": {"type": "bool"},
                                        "type_2": {"type": "bool"},
                                    },
                                },
                                "mpls": {"type": "str"},
                                "next_hop": {
                                    "type": "dict",
                                    "options": {"address": {"type": "str"}},
                                },
                                "origin": {
                                    "type": "dict",
                                    "options": {
                                        "egp": {"type": "bool"},
                                        "igp": {"type": "bool"},
                                        "rincomplete": {"type": "bool"},
                                    },
                                },
                                "ospf_metric": {"type": "int"},
                                "path_selection": {
                                    "type": "dict",
                                    "options": {
                                        "all": {"type": "bool"},
                                        "backup": {
                                            "type": "dict",
                                            "options": {
                                                "backup_decimal": {"type": "int"},
                                                "advertise": {"type": "bool"},
                                                "install": {"type": "bool"},
                                            },
                                        },
                                        "best_path": {"type": "bool"},
                                        "group_best": {"type": "bool"},
                                        "multiplath": {"type": "bool"},
                                    },
                                },
                                "path_color": {"type": "bool"},
                                "qos_group": {"type": "int"},
                                "rib_metric": {"type": "int"},
                                "rip_metric": {"type": "int"},
                                "rip_tag": {"type": "int"},
                                "rt_set": {"type": "int"},
                                "s_pmsi": {"type": "bool"},
                                "spf_priority": {
                                    "type": "dict",
                                    "options": {
                                        "critical": {"type": "bool"},
                                        "high": {"type": "bool"},
                                        "medium": {"type": "bool"},
                                    },
                                },
                                "static_p2mp_te": {"type": "str"},
                                "tag": {"type": "int"},
                                "traffic_index": {
                                    "type": "dict",
                                    "options": {
                                        "index_number": {"type": "int"},
                                        "ignore": {"type": "bool"},
                                    },
                                },
                                "upstream_core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "vpn_distinguisher": {"type": "int"},
                                "weight": {"type": "int"},
                            },
                        },
                    },
                },
                "elseif_section": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "condition": {"type": "str"},
                        "add": {
                            "type": "dict",
                            "options": {
                                "eigrp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "delay": {"type": "int"},
                                        "reliability": {"type": "int"},
                                        "effective_bandwith": {"type": "int"},
                                        "max_transmission": {"type": "int"},
                                    },
                                },
                                "rip_metric": {"type": "int"},
                            },
                        },
                        "apply": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "route_policy": {"type": "str"},
                                "route_policy_input": {"type": "str"},
                            },
                        },
                        "drop": {"type": "bool"},
                        "pass": {"type": "bool"},
                        "prepend": {
                            "type": "dict",
                            "options": {
                                "number_of_times": {"type": "int"},
                                "as_path": {"type": "int"},
                                "most_recent": {"type": "bool"},
                                "own_as": {"type": "bool"},
                            },
                        },
                        "suppress_route": {"type": "bool"},
                        "unsuppress_route": {"type": "bool"},
                        "remove": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "entire_aspath": {"type": "bool"},
                            },
                        },
                        "set": {
                            "type": "dict",
                            "options": {
                                "administrative_distance": {"type": "int"},
                                "local_preference": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "multiply": {"type": "bool"},
                                        "increment": {"type": "bool"},
                                        "decrement": {"type": "bool"},
                                        "metric_number": {
                                            "type": "int",
                                            "required": True,
                                        },
                                    },
                                },
                                "aigp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "icrement": {"type": "bool"},
                                        "decrement": {"type": "bool"},
                                        "metric_number": {"type": "int"},
                                        "igp_cost": {"type": "bool"},
                                    },
                                },
                                "attribute_set": {"type": "str"},
                                "c_multicast_routing": {
                                    "type": "dict",
                                    "options": {
                                        "bgp": {"type": "bool"},
                                        "pim": {"type": "bool"},
                                    },
                                },
                                "community": {
                                    "type": "dict",
                                    "options": {
                                        "community_name": {"type": "str"},
                                        "additive": {"type": "bool"},
                                    },
                                },
                                "core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "ingress_replication_default": {
                                            "type": "bool",
                                        },
                                        "ingress_replication_partitioned": {
                                            "type": "bool",
                                        },
                                        "mldp": {"type": "bool"},
                                        "mldp_default": {"type": "bool"},
                                        "mldp_inband": {"type": "bool"},
                                        "mldp_partitioned_mp2mp": {"type": "bool"},
                                        "mldp_partitioned_p2mp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "p2mp_te_default": {"type": "bool"},
                                        "p2mp_te_partitioned": {"type": "bool"},
                                        "pim_default": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "dampening": {
                                    "type": "dict",
                                    "options": {
                                        "halflife": {"type": "int"},
                                        "max_suppress": {"type": "int"},
                                        "reuse": {"type": "int"},
                                        "suppress": {"type": "int"},
                                    },
                                },
                                "downstream_core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "eigrp_metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "delay": {"type": "int"},
                                        "reliability": {"type": "int"},
                                        "effective_bandwith": {"type": "int"},
                                        "max_transmission": {"type": "int"},
                                    },
                                },
                                "fallback_vrf_lookup": {"type": "bool"},
                                "flow_tag": {"type": "int"},
                                "forward_class": {"type": "int"},
                                "ip_precedence": {"type": "int"},
                                "isis_metric": {"type": "int"},
                                "label": {"type": "int"},
                                "label_index": {"type": "int"},
                                "label_mode": {
                                    "type": "dict",
                                    "options": {
                                        "per_ce": {"type": "bool"},
                                        "per_prefix": {"type": "bool"},
                                        "per_vrf": {"type": "bool"},
                                    },
                                },
                                "large_community": {"type": "str"},
                                "level": {
                                    "type": "dict",
                                    "options": {
                                        "level_1": {"type": "bool"},
                                        "level_1_2": {"type": "bool"},
                                        "level_2": {"type": "bool"},
                                    },
                                },
                                "load_balance": {"type": "bool"},
                                "lsm_root": {"type": "str"},
                                "metric_type": {
                                    "type": "dict",
                                    "options": {
                                        "external": {"type": "bool"},
                                        "internal": {"type": "bool"},
                                        "rib_metric_as_external": {"type": "bool"},
                                        "rib_metric_as_internal": {"type": "bool"},
                                        "type_1": {"type": "bool"},
                                        "type_2": {"type": "bool"},
                                    },
                                },
                                "mpls": {"type": "str"},
                                "next_hop": {
                                    "type": "dict",
                                    "options": {"address": {"type": "str"}},
                                },
                                "origin": {
                                    "type": "dict",
                                    "options": {
                                        "egp": {"type": "bool"},
                                        "igp": {"type": "bool"},
                                        "rincomplete": {"type": "bool"},
                                    },
                                },
                                "ospf_metric": {"type": "int"},
                                "path_selection": {
                                    "type": "dict",
                                    "options": {
                                        "all": {"type": "bool"},
                                        "backup": {
                                            "type": "dict",
                                            "options": {
                                                "backup_decimal": {"type": "int"},
                                                "advertise": {"type": "bool"},
                                                "install": {"type": "bool"},
                                            },
                                        },
                                        "best_path": {"type": "bool"},
                                        "group_best": {"type": "bool"},
                                        "multiplath": {"type": "bool"},
                                    },
                                },
                                "path_color": {"type": "bool"},
                                "qos_group": {"type": "int"},
                                "rib_metric": {"type": "int"},
                                "rip_metric": {"type": "int"},
                                "rip_tag": {"type": "int"},
                                "rt_set": {"type": "int"},
                                "s_pmsi": {"type": "bool"},
                                "spf_priority": {
                                    "type": "dict",
                                    "options": {
                                        "critical": {"type": "bool"},
                                        "high": {"type": "bool"},
                                        "medium": {"type": "bool"},
                                    },
                                },
                                "static_p2mp_te": {"type": "str"},
                                "tag": {"type": "int"},
                                "traffic_index": {
                                    "type": "dict",
                                    "options": {
                                        "index_number": {"type": "int"},
                                        "ignore": {"type": "bool"},
                                    },
                                },
                                "upstream_core_tree": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {"type": "bool"},
                                        "p2mp_te": {"type": "bool"},
                                        "sr_p2mp": {"type": "bool"},
                                    },
                                },
                                "vpn_distinguisher": {"type": "int"},
                                "weight": {"type": "int"},
                            },
                        },
                    },
                },
                "else_section": {
                    "type": "dict",
                    "options": {
                        "global": {
                            "type": "dict",
                            "options": {
                                "add": {
                                    "type": "dict",
                                    "options": {
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "rip_metric": {"type": "int"},
                                    },
                                },
                                "apply": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "route_policy": {"type": "str"},
                                        "route_policy_input": {"type": "str"},
                                    },
                                },
                                "drop": {"type": "bool"},
                                "pass": {"type": "bool"},
                                "prepend": {
                                    "type": "dict",
                                    "options": {
                                        "number_of_times": {"type": "int"},
                                        "as_path": {"type": "int"},
                                        "most_recent": {"type": "bool"},
                                        "own_as": {"type": "bool"},
                                    },
                                },
                                "suppress_route": {"type": "bool"},
                                "unsuppress_route": {"type": "bool"},
                                "remove": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "entire_aspath": {"type": "bool"},
                                    },
                                },
                                "set": {
                                    "type": "dict",
                                    "options": {
                                        "administrative_distance": {"type": "int"},
                                        "local_preference": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "multiply": {"type": "bool"},
                                                "increment": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {
                                                    "type": "int",
                                                    "required": True,
                                                },
                                            },
                                        },
                                        "aigp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "icrement": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {"type": "int"},
                                                "igp_cost": {"type": "bool"},
                                            },
                                        },
                                        "attribute_set": {"type": "str"},
                                        "c_multicast_routing": {
                                            "type": "dict",
                                            "options": {
                                                "bgp": {"type": "bool"},
                                                "pim": {"type": "bool"},
                                            },
                                        },
                                        "community": {
                                            "type": "dict",
                                            "options": {
                                                "community_name": {"type": "str"},
                                                "additive": {"type": "bool"},
                                            },
                                        },
                                        "core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_default": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_partitioned": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "mldp_default": {"type": "bool"},
                                                "mldp_inband": {"type": "bool"},
                                                "mldp_partitioned_mp2mp": {
                                                    "type": "bool",
                                                },
                                                "mldp_partitioned_p2mp": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te": {"type": "bool"},
                                                "p2mp_te_default": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te_partitioned": {
                                                    "type": "bool",
                                                },
                                                "pim_default": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "dampening": {
                                            "type": "dict",
                                            "options": {
                                                "halflife": {"type": "int"},
                                                "max_suppress": {"type": "int"},
                                                "reuse": {"type": "int"},
                                                "suppress": {"type": "int"},
                                            },
                                        },
                                        "downstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "fallback_vrf_lookup": {"type": "bool"},
                                        "flow_tag": {"type": "int"},
                                        "forward_class": {"type": "int"},
                                        "ip_precedence": {"type": "int"},
                                        "isis_metric": {"type": "int"},
                                        "label": {"type": "int"},
                                        "label_index": {"type": "int"},
                                        "label_mode": {
                                            "type": "dict",
                                            "options": {
                                                "per_ce": {"type": "bool"},
                                                "per_prefix": {"type": "bool"},
                                                "per_vrf": {"type": "bool"},
                                            },
                                        },
                                        "large_community": {"type": "str"},
                                        "level": {
                                            "type": "dict",
                                            "options": {
                                                "level_1": {"type": "bool"},
                                                "level_1_2": {"type": "bool"},
                                                "level_2": {"type": "bool"},
                                            },
                                        },
                                        "load_balance": {"type": "bool"},
                                        "lsm_root": {"type": "str"},
                                        "metric_type": {
                                            "type": "dict",
                                            "options": {
                                                "external": {"type": "bool"},
                                                "internal": {"type": "bool"},
                                                "rib_metric_as_external": {
                                                    "type": "bool",
                                                },
                                                "rib_metric_as_internal": {
                                                    "type": "bool",
                                                },
                                                "type_1": {"type": "bool"},
                                                "type_2": {"type": "bool"},
                                            },
                                        },
                                        "mpls": {"type": "str"},
                                        "next_hop": {
                                            "type": "dict",
                                            "options": {
                                                "address": {"type": "str"},
                                            },
                                        },
                                        "origin": {
                                            "type": "dict",
                                            "options": {
                                                "egp": {"type": "bool"},
                                                "igp": {"type": "bool"},
                                                "rincomplete": {"type": "bool"},
                                            },
                                        },
                                        "ospf_metric": {"type": "int"},
                                        "path_selection": {
                                            "type": "dict",
                                            "options": {
                                                "all": {"type": "bool"},
                                                "backup": {
                                                    "type": "dict",
                                                    "options": {
                                                        "backup_decimal": {
                                                            "type": "int",
                                                        },
                                                        "advertise": {
                                                            "type": "bool",
                                                        },
                                                        "install": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                },
                                                "best_path": {"type": "bool"},
                                                "group_best": {"type": "bool"},
                                                "multiplath": {"type": "bool"},
                                            },
                                        },
                                        "path_color": {"type": "bool"},
                                        "qos_group": {"type": "int"},
                                        "rib_metric": {"type": "int"},
                                        "rip_metric": {"type": "int"},
                                        "rip_tag": {"type": "int"},
                                        "rt_set": {"type": "int"},
                                        "s_pmsi": {"type": "bool"},
                                        "spf_priority": {
                                            "type": "dict",
                                            "options": {
                                                "critical": {"type": "bool"},
                                                "high": {"type": "bool"},
                                                "medium": {"type": "bool"},
                                            },
                                        },
                                        "static_p2mp_te": {"type": "str"},
                                        "tag": {"type": "int"},
                                        "traffic_index": {
                                            "type": "dict",
                                            "options": {
                                                "index_number": {"type": "int"},
                                                "ignore": {"type": "bool"},
                                            },
                                        },
                                        "upstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "vpn_distinguisher": {"type": "int"},
                                        "weight": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "if_section": {
                            "type": "dict",
                            "options": {
                                "condition": {"type": "str"},
                                "add": {
                                    "type": "dict",
                                    "options": {
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "rip_metric": {"type": "int"},
                                    },
                                },
                                "apply": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "route_policy": {"type": "str"},
                                        "route_policy_input": {"type": "str"},
                                    },
                                },
                                "drop": {"type": "bool"},
                                "pass": {"type": "bool"},
                                "prepend": {
                                    "type": "dict",
                                    "options": {
                                        "number_of_times": {"type": "int"},
                                        "as_path": {"type": "int"},
                                        "most_recent": {"type": "bool"},
                                        "own_as": {"type": "bool"},
                                    },
                                },
                                "suppress_route": {"type": "bool"},
                                "unsuppress_route": {"type": "bool"},
                                "remove": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "entire_aspath": {"type": "bool"},
                                    },
                                },
                                "set": {
                                    "type": "dict",
                                    "options": {
                                        "administrative_distance": {"type": "int"},
                                        "local_preference": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "multiply": {"type": "bool"},
                                                "increment": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {
                                                    "type": "int",
                                                    "required": True,
                                                },
                                            },
                                        },
                                        "aigp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "icrement": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {"type": "int"},
                                                "igp_cost": {"type": "bool"},
                                            },
                                        },
                                        "attribute_set": {"type": "str"},
                                        "c_multicast_routing": {
                                            "type": "dict",
                                            "options": {
                                                "bgp": {"type": "bool"},
                                                "pim": {"type": "bool"},
                                            },
                                        },
                                        "community": {
                                            "type": "dict",
                                            "options": {
                                                "community_name": {"type": "str"},
                                                "additive": {"type": "bool"},
                                            },
                                        },
                                        "core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_default": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_partitioned": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "mldp_default": {"type": "bool"},
                                                "mldp_inband": {"type": "bool"},
                                                "mldp_partitioned_mp2mp": {
                                                    "type": "bool",
                                                },
                                                "mldp_partitioned_p2mp": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te": {"type": "bool"},
                                                "p2mp_te_default": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te_partitioned": {
                                                    "type": "bool",
                                                },
                                                "pim_default": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "dampening": {
                                            "type": "dict",
                                            "options": {
                                                "halflife": {"type": "int"},
                                                "max_suppress": {"type": "int"},
                                                "reuse": {"type": "int"},
                                                "suppress": {"type": "int"},
                                            },
                                        },
                                        "downstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "fallback_vrf_lookup": {"type": "bool"},
                                        "flow_tag": {"type": "int"},
                                        "forward_class": {"type": "int"},
                                        "ip_precedence": {"type": "int"},
                                        "isis_metric": {"type": "int"},
                                        "label": {"type": "int"},
                                        "label_index": {"type": "int"},
                                        "label_mode": {
                                            "type": "dict",
                                            "options": {
                                                "per_ce": {"type": "bool"},
                                                "per_prefix": {"type": "bool"},
                                                "per_vrf": {"type": "bool"},
                                            },
                                        },
                                        "large_community": {"type": "str"},
                                        "level": {
                                            "type": "dict",
                                            "options": {
                                                "level_1": {"type": "bool"},
                                                "level_1_2": {"type": "bool"},
                                                "level_2": {"type": "bool"},
                                            },
                                        },
                                        "load_balance": {"type": "bool"},
                                        "lsm_root": {"type": "str"},
                                        "metric_type": {
                                            "type": "dict",
                                            "options": {
                                                "external": {"type": "bool"},
                                                "internal": {"type": "bool"},
                                                "rib_metric_as_external": {
                                                    "type": "bool",
                                                },
                                                "rib_metric_as_internal": {
                                                    "type": "bool",
                                                },
                                                "type_1": {"type": "bool"},
                                                "type_2": {"type": "bool"},
                                            },
                                        },
                                        "mpls": {"type": "str"},
                                        "next_hop": {
                                            "type": "dict",
                                            "options": {
                                                "address": {"type": "str"},
                                            },
                                        },
                                        "origin": {
                                            "type": "dict",
                                            "options": {
                                                "egp": {"type": "bool"},
                                                "igp": {"type": "bool"},
                                                "rincomplete": {"type": "bool"},
                                            },
                                        },
                                        "ospf_metric": {"type": "int"},
                                        "path_selection": {
                                            "type": "dict",
                                            "options": {
                                                "all": {"type": "bool"},
                                                "backup": {
                                                    "type": "dict",
                                                    "options": {
                                                        "backup_decimal": {
                                                            "type": "int",
                                                        },
                                                        "advertise": {
                                                            "type": "bool",
                                                        },
                                                        "install": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                },
                                                "best_path": {"type": "bool"},
                                                "group_best": {"type": "bool"},
                                                "multiplath": {"type": "bool"},
                                            },
                                        },
                                        "path_color": {"type": "bool"},
                                        "qos_group": {"type": "int"},
                                        "rib_metric": {"type": "int"},
                                        "rip_metric": {"type": "int"},
                                        "rip_tag": {"type": "int"},
                                        "rt_set": {"type": "int"},
                                        "s_pmsi": {"type": "bool"},
                                        "spf_priority": {
                                            "type": "dict",
                                            "options": {
                                                "critical": {"type": "bool"},
                                                "high": {"type": "bool"},
                                                "medium": {"type": "bool"},
                                            },
                                        },
                                        "static_p2mp_te": {"type": "str"},
                                        "tag": {"type": "int"},
                                        "traffic_index": {
                                            "type": "dict",
                                            "options": {
                                                "index_number": {"type": "int"},
                                                "ignore": {"type": "bool"},
                                            },
                                        },
                                        "upstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "vpn_distinguisher": {"type": "int"},
                                        "weight": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "elseif_section": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "condition": {"type": "str"},
                                "add": {
                                    "type": "dict",
                                    "options": {
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "rip_metric": {"type": "int"},
                                    },
                                },
                                "apply": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "route_policy": {"type": "str"},
                                        "route_policy_input": {"type": "str"},
                                    },
                                },
                                "drop": {"type": "bool"},
                                "pass": {"type": "bool"},
                                "prepend": {
                                    "type": "dict",
                                    "options": {
                                        "number_of_times": {"type": "int"},
                                        "as_path": {"type": "int"},
                                        "most_recent": {"type": "bool"},
                                        "own_as": {"type": "bool"},
                                    },
                                },
                                "suppress_route": {"type": "bool"},
                                "unsuppress_route": {"type": "bool"},
                                "remove": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "entire_aspath": {"type": "bool"},
                                    },
                                },
                                "set": {
                                    "type": "dict",
                                    "options": {
                                        "administrative_distance": {"type": "int"},
                                        "local_preference": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "multiply": {"type": "bool"},
                                                "increment": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {
                                                    "type": "int",
                                                    "required": True,
                                                },
                                            },
                                        },
                                        "aigp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "icrement": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {"type": "int"},
                                                "igp_cost": {"type": "bool"},
                                            },
                                        },
                                        "attribute_set": {"type": "str"},
                                        "c_multicast_routing": {
                                            "type": "dict",
                                            "options": {
                                                "bgp": {"type": "bool"},
                                                "pim": {"type": "bool"},
                                            },
                                        },
                                        "community": {
                                            "type": "dict",
                                            "options": {
                                                "community_name": {"type": "str"},
                                                "additive": {"type": "bool"},
                                            },
                                        },
                                        "core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_default": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_partitioned": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "mldp_default": {"type": "bool"},
                                                "mldp_inband": {"type": "bool"},
                                                "mldp_partitioned_mp2mp": {
                                                    "type": "bool",
                                                },
                                                "mldp_partitioned_p2mp": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te": {"type": "bool"},
                                                "p2mp_te_default": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te_partitioned": {
                                                    "type": "bool",
                                                },
                                                "pim_default": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "dampening": {
                                            "type": "dict",
                                            "options": {
                                                "halflife": {"type": "int"},
                                                "max_suppress": {"type": "int"},
                                                "reuse": {"type": "int"},
                                                "suppress": {"type": "int"},
                                            },
                                        },
                                        "downstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "fallback_vrf_lookup": {"type": "bool"},
                                        "flow_tag": {"type": "int"},
                                        "forward_class": {"type": "int"},
                                        "ip_precedence": {"type": "int"},
                                        "isis_metric": {"type": "int"},
                                        "label": {"type": "int"},
                                        "label_index": {"type": "int"},
                                        "label_mode": {
                                            "type": "dict",
                                            "options": {
                                                "per_ce": {"type": "bool"},
                                                "per_prefix": {"type": "bool"},
                                                "per_vrf": {"type": "bool"},
                                            },
                                        },
                                        "large_community": {"type": "str"},
                                        "level": {
                                            "type": "dict",
                                            "options": {
                                                "level_1": {"type": "bool"},
                                                "level_1_2": {"type": "bool"},
                                                "level_2": {"type": "bool"},
                                            },
                                        },
                                        "load_balance": {"type": "bool"},
                                        "lsm_root": {"type": "str"},
                                        "metric_type": {
                                            "type": "dict",
                                            "options": {
                                                "external": {"type": "bool"},
                                                "internal": {"type": "bool"},
                                                "rib_metric_as_external": {
                                                    "type": "bool",
                                                },
                                                "rib_metric_as_internal": {
                                                    "type": "bool",
                                                },
                                                "type_1": {"type": "bool"},
                                                "type_2": {"type": "bool"},
                                            },
                                        },
                                        "mpls": {"type": "str"},
                                        "next_hop": {
                                            "type": "dict",
                                            "options": {
                                                "address": {"type": "str"},
                                            },
                                        },
                                        "origin": {
                                            "type": "dict",
                                            "options": {
                                                "egp": {"type": "bool"},
                                                "igp": {"type": "bool"},
                                                "rincomplete": {"type": "bool"},
                                            },
                                        },
                                        "ospf_metric": {"type": "int"},
                                        "path_selection": {
                                            "type": "dict",
                                            "options": {
                                                "all": {"type": "bool"},
                                                "backup": {
                                                    "type": "dict",
                                                    "options": {
                                                        "backup_decimal": {
                                                            "type": "int",
                                                        },
                                                        "advertise": {
                                                            "type": "bool",
                                                        },
                                                        "install": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                },
                                                "best_path": {"type": "bool"},
                                                "group_best": {"type": "bool"},
                                                "multiplath": {"type": "bool"},
                                            },
                                        },
                                        "path_color": {"type": "bool"},
                                        "qos_group": {"type": "int"},
                                        "rib_metric": {"type": "int"},
                                        "rip_metric": {"type": "int"},
                                        "rip_tag": {"type": "int"},
                                        "rt_set": {"type": "int"},
                                        "s_pmsi": {"type": "bool"},
                                        "spf_priority": {
                                            "type": "dict",
                                            "options": {
                                                "critical": {"type": "bool"},
                                                "high": {"type": "bool"},
                                                "medium": {"type": "bool"},
                                            },
                                        },
                                        "static_p2mp_te": {"type": "str"},
                                        "tag": {"type": "int"},
                                        "traffic_index": {
                                            "type": "dict",
                                            "options": {
                                                "index_number": {"type": "int"},
                                                "ignore": {"type": "bool"},
                                            },
                                        },
                                        "upstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "vpn_distinguisher": {"type": "int"},
                                        "weight": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "else_section": {
                            "type": "dict",
                            "options": {
                                "add": {
                                    "type": "dict",
                                    "options": {
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "rip_metric": {"type": "int"},
                                    },
                                },
                                "apply": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "route_policy": {"type": "str"},
                                        "route_policy_input": {"type": "str"},
                                    },
                                },
                                "drop": {"type": "bool"},
                                "pass": {"type": "bool"},
                                "prepend": {
                                    "type": "dict",
                                    "options": {
                                        "number_of_times": {"type": "int"},
                                        "as_path": {"type": "int"},
                                        "most_recent": {"type": "bool"},
                                        "own_as": {"type": "bool"},
                                    },
                                },
                                "suppress_route": {"type": "bool"},
                                "unsuppress_route": {"type": "bool"},
                                "remove": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "entire_aspath": {"type": "bool"},
                                    },
                                },
                                "set": {
                                    "type": "dict",
                                    "options": {
                                        "administrative_distance": {"type": "int"},
                                        "local_preference": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "multiply": {"type": "bool"},
                                                "increment": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {
                                                    "type": "int",
                                                    "required": True,
                                                },
                                            },
                                        },
                                        "aigp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "icrement": {"type": "bool"},
                                                "decrement": {"type": "bool"},
                                                "metric_number": {"type": "int"},
                                                "igp_cost": {"type": "bool"},
                                            },
                                        },
                                        "attribute_set": {"type": "str"},
                                        "c_multicast_routing": {
                                            "type": "dict",
                                            "options": {
                                                "bgp": {"type": "bool"},
                                                "pim": {"type": "bool"},
                                            },
                                        },
                                        "community": {
                                            "type": "dict",
                                            "options": {
                                                "community_name": {"type": "str"},
                                                "additive": {"type": "bool"},
                                            },
                                        },
                                        "core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_default": {
                                                    "type": "bool",
                                                },
                                                "ingress_replication_partitioned": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "mldp_default": {"type": "bool"},
                                                "mldp_inband": {"type": "bool"},
                                                "mldp_partitioned_mp2mp": {
                                                    "type": "bool",
                                                },
                                                "mldp_partitioned_p2mp": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te": {"type": "bool"},
                                                "p2mp_te_default": {
                                                    "type": "bool",
                                                },
                                                "p2mp_te_partitioned": {
                                                    "type": "bool",
                                                },
                                                "pim_default": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "dampening": {
                                            "type": "dict",
                                            "options": {
                                                "halflife": {"type": "int"},
                                                "max_suppress": {"type": "int"},
                                                "reuse": {"type": "int"},
                                                "suppress": {"type": "int"},
                                            },
                                        },
                                        "downstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "eigrp_metric": {
                                            "type": "dict",
                                            "options": {
                                                "bandwidth": {"type": "int"},
                                                "delay": {"type": "int"},
                                                "reliability": {"type": "int"},
                                                "effective_bandwith": {
                                                    "type": "int",
                                                },
                                                "max_transmission": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "fallback_vrf_lookup": {"type": "bool"},
                                        "flow_tag": {"type": "int"},
                                        "forward_class": {"type": "int"},
                                        "ip_precedence": {"type": "int"},
                                        "isis_metric": {"type": "int"},
                                        "label": {"type": "int"},
                                        "label_index": {"type": "int"},
                                        "label_mode": {
                                            "type": "dict",
                                            "options": {
                                                "per_ce": {"type": "bool"},
                                                "per_prefix": {"type": "bool"},
                                                "per_vrf": {"type": "bool"},
                                            },
                                        },
                                        "large_community": {"type": "str"},
                                        "level": {
                                            "type": "dict",
                                            "options": {
                                                "level_1": {"type": "bool"},
                                                "level_1_2": {"type": "bool"},
                                                "level_2": {"type": "bool"},
                                            },
                                        },
                                        "load_balance": {"type": "bool"},
                                        "lsm_root": {"type": "str"},
                                        "metric_type": {
                                            "type": "dict",
                                            "options": {
                                                "external": {"type": "bool"},
                                                "internal": {"type": "bool"},
                                                "rib_metric_as_external": {
                                                    "type": "bool",
                                                },
                                                "rib_metric_as_internal": {
                                                    "type": "bool",
                                                },
                                                "type_1": {"type": "bool"},
                                                "type_2": {"type": "bool"},
                                            },
                                        },
                                        "mpls": {"type": "str"},
                                        "next_hop": {
                                            "type": "dict",
                                            "options": {
                                                "address": {"type": "str"},
                                            },
                                        },
                                        "origin": {
                                            "type": "dict",
                                            "options": {
                                                "egp": {"type": "bool"},
                                                "igp": {"type": "bool"},
                                                "rincomplete": {"type": "bool"},
                                            },
                                        },
                                        "ospf_metric": {"type": "int"},
                                        "path_selection": {
                                            "type": "dict",
                                            "options": {
                                                "all": {"type": "bool"},
                                                "backup": {
                                                    "type": "dict",
                                                    "options": {
                                                        "backup_decimal": {
                                                            "type": "int",
                                                        },
                                                        "advertise": {
                                                            "type": "bool",
                                                        },
                                                        "install": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                },
                                                "best_path": {"type": "bool"},
                                                "group_best": {"type": "bool"},
                                                "multiplath": {"type": "bool"},
                                            },
                                        },
                                        "path_color": {"type": "bool"},
                                        "qos_group": {"type": "int"},
                                        "rib_metric": {"type": "int"},
                                        "rip_metric": {"type": "int"},
                                        "rip_tag": {"type": "int"},
                                        "rt_set": {"type": "int"},
                                        "s_pmsi": {"type": "bool"},
                                        "spf_priority": {
                                            "type": "dict",
                                            "options": {
                                                "critical": {"type": "bool"},
                                                "high": {"type": "bool"},
                                                "medium": {"type": "bool"},
                                            },
                                        },
                                        "static_p2mp_te": {"type": "str"},
                                        "tag": {"type": "int"},
                                        "traffic_index": {
                                            "type": "dict",
                                            "options": {
                                                "index_number": {"type": "int"},
                                                "ignore": {"type": "bool"},
                                            },
                                        },
                                        "upstream_core_tree": {
                                            "type": "dict",
                                            "options": {
                                                "ingress_replication": {
                                                    "type": "bool",
                                                },
                                                "mldp": {"type": "bool"},
                                                "p2mp_te": {"type": "bool"},
                                                "sr_p2mp": {"type": "bool"},
                                            },
                                        },
                                        "vpn_distinguisher": {"type": "int"},
                                        "weight": {"type": "int"},
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "purged",
                "rendered",
                "gathered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
