/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class DecodingReader
extends PushbackReader {
    private static Reader staticReader = new StringReader("");
    private ByteBuffer bbuf;
    private PushbackInputStream stream;
    private CharsetDecoder cd;
    private CharsetEncoder ce;

    public DecodingReader(InputStream stream, int size, Charset cs) {
        super(staticReader);
        this.stream = new PushbackInputStream(stream, size);
        this.cd = cs.newDecoder();
        this.cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.cd.onMalformedInput(CodingErrorAction.REPLACE);
        this.ce = cs.newEncoder();
        this.bbuf = ByteBuffer.allocate(size);
        ((Buffer)this.bbuf).flip();
    }

    public final void setCharset(Charset cs) {
        this.cd = cs.newDecoder();
        this.cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.cd.onMalformedInput(CodingErrorAction.REPLACE);
        this.ce = cs.newEncoder();
    }

    public final Charset getCharset() {
        return this.cd.charset();
    }

    @Override
    public final void close() throws IOException {
        this.stream.close();
    }

    @Override
    public final void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported.");
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final boolean ready() throws IOException {
        return this.stream.available() != 0 || this.bbuf.remaining() != 0;
    }

    @Override
    public final void reset() throws IOException {
        throw new IOException("reset/mark not supported.");
    }

    @Override
    public final long skip(long n) throws IOException {
        char[] cbuf = new char[(int)Math.min(4096L, n)];
        for (long m = n; m > 0L; m += Math.min((long)cbuf.length, m)) {
            int r = this.read(cbuf, 0, (int)Math.min((long)cbuf.length, m));
            if (r >= 0) continue;
            return n - m;
        }
        return n;
    }

    @Override
    public final void unread(int c) throws IOException {
        char[] ch = Character.toChars(c);
        this.unread(ch, 0, ch.length);
    }

    @Override
    public final void unread(char[] cbuf, int off, int len) throws IOException {
        ByteBuffer tb = this.ce.encode(CharBuffer.wrap(cbuf, off, len));
        if (tb.limit() > this.bbuf.position()) {
            int i = this.bbuf.limit();
            while (i-- > this.bbuf.position()) {
                this.stream.unread(this.bbuf.get(i));
            }
            ((Buffer)this.bbuf).clear();
            this.ce.encode(CharBuffer.wrap(cbuf, off, len), this.bbuf, true);
            ((Buffer)this.bbuf).flip();
        } else {
            int j = this.bbuf.position() - 1;
            int i = tb.limit();
            while (i-- > 0) {
                this.bbuf.put(j, tb.get(i));
                --j;
            }
            ((Buffer)this.bbuf).position(j + 1);
        }
    }

    @Override
    public final void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    private boolean ensureBbuf(boolean force) throws IOException {
        if (this.bbuf.remaining() == 0 || force) {
            byte[] by;
            int c;
            this.bbuf.compact();
            int size = this.stream.available();
            if (size > this.bbuf.remaining() || size == 0) {
                size = this.bbuf.remaining();
            }
            if ((c = this.stream.read(by = new byte[size])) < 0) {
                ((Buffer)this.bbuf).flip();
                return false;
            }
            this.bbuf.put(by, 0, c);
            ((Buffer)this.bbuf).flip();
        }
        return true;
    }

    @Override
    public final int read() throws IOException {
        char[] ch = new char[1];
        int i = this.read(ch, 0, 1);
        if (i < 0) {
            return i;
        }
        if (!Character.isHighSurrogate(ch[0])) {
            return ch[0];
        }
        char high = ch[0];
        i = this.read(ch, 0, 1);
        if (i < 0) {
            return i;
        }
        return Character.toCodePoint(high, ch[0]);
    }

    @Override
    public final int read(char[] cbuf, int off, int len) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
        return this.read(cb);
    }

    @Override
    public final int read(CharBuffer cb) throws IOException {
        int len = cb.remaining();
        boolean notEof = true;
        boolean forceRead = false;
        while (cb.remaining() > 0 && notEof) {
            int oldRemaining = cb.remaining();
            notEof = this.ensureBbuf(forceRead);
            CoderResult r = this.cd.decode(this.bbuf, cb, !notEof);
            if (oldRemaining == cb.remaining() && CoderResult.OVERFLOW == r) {
                cb.put('?');
                this.bbuf.get();
            }
            forceRead = CoderResult.UNDERFLOW == r;
        }
        if (cb.remaining() == len) {
            return -1;
        }
        return len - cb.remaining();
    }

    @Override
    public final int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }
}

