"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAgentRoutes = registerAgentRoutes;
var _configSchema = require("@osd/config-schema");
var _llm = require("../../common/constants/llm");
var _error_handler = require("./error_handler");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerAgentRoutes(router, assistantService) {
  router.post({
    path: _llm.AGENT_API.EXECUTE,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.oneOf([_configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentId: _configSchema.schema.string()
      }), _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentConfigName: _configSchema.schema.string()
      })])
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    try {
      const assistantClient = assistantService.getScopedClient(req, context);
      if ('agentId' in req.query) {
        const response = await assistantClient.executeAgent(req.query.agentId, req.body);
        return res.ok({
          body: response
        });
      }
      const response = await assistantClient.executeAgentByConfigName(req.query.agentConfigName, req.body);
      return res.ok({
        body: response
      });
    } catch (e) {
      return (0, _error_handler.handleError)(e, res, context.assistant_plugin.logger);
    }
  }));
  router.get({
    path: _llm.AGENT_API.CONFIG_EXISTS,
    validate: {
      query: _configSchema.schema.oneOf([_configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentConfigName: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })])
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    try {
      const assistantClient = assistantService.getScopedClient(req, context);
      const promises = Array().concat(req.query.agentConfigName).map(configName => assistantClient.getAgentIdByConfigName(configName));
      const results = await Promise.all(promises);
      const exists = results.every(r => Boolean(r));
      return res.ok({
        body: {
          exists
        }
      });
    } catch (e) {
      return res.ok({
        body: {
          exists: false
        }
      });
    }
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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