%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote,ragged-right]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  ragged-right = ##t
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/partcombine-and-autobeamoff.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: 0cc270b871321ae5aa8622cea8d8262aafd16641
  texidocja = "
@code{\\partCombine} と共に @code{\\autoBeamOff} を使用した場合の挙動は@c
理解しづらいです。

譜全体で自動連桁をオフにするために、代わりに以下を用いたほうが良いです:

@code{\\set Staff.autoBeaming = ##f}

@code{\\partCombine} は 3 種類のボイスを作り出します --
符幹が上向きの単一ボイス、符幹が下向きの単一ボイス、パート結合が行われた@c
ボイスです。

@code{\\autoBeamOff} を @code{\\partCombine} の 1 つ目の引数の中で用いた@c
場合、符幹が上向きのボイスか、結合されたボイスのどちらかの、現在アクティブな@c
方に適用されます。@code{\\autoBeamOff} が 2 つ目の引数の中で用いられた@c
場合、符幹が下向きのボイスに適用されます。

@code{\\partCombine} の中で全ての自動連桁をオフにするために
@code{\\autoBeamOff} を用いるためには、3 回呼び出しを行う必要があります。
"
  doctitleja = "\\partCombine と \\autoBeamOff"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
La funzione @code{\\autoBeamOff}, se usata insieme a
@code{\\partCombine}, può essere difficile da comprendere.

È preferibile usare invece


@code{\\set Staff.autoBeaming = ##f}


per assicurarsi che la disposizione delle travature sia disabilitata
per tutto il rigo.


@code{\\partCombine} funziona con 3 voci -- gambo in su singolo,
gambo in giù singolo, gambo in su unito.


L'uso di @code{\\autoBeamOff} all'interno del primo argomento di partCombine
ha effetto sulla voce che è attiva al momento in cui la funzione viene elaborata,
ovvero sul gambo in su singolo o sul gambo in giù unito. L'uso di @code{\\autoBeamOff}
nel secondo argomento avrà effetto sulla voce che ha il gambo in giù singolo.


Per poter usare @code{\\autoBeamOff} per impedire tutte le disposizioni automatiche
delle travature, se usato con @code{\\partCombine}, è necessario richiamare
tre volte la funzione @code{\\autoBeamOff}.

"
  doctitleit = "PartCombine e autoBeamOff"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
La fonction @code{\\autoBeamOff} dans le cadre d'un @code{\\partCombine}
agit de façon bien particulière ; c'est pourquoi il vaut mieux tout
d'abord recourir à

@example
\set Staff.autobeaming = ##f
@end example

@noindent
pour désactiver les ligatures automatiques pour l'ensemble de la portée
concernée.

L'instruction @code{\\partCombine} fonctionne apparemment sur la base de
trois voix : solo hampes montantes, solo hampes descendantes et ensemble
hampes montantes.

Lorsque @code{\\autoBeamOff} apparaît dans le premier argument de la
combinaison, il s'applique à la voix active à ce moment précis, qu'il
s'agisse du solo hampes montantes ou du combiné hampes montantes.
Lorsqu'elle est introduite dans le second argument, la commande
@code{\\autoBeamOff} s'appliquera au solo hampes descendantes.

Vous devrez donc, afin que @code{\\autoBeamOff} soit pleinement
opérationnel dans le cadre d'un @code{\\partCombine}, l'introduire aux
@strong{trois} niveaux.
"

  doctitlefr = "PartCombine et autoBeamOff"

%% Translation of GIT committish: 00f0ca84dbb015617f8ce36dd13db59bbfef8f11
  texidoces = "
Puede ser difícil comprender la función de @code{\\autoBeamOff} cuando
se usa con @code{\\partCombine}.

Puede ser preferible usar


@code{\\set Staff.autoBeaming = ##f}


en su lugar, para asegurarse de que el barrado automático se desactiva
para todo el pentagrama.


@code{\\partCombine} funciona aparentemente con tres voces: plica
arriba cuando hay una sola voz, plica abajo con la otra, y plica
arriba cuando está combinada.


Una llamada a @code{\\autoBeamOff} en el primer argumento de
partCombine se aplica a la voz que está activa en el momento en que se
procesa la llamada, ya sea voz única con la plica hacia arriba, hacia
abajo o combinadas.  Una llamada a @code{\\autoBeamOff} en el segundo
argumento se aplica a la voz que está sola con la plica abajo.


Para pode usar @code{\\autoBeamOff} con el objeto de detener todo el
barrado automático cuando se usa con @code{\\partCombine}, es
necesario hacer tres llamadas a @code{\\autoBeamOff}.

"
  doctitlees = "PartCombine y autoBeamOff"

%%   Translation of GIT committish: ab9e3136d78bfaf15cc6d77ed1975d252c3fe506

  texidocde = "
Die Funktionsweise von @code{\autoBeamOff}, wenn es zusammen mit
@code{\partCombine} eingesetzt wird, kann schwer zu verstehen sein.
Es kann besser sein, anstatt dessen

@example
\set Staff.autobeaming = ##f
@end example

@noindent
zu benutzen, um sicherzustellen, dass die automatische Bebalkung für das
gesamte System ausgeschaltet ist.

@code{\partCombine} funktioniert offensichtlich mit 3 Stimme (Hals nach oben
einfach, Hals nach unten einfach, Hals nach oben kombiniert).

Ein @code{\autoBeamOff}-Befehl im ersten Argument von @code{\partCombine}
gilt für die Stimme, die zu dem Zeitpunkt aktiv ist, an dem der Befehl
verarbeitet wird, entweder für Hals nach oben, nach unten oder Hals nach
oben kombiniert.  Ein @code{\autoBeamOff}-Befehl im zweiten Argument gilt
für die Stimme, die mit Hals nach unten einfach ist.

Um @code{\autoBeamOff} zu benutzen, damit alle automatischen Balken aufhören,
wenn man es mit @code{\partCombine} verwendet, muss @code{\autoBeamOff}
@emph{dreimal} aufgerufen werden.

"
doctitlede = "PartCombine und autoBeamOff"


%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidocca = "
Pot ser difícil entendre la funció de @code{\\autoBeamOff} quan s'usa
amb @code{\\partcombine}.

Pot ser preferible usar


@code{\\set Staff.autoBeaming = ##f}

en el seu lloc, per assegurar-se que el barrat automàtic es desactiva
per a tot el pentagrama.

@code{\\partcombine} funciona aparentement amb tres veus: plica amunt
quan hi ha una sola veu, plica avall amb l'altra, i plica amunt quan
està combinada.

Una crida a @code{\\autoBeamOff} en el primer argument de partcombine
s'aplica a la veu que està activa en el moment en el qual es processa
la crida, ja sigui veu única amb la plica cap amunt, cap avall o
combinades.  Una crida a @code{\\autoBeamOff} en el segon argument
s'aplica a la veu que estigui sola amb la aplica avall.

Per poder usar @code{\\autoBeamOff} amb l'objectiu de detenir tot el
barrat automàtic quan s'usa amb @code{\\partcombine}, cal fer tres
crides a @code{\\autoBeamOff}.

"
  doctitleca = "Partcombine i autoBeamOff"

  lsrtags = "rhythms"

  texidoc = "
The function of @code{\\autoBeamOff} when used with
@code{\\partCombine} can be difficult to understand.

It may be preferable to use

@code{\\set Staff.autoBeaming = ##f}

instead, to ensure that autobeaming will be turned off for the entire
staff.

@code{\\partCombine} apparently works with 3 voices -- stem up single,
stem down single, stem up combined.

An @code{\\autoBeamOff} call in the first argument to
@code{\\partCombine} will apply to the voice that is active at the time
the call is processed, either stem up single or stem up combined. An
@code{\\autoBeamOff} call in the second argument will apply to the
voice that is stem down single.

In order to use @code{\\autoBeamOff} to stop all autobeaming when used
with @code{\\partCombine}, it will be necessary to use @emph{three}
calls to @code{\\autoBeamOff}.
"

  doctitle = "Partcombine and autoBeamOff"
} % begin verbatim


{
  %\set Staff.autoBeaming = ##f % turns off all autobeaming
  \partCombine
  {
    \autoBeamOff % applies to split up stems
    \repeat unfold 4 a'16
    %\autoBeamOff % applies to combined up stems
    \repeat unfold 4 a'8
    \repeat unfold 4 a'16
  }
  {
    \autoBeamOff % applies to down stems
    \repeat unfold 4 f'8
    \repeat unfold 8 f'16 |
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
