<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'הגדרות חשבון',
    'sidebar_personalization' => 'התאמה אישית',
    'sidebar_settings_storage' => 'אחסון',
    'sidebar_settings_export' => 'יצוא נתונים',
    'sidebar_settings_users' => 'משתמשים',
    'sidebar_settings_subscriptions' => 'הרשמה',
    'sidebar_settings_import' => 'יבוא נתונים',
    'sidebar_settings_tags' => 'ניהול תגיות',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'משאבי DAV',
    'sidebar_settings_security' => 'אבטחה',
    'sidebar_settings_auditlogs' => 'יומני ביקורת',

    'title_general' => 'מידע כללי',
    'title_i18n' => 'הגדרות בינלאומיות',
    'title_layout' => 'פריסה',

    'me_title' => 'אותי כאיש קשר',
    'me_help' => 'איש קשר זה או הייצוג <em>שלך</em> במוניקה',
    'me_select' => 'נא לבחור איש קשר',
    'me_no_contact' => 'טרם נבחרו אנשי קשר.',
    'me_select_click' => 'יש ללחוץ כאן כדי לבחור אנשי קשר.',
    'me_remove_contact' => 'הסרת השיוך',
    'me_choose' => 'בחירה עצמית',
    'me_choose_placeholder' => 'בחירה עצמית',

    'export_title' => 'יצוא נתוני החשבון שלך',
    'export_be_patient' => 'יש ללחוץ על הכפתור כדי להתחיל את הייצוא. עיבוד הייצוא עשוי לארוך מספר דקות - נא להתאזר בסבלנות ולא ללחוץ על הכפתור שוב.',
    'export_title_sql' => 'ייצוא ל־SQL',
    'export_sql_explanation' => 'יצוא הנתונים שלך במבנה SQL מאפשר לך לקחת את הנתונים שלך ולייבא אותם לעותק של מוניקה משלך. לתכונה זו יש ערך רק אם יש לך שרת משלך.',
    'export_sql_cta' => 'ייצוא ל־SQL',
    'export_sql_link_instructions' => 'לתשומת לבך: ניתן <a href=":url">לקרוא את ההנחיות</a> כדי ללמוד יותר על יבוא הקובץ הזה לעותק שלך.',
    'export_title_json' => 'ייצוא ל־Json',
    'export_submitted' => 'הייצוא שלך הוגש, הוא יהיה זמין בעוד מספר רגעים…',
    'export_json_explanation' => 'הנתונים שלך מיוצאים בתצורת Json למטרות גיבוי.',
    'export_json_beta' => 'ייצוא Json הוא במצב תצוגה מקדימה. נא לספר לנו מה דעתך עליו:',
    'export_json_cta' => 'ייצוא ל־Json',
    'export_header_type' => 'סוג',
    'export_header_timestamp' => 'מועד יצירה',
    'export_header_status' => 'מצב',
    'export_header_actions' => 'פעולות',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'אין נתונים שיוצאו עדיין',
    'export_type_json' => 'ייצוא Json',
    'export_type_sql' => 'ייצוא SQL',
    'export_status_todo' => 'הוגש',
    'export_status_doing' => 'מתבצע',
    'export_status_done' => 'בוצע',
    'export_status_failed' => 'נכשל',
    'export_not_done' => 'אי אפשר להוריד, הייצוא עדיין לא בוצע.',

    'firstname' => 'שם פרטי',
    'lastname' => 'שם משפחה',
    'name_order' => 'סדר השמות',
    'name_order_firstname_lastname' => '<שם פרטי> <שם משפחה> – ישראל ישראלי',
    'name_order_lastname_firstname' => '<שם משפחה> <שם פרטי> – ישראלי ישראל',
    'name_order_firstname_lastname_nickname' => '<שם פרטי> <שם משפחה> (<כינוי>) – ישראל ישראלי (שרוליק)',
    'name_order_firstname_nickname_lastname' => '<שם פרטי> (<כינוי>) <שם משפחה> – ישראל (שרוליק) ישראלי',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – ישראלי ישראל (שרוליק)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – ישראל (שרוליק) ישראלי',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – שרוליק (ישראל ישראלי)',
    'name_order_nickname_lastname_firstname' => '<כינוי>‏ (<שם משפחה> <שם פרטי>) – שרוליק (ישראלי ישראל)',
    'name_order_nickname' => '<כינוי> – שרוליק',
    'currency' => 'מטבע',
    'name' => 'שמך: :name',
    'email' => 'כתובת דוא״ל',
    'email_placeholder' => 'נא להקליד כתובת דוא״ל',
    'email_help' => 'זו היא כתובת הדוא״ל המשמשת לכניסה ולשם גם תשלח מוניקה את התזכורות שלך.',
    'timezone' => 'אזור זמן',
    'temperature_scale' => 'יחידות טמפרטורה',
    'temperature_scale_fahrenheit' => 'פרנהייט (‎°F)',
    'temperature_scale_celsius' => 'צלזיוס (‎°C)',
    'layout' => 'פריסה',
    'layout_small' => 'רוחב של 1200 פיקסלים לכל היותר',
    'layout_big' => 'הרוחב המלא של הדפדפן',
    'save' => 'עדכון העדפות',
    'delete_title' => 'מחיקת החשבון שלך',
    'delete_desc' => 'למחוק את החשבון שלך? מחיקה היא לצמיתות וכל הנתונים שלך יימחקו לצמיתות גם הם. אם יש לך מינוי, הוא יבוטל מיידית.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'לאפס את החשבון שלך? פעולה זו תסיר את כל אנשי הקשר שלך ואת כל המידע המשויך להם. החשבון שלך לא יימחק.',
    'reset_title' => 'איפוס החשבון שלך',
    'reset_cta' => 'איפוס חשבון',
    'reset_notice' => 'לאפס את החשבון שלך? זאת פעולה בלתי הפיכה.',
    'reset_success' => 'החשבון שלך אופס בהצלחה.',
    'delete_notice' => 'למחוק את החשבון שלך? פעולה זו היא לצמיתות ולא ניתן להשתקם ממנה. כל הנתונים שלך יימחקו ולא ניתן יהיה לשחזר אותם.',
    'delete_cta' => 'מחיקת חשבון',
    'settings_success' => 'ההעדפות עודכנו!',
    'locale' => 'שפה בה נעשה שימוש ביישום',
    'locale_help' => 'מעניין אותך לסייע בתרגום מוניקה לשפה חדשה? נא להיכנס <a href=":url" target="_blank" lang="he">לקישור הבא לקבלת מידע נוסף</a>.',
    'locale_ar' => 'ערבית',
    'locale_cs' => 'צ׳כית',
    'locale_de' => 'גרמנית',
    'locale_el' => 'יוונית',
    'locale_en' => 'אנגלית',
    'locale_en-GB' => 'אנגלית בריטית',
    'locale_es' => 'ספרדית',
    'locale_fr' => 'צרפתית',
    'locale_he' => 'עברית',
    'locale_hr' => 'קרואטית',
    'locale_id' => 'אינדונזית',
    'locale_it' => 'איטלקית',
    'locale_ja' => 'יפנית',
    'locale_nl' => 'הולנדית',
    'locale_pt' => 'פורטוגלית',
    'locale_pt-BR' => 'פורטוגלית ברזילאית',
    'locale_ru' => 'רוסית',
    'locale_sv' => 'שוודית',
    'locale_vi' => 'וייטנאמית',
    'locale_zh' => 'סינית מפושטת',
    'locale_zh-TW' => 'סינית מסורתית',
    'locale_tr' => 'טורקית',

    'security_title' => 'אבטחה',
    'security_help' => 'שינוי נדבכי האבטחה של החשבון שלך.',
    'password_change' => 'להחליף את הססמה שלך',
    'password_current' => 'הססמה הנוכחית',
    'password_current_placeholder' => 'נא להקליד את הססמה הנוכחית שלך',
    'password_new1' => 'ססמה חדשה',
    'password_new1_placeholder' => 'למלא את הססמה החדשה שלך',
    'password_new2' => 'אישור הססמה החדשה שלך',
    'password_new2_placeholder' => 'נא להקליד את הססמה החדשה שלך שוב',
    'password_btn' => 'החלפת ססמה',
    '2fa_title' => 'אימות דו־שלבי',
    '2fa_otp_title' => 'יישומון לנייד לאימות דו־שלבי',
    '2fa_enable_title' => 'הפעלת אימות דו־שלבי',
    '2fa_enable_description' => 'ניתן להפעיל אימות דו־שלבי כדי להגביר את האבטחה של החשבון שלך.',
    '2fa_enable_otp' => 'יש לפתוח את יישומון האימות הדו־שלבי שלך ולסרוק את ברקוד ה־QR שלהלן:',
    '2fa_enable_otp_help' => 'אם יישומון האימות הדו־שלבי שלך אינו תומך בקודים מסוג QR, יש להקליד את הקוד שלהלן:',
    '2fa_enable_otp_validate' => 'נא לאמת את ההתקן החדש שזה עתה הגדרת:',
    '2fa_enable_success' => 'הופעל אימות דו־שלבי',
    '2fa_enable_error' => 'אירעה שגיאה בעת הניסיון להפעיל אימות דו־שלבי',
    '2fa_enable_error_already_set' => 'האימות הדו־שלבי כבר מופעל',
    '2fa_disable_title' => 'השבתת אימות דו־שלבי',
    '2fa_disable_description' => 'השבתת האימות הדו־שלבי לחשבון שלך. נא להיזהר, החשבון שלך יהיה הרבה פחות מאובטח!',
    '2fa_disable_success' => 'אימות דו־שלבי מושבת',
    '2fa_disable_error' => 'אירעה שגיאה בעת הניסיון להשבית את האימות הדו־שלבי',

    'webauthn_title' => 'מפתח אבטחה — פרוטוקול WebAuthn',
    'webauthn_enable_description' => 'הוספת מפתח אבטחה חדש',
    'webauthn_key_name_help' => 'נא לתת למפתח שלך שם.',
    'webauthn_key_name' => 'שם מפתח:',
    'webauthn_success' => 'המפתח שלך מזוהה ועובר וידוא.',
    'webauthn_last_use' => 'שימוש אחרון: {timestamp}',
    'webauthn_delete_confirmation' => 'למחוק את המפתח הזה?',
    'webauthn_delete_success' => 'המפתח נמחק',
    'webauthn_insertKey' => 'נא להכניס את מפתח האבטחה שלך.',
    'webauthn_buttonAdvise' => 'אם למפתח האבטחה שלך יש כפתור, יש ללחוץ עליו.',
    'webauthn_noButtonAdvise' => 'אם אין לו, יש להסיר אותו ולהכניס שוב.',
    'webauthn_not_supported' => 'בדפדפן שלך עדיין אין תמיכה ב־WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn נתמך עם חיבורים מאובטחים בלבד. נא לטעון את העמוד הזה בתצורת https.',
    'webauthn_error_already_used' => 'המפתח הזה כבר רשום. אין זה הכרחי לרשום אותו שוב.',
    'webauthn_error_not_allowed' => 'הזמן שהוקצב לפעולה פג או שאין אישור.',

    'recovery_title' => 'קודים לשחזור',
    'recovery_show' => 'קבלת קודים לשחזור',
    'recovery_copy_help' => 'העתקת קודים ללוח הגזירים שלך',
    'recovery_help_intro' => 'אלו הקודים שלך לטובת שחזור:',
    'recovery_help_information' => 'ניתן להשתמש בכל קוד שחזור פעם אחת בלבד.',
    'recovery_clipboard' => 'הקודים הועתקו ללוח הגזירים.',
    'recovery_generate' => 'יצירת קודים חדשים…',
    'recovery_generate_help' => 'יצירת קודים חדשים תשלול את הקודים שנוצרו לפניהם.',
    'recovery_already_used_help' => 'כבר נעשה שימוש בקוד הזה.',

    'users_list_title' => 'משתמשים עם גישה לחשבון שלך',
    'users_list_add_user' => 'הזמנת משתמש חדש',
    'users_list_you' => 'מדובר בך',
    'users_list_invitations_title' => 'הזמנות ממתינות',
    'users_list_invitations_explanation' => 'להלן מופיעים האנשים שהזמנת להשתמש במוניקה כשותפים.',
    'users_list_invitations_invited_by' => 'הזמנה מאת :name',
    'users_list_invitations_sent_date' => 'נשלח ב־:date',
    'users_blank_title' => 'רק לך יש גישה לחשבון הזה.',
    'users_blank_add_title' => 'להזמין מישהו נוסף?',
    'users_blank_description' => 'לאדם הזה יש את אותה רמת הגישה כמוך ותהיה לו אפשרות להוסיף, לערוך או למחוק פרטי קשר.',
    'users_blank_cta' => 'להזמין מישהו',
    'users_add_title' => 'ניתן להזמין משתמש חדש לחשבון שלך בדוא״ל',
    'users_add_description' => 'לאדם זה יש את אותה רמת גישה כמוך, לרבות הזמנת או מחיקת משתמשים אחרים, כולל אותך. נא לוודא שמדובר באדם מהימן בטרם מתן הגישה.',
    'users_add_email_field' => 'נא להקליד את כתובת הדוא״ל של האדם שברצונך להזמין',
    'users_add_confirmation' => 'מוסכם עלי להזמין את המשתמש הזה לחשבון שלי. ברור לי שלאדם הזה תהיה גישה לכל המידע שלי ויוכל לראות בדיוק מה שאני רואה.',
    'users_add_cta' => 'הזמנת משתמש דרך דוא״ל',
    'users_accept_title' => 'קבלת ההזמנה ויצירת חשבון חדש',
    'users_error_please_confirm' => 'נא להסכים להזמנת המשתמש הזה בטרם המשך תהליך ההזמנה',
    'users_error_email_already_taken' => 'כתובת דוא״ל זו כבר תפוסה. נא לבחור באחת אחרת',
    'users_error_already_invited' => 'כבר הזמנת את המשתמש הזה. נא לבחור בכתובת דוא״ל אחרת.',
    'users_error_email_not_similar' => 'זאת לא כתובת הדוא״ל של האדם שהזמנת.',
    'users_invitation_deleted_confirmation_message' => 'ההזמנה נמחקה בהצלחה',
    'users_invitations_delete_confirmation' => 'למחוק את ההזמנה הזאת?',
    'users_list_delete_confirmation' => 'למחוק את המשתמש הזה מהחשבון שלך?',
    'users_invitation_need_subscription' => 'הוספת משתמשים נוספים דורשת רישום.',

    'subscriptions_account_current_plan' => 'התכנית הנוכחית שלך',
    'subscriptions_account_current_legacy' => 'תכנית נוכחית, אינה זמינה עוד לבחירה:',
    'subscriptions_account_current_paid_plan' => 'תכנית העבודה שלך כרגע היא :name. תודה לך על ההרשמה.',

    'subscriptions_account_next_billing_title' => 'החשבון הבא',
    'subscriptions_account_next_billing' => 'המינוי שלך יחודש אוטומטית ב־<strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'נחייב אותך ב־<strong>:price</strong> למשך <strong>חודש</strong> נוסף.',
    'subscriptions_account_bill_annual' => 'נחייב אותך ב־<strong>:price</strong> למשך <strong>שנה</strong> נוספת.',
    'subscriptions_account_change' => 'החלפת תכנית',

    'subscriptions_account_cancel_title' => 'ביטול מינוי',
    'subscriptions_account_cancel_action' => 'ביטול מינוי',
    'subscriptions_account_cancel' => 'ניתן לבטל את המינוי בכל עת.',
    'subscriptions_account_free_plan' => 'התכנית שלך היא החינמית.',
    'subscriptions_account_free_plan_upgrade' => 'ניתן לשדרג את החשבון שלך לתכנית :name, שעולה $:price לחודש. להלן היתרונות:',
    'subscriptions_account_free_plan_benefits_users' => 'מספר בלתי מוגבל של משתמשים',
    'subscriptions_account_free_plan_benefits_reminders' => 'תזכורות לפי דוא״ל',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'יבוא אנשי הקשר שלך עם vCard',
    'subscriptions_account_free_plan_benefits_support' => 'כדאי לתמוך במיזם לטווח הרחוק כדי שנוכל להשיק תכונות נפלאות נוספות.',
    'subscriptions_account_upgrade' => 'שדרוג החשבון שלך',
    'subscriptions_account_upgrade_title' => 'ניתן לשדרג את מוניקה כדי להעשיר את הקשרים הבין אישיים שלך.',
    'subscriptions_account_upgrade_choice' => 'נא לבחור בתכנית להלן כדי להצטרף ל־:customers לקוחות ששדרגו את המוניקה שלהם.',
    'subscriptions_account_update_title' => 'עדכון המינוי למוניקה',
    'subscriptions_account_update_description' => 'ניתן לשנות את תדירות המינוי שלך כאן.',
    'subscriptions_account_update_information' => 'החיוב שלך יבוצע מיידית עבור הסכום החדש. המינוי שלך יורחב לתקופה החדשה בהתאם לבחירה שלך.',
    'subscriptions_account_invoices' => 'חשבוניות',
    'subscriptions_account_invoices_download' => 'הורדה',
    'subscriptions_account_invoices_subscription' => 'מינוי מ־:startDate עד :endDate',
    'subscriptions_account_payment' => 'מה דרך התשלום המועדפת עליך?',
    'subscriptions_account_confirm_payment' => 'התשלום שלך לא הושלם, נא <a href=":url">לאשר את התשלום שלך</a>.',
    'subscriptions_downgrade_title' => 'ניתן לשנמך את החשבון שלך לתכנית החינמית',
    'subscriptions_downgrade_limitations' => 'לתכנית החופשית יש מגבלות. כדי לשנמך, עליך לעבור ולאמת את הפריטים ברשימה שלהלן:',
    'subscriptions_downgrade_rule_users' => 'חייב להיות לך רק משתמש אחד בחשבון',
    'subscriptions_downgrade_rule_users_constraint' => 'יש לך <a href=":url">משתמש אחד</a> בחשבון כרגע.|יש לך <a href=":url">:count משתמשים</a> בחשבון כרגע.',
    'subscriptions_downgrade_rule_invitations' => 'אסור שתהיינה לך הזמנות ממתינות כלשהן',
    'subscriptions_downgrade_rule_invitations_constraint' => 'יש לך כרגע <a href=":url">הזמנה אחת בהמתנה</a>.|יש לך כרגע <a href=":url">:count הזמנות בהמתנה</a>.',
    'subscriptions_downgrade_rule_contacts' => 'לא יכולים להיות לך יותר מ־:number אנשי קשר פעילים',
    'subscriptions_downgrade_rule_contacts_constraint' => 'כרגע יש לך <a href=":url">איש קשר יחיד</a>.|כרגע יש לך <a href=":url">:count אנשי קשר</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'נוכל גם <a href=":url">להעביר את כל אנשי הקשר שלך לארכיון עבורך</a> - פעולה זו תמחק את הכלל הזה ותאפשר לך להמשיך בתהליך שנמוך החשבון שלך.',
    'subscriptions_downgrade_cta' => 'שנמוך',
    'subscriptions_downgrade_success' => 'חזרת לתכנית החינמית!',
    'subscriptions_downgrade_thanks' => 'תודה לך על ההתנסות בתכנית בתשלום. אנו ממשיכים ומוסיפים תכונות חדשות למוניקה כל הזמן - יכול להיות שכדאי לך לקפוץ בהמשך כדי לראות אם מעניין אותך להירשם מחדש.',
    'subscriptions_back' => 'חזרה להגדרות',
    'subscriptions_upgrade_title' => 'שדרוג החשבון שלך',
    'subscriptions_upgrade_choose' => 'בחרת בתכנית :plan.',
    'subscriptions_upgrade_infos' => 'אין מאושרים מאתנו. נא להקליד את פרטי התשלום שלך להלן.',
    'subscriptions_upgrade_name' => 'השם על הכרטיס',
    'subscriptions_upgrade_zip' => 'מיקוד או תא דואר',
    'subscriptions_upgrade_credit' => 'כרטיס אשראי או חיוב',
    'subscriptions_upgrade_submit' => 'לשלם {amount}',
    'subscriptions_upgrade_charge' => 'אנו נחייב את הכרטיס שלך בסכום של :price כעת. החיוב הבא יהיה ב־:date. במקרה ששינית את דעתך, ניתן לבטל בכל עת, בלי שאלות מיותרות.',
    'subscriptions_upgrade_charge_handled' => 'הסליקה מבוצעת על ידי <a href=":url">Stripe</a>. המידע על הכרטיס לא עובר דרך השרת שלנו.',
    'subscriptions_upgrade_success' => 'תודה לך! נרשמת כעת.',
    'subscriptions_upgrade_thanks' => 'ברוך בואך לקהילה של אנשים שמנסים להפוך את העולם למקום טוב יותר.',

    'subscriptions_payment_confirm_title' => 'אישור התשלום שלך על סך :amount',
    'subscriptions_payment_confirm_information' => 'נדרש אימות נוסף כדי לעבד את התשלום שלך. נא לאשר את התשלום על ידי מילוי פרטי התשלום שלהלן.',
    'subscriptions_payment_succeeded_title' => 'התשלום עבר בהצלחה',
    'subscriptions_payment_succeeded' => 'תשלום זה כבר אושר בהצלחה.',
    'subscriptions_payment_cancelled_title' => 'התשלום בוטל',
    'subscriptions_payment_cancelled' => 'התשלום בוטל.',
    'subscriptions_payment_error_name' => 'נא לציין את שמך.',
    'subscriptions_payment_success' => 'התשלום בוצע בהצלחה.',

    'subscriptions_pdf_title' => 'המינוי החודשי שלך מסוג :name',
    'subscriptions_plan_frequency_year' => ':amount לשנה',
    'subscriptions_plan_frequency_month' => ':amount לחודש',
    'subscriptions_plan_choose' => 'בחירה בתכנית הזאת',
    'subscriptions_plan_year_title' => 'תשלום שנתי',
    'subscriptions_plan_year_bonus' => 'שקט נפשי לשנה שלמה',
    'subscriptions_plan_month_title' => 'תשלום חודשי',
    'subscriptions_plan_month_bonus' => 'ניתן לבטל בכל עת',
    'subscriptions_plan_include1' => 'כלול בשדרוג שלך:',
    'subscriptions_plan_include2' => 'מספר בלתי מוגבל של אנשי קשר • מספר בלתי מוגבל של משתמשים • תזכורות בדוא״ל • ייבוא עם vCard • התאמה אישית של גיליון אנשי הקשר',
    'subscriptions_plan_include3' => '100% מהרווחים מושקעים בפיתוח מיזם הקוד הפתוח הנהדר הזה.',
    'subscriptions_help_title' => 'פרטים נוספים שעשויים לעניין אותך',
    'subscriptions_help_opensource_title' => 'מה הוא מיזם בקוד פתוח?',
    'subscriptions_help_opensource_desc' => 'מוניקה הוא מיזם בקוד פתוח. משמעות הדבר היא שהוא נבנה על ידי קהילה שרוצה לספק כלי נהדר לטובת הכלל. קוד פתוח משמעו שהקוד גלוי לעיני הציבור ב־GitHub וכולם יכולים לבחון, לשנות או לשפר אותו. כל הכסף שמגויס מושקע לטובת פיתוח תכונות טובות יותר, תשלום על שרתים חזקים יותר ותשלום הוצאות שונות. תודה לך על הסיוע. לא היינו מצליחים לעשות זאת בלעדיך.',
    'subscriptions_help_limits_title' => 'האם יש מגבלה כלשהי על מספר אנשי הקשר שאוכל לנהל בתכנית החינמית?',
    'subscriptions_help_limits_plan' => 'כן. התכניות החינמיות מאפשרת לך לנהל :number אנשי קשר.',
    'subscriptions_help_discounts_title' => 'יש לכם הנחה לארגונים ללא מטרות רווח ומוסדות חינוך?',
    'subscriptions_help_discounts_desc' => 'יש לנו! מוניקה מוצעת בחינם לתלמידים ולארגוני צדקה ללא מטרות רווח. עליך רק ליצור קשר עם <a href=":support">התמיכה</a> עם הוכחה על המצב שלך ואנו נחיל המצב המיוחד הזה על החשבון שלך.',
    'subscriptions_help_change_title' => 'מה אם התחרטתי?',
    'subscriptions_help_change_desc' => 'ניתן לבטל בכל עת, ללא שאלות מיותרות ובאופן עצמאי לחלוטין - אין צורך ליצור קשר עם התמיכה. עם זאת, לא יבוצע זיכוי על התקופה הנוכחית.',

    'stripe_error_card' => 'הכרטיס שלך נדחה. הודעה הדחייה היא: :message',
    'stripe_error_api_connection' => 'התקשורת עם Stripe נכשלה. נא לנסות שוב מאוחר יותר.',
    'stripe_error_rate_limit' => 'הגיעו יותר מדי בקשות אל Stripe כרגע. נא לנסות שוב מאוחר יותר.',
    'stripe_error_invalid_request' => 'משתנים שגויים. נא לנסות שוב מאוחר יותר.',
    'stripe_error_authentication' => 'אימות שגוי מול Stripe',

    'import_title' => 'יבוא אנשי קשר לחשבון שלך',
    'import_cta' => 'עדכון אנשי קשר',
    'import_stat' => 'ייבאת :number קבצים עד כה.',
    'import_result_stat' => 'הועלה vCard עם איש קשר אחד (:total_imported יובא, :total_skipped לא יובא)|הועלה vCard עם :total_contacts אנשי קשר (:total_imported יובאו, :total_skipped לא יובאו)',
    'import_view_report' => 'צפייה בדו״ח',
    'import_in_progress' => 'הייבוא מתבצע כעת. יש לרענן את העמוד בעוד דקה.',
    'import_upload_title' => 'ניתן לייבא את אנשי הקשר שלך מקובץ vCard',
    'import_upload_rules_desc' => 'עם זאת, חלים כאן חוקים כלשהם:',
    'import_upload_rule_format' => 'אנו תומכים בקבצים מהסוגים <code>.vcard</code> ו־<code>.vcf</code>',
    'import_upload_rule_vcard' => 'אנו תומכים ב־vCard גרסה 3.0, שהיא גרסת בררת המחדל עבור Contacts.app של macOS ועבור Google Contacts.',
    'import_upload_rule_instructions' => 'הנחיות יצוא עבור <a href=":url1" target="_blank" rel="noopener noreferrer">Contacts.app של macOS</a> ועבור <a href=":url2" target="_blank" rel="noopener noreferrer">אנשי הקשר של Google</a>.',
    'import_upload_rule_multiple' => 'אם לאנשי הקשר שלך יש מגוון כתובות דוא״ל או מספרי טלפון, רק הרשומה הראשונה תישמר.',
    'import_upload_rule_limit' => 'קבצים מוגבלים ל־10 מ״ב.',
    'import_upload_rule_time' => 'ההעלאה ועיבוד אנשי הקשר עשויים לארוך עד דקה. נא להתאזר בסבלנות.',
    'import_upload_rule_cant_revert' => 'נא לוודא שהנתונים מדויקים בטרם ההעלאה, כיוון שלא ניתן לבטל העלאה.',
    'import_upload_form_file' => 'קובץ ה־<code>.vcf</code> או ה־<code>.vCard</code> שלך:',
    'import_upload_behaviour' => 'התנהגות הייבוא:',
    'import_upload_behaviour_add' => 'הוספת אנשי קשר חדשים ודילוג על הקיימים',
    'import_upload_behaviour_replace' => 'החלפת אנשי קשר קיימים',
    'import_upload_behaviour_help' => 'החלפה תוביל להחלפת כל הנתונים שנמצאים ב־vCard אך השדות הקיימים יישמרו.',
    'import_report_title' => 'דוח יבוא',
    'import_report_date' => 'תאריך הייבוא',
    'import_report_type' => 'סוג הייבוא',
    'import_report_number_contacts' => 'מספר אנשי הקשר בקובץ',
    'import_report_number_contacts_imported' => 'מספר אנשי הקשר שייובאו',
    'import_report_number_contacts_skipped' => 'מספר אנשי הקשר שדולגו',
    'import_report_status_imported' => 'יובאו',
    'import_report_status_skipped' => 'דולגו',
    'import_vcard_parse_error' => 'שגיאה בעת ניתוח רשומת vCard',
    'import_vcard_contact_exist' => 'איש הקשר כבר קיים',
    'import_vcard_contact_no_firstname' => 'אין שם פרטי (חובה)',
    'import_vcard_file_not_found' => 'הקובץ לא נמצא',
    'import_vcard_unknown_entry' => 'שם איש הקשר אינו מוכר',
    'import_vcard_file_no_entries' => 'אין רשומות בקובץ',
    'import_blank_title' => 'לא ייבאת אנשי קשר עדיין.',
    'import_blank_question' => 'לייבא אנשי קשר כעת?',
    'import_blank_description' => 'יש לנו אפשרות לייבא קובצי vCard שניתן לקבל מאנשי הקשר ב־Google או ממנהל אנשי הקשר שלך.',
    'import_blank_cta' => 'יבוא vCard',
    'import_need_subscription' => 'יבוא נתונים דורש מינוי.',

    'tags_list_title' => 'תגיות',
    'tags_list_description' => 'ניתן לארגן את אנשי הקשר שלך על ידי הגדרת תגיות. תגיות עובדות כמו תיקיות אך יש לך אפשרות להוסיף יותר מתגית אחת לאיש קשר. כדי להוסיף תגית חדשה, ניתן להוסיף אותה על איש הקשר עצמו.',
    'tags_list_contact_number' => 'איש קשר אחד|:count אנשי קשר',
    'tags_list_delete_success' => 'התגית נמחקה בהצלחה',
    'tags_list_edit_success' => 'The tag has been successfully updated',
    'tags_list_delete_confirmation' => 'למחוק את התגית? לא יימחקו אנשי קשר, רק התגית.',
    'tags_blank_title' => 'תגיות הן דרך נהדרת לארגון אנשי הקשר שלך.',
    'tags_blank_description' => 'תגיות עובדות כמו תיקיות, אך ניתן להוסיף יותר מתגית אחת לאיש קשר. יש לגשת לאיש קשר ולתייג כחבר, מיד מתחת לשם. לאחר תיוג איש קשר, ניתן לחזור לכאן כדי לנהל את כל התגיות בחשבון שלך.',

    'api_title' => 'גישת API',
    'api_description' => 'ניתן להשתמש ב־API כדי לשנות את הנתונים של מוניקה דרך יישום חיצוני, כגון יישומון לנייד למשל.',
    'api_help' => 'כדי להשתמש ב־API, חובה להשתמש באסימון. ניתן ליצור אסימון גישה אישי (אימות חשוף יותר) או לאמת לקוח OAuth כדי שייצור אותו עבורך. כדאי לעיין <a href=":url">בתיעוד של ה־API</a>.',
    'api_endpoint' => 'נקודת הגישה ל־API של העותק הזה של מוניקה היא:',

    'api_personal_access_tokens' => 'אסימון לגישה אישית',
    'api_pao_description' => 'נא לוודא שהאסימון הזה מועבר לידיים מהימנות - כיוון שהאסימון מעניק גישה לכל הנתונים שלך.',
    'api_token_title' => 'אסימונים לגישה אישית',
    'api_token_create_new' => 'יצירת אסימון חדש',
    'api_token_not_created' => 'לא יצרת אסימונים לגישה אישית.',
    'api_token_name' => 'שם האסימון',
    'api_token_expire' => 'יפוג ב־{date}',
    'api_token_delete' => 'מחיקה',
    'api_token_create' => 'יצירת אסימון',
    'api_token_scopes' => 'תחומים',
    'api_token_help' => 'הנה אסימון הגישה האישית החדש שלך. זאת הפעם היחידה שהוא יופיע כך שעדיף לא לאבד אותו! כעת ניתן להשתמש באסימון הזה כדי לבצע בקשות API.',

    'api_oauth_clients' => 'לקוחות ה־OAuth שלך',
    'api_oauth_clients_desc' => 'אגף זה מסייע לך לרשום לקוחות OAuth משלך.',
    'api_oauth_clients_desc2' => 'יש להשתמש במזהה לקוח זה כדי לבקש אסימון חדש ולהמיר את הקודים למטרת גישה לאסימוני גישה. יש לעיין ב<a href="{url}">תיעוד שלLaravel Passport</a> לקבלת מידע נוסף.',
    'api_oauth_title' => 'לקוחות OAuth',
    'api_oauth_create_new' => 'יצירת לקוח חדש',
    'api_oauth_edit' => 'עריכת לקוח',
    'api_oauth_not_created' => 'לא יצרת לקוחות OAuth כלשהם.',
    'api_oauth_clientid' => 'מזהה לקוח',
    'api_oauth_name' => 'שם',
    'api_oauth_name_help' => 'משהו שהמשתמשים שלך יזהו ויאמינו בו.',
    'api_oauth_secret' => 'סוד',
    'api_oauth_create' => 'יצירת לקוח',
    'api_oauth_redirecturl' => 'כתובת הפניה',
    'api_oauth_redirecturl_help' => 'כתובת הקריאה החוזרת לאימות היישום שלך.',

    'api_authorized_clients' => 'רשימת לקוחות מורשים',
    'api_authorized_clients_desc' => 'אגף זה מציג את כל הלקוחות להם הענקת גישה לנתוני היישומונים שלך. ניתן לשלול את האישור הזה בכל עת.',
    'api_authorized_clients_title' => 'יישומים מאושרים',
    'api_authorized_clients_none' => 'עדיין אין לקוחות מאומתים.',
    'api_authorized_clients_name' => 'שם',
    'api_authorized_clients_scopes' => 'תחומים',

    'personalization_tab_title' => 'התאמת החשבון שלך',

    'personalization_title' => 'להלן ניתן למצוא הגדרות שונות להתאמת החשבון שלך. התכונות האלו מיועדות למשתמשים מתקדמים שרוצים לקבל שליטה מלאה במוניקה.',
    'personalization_contact_field_type_title' => 'סוגי שדות אנשי קשר',
    'personalization_contact_field_type_add' => 'הוספת סוג שדה נתונים חדש',
    'personalization_contact_field_type_description' => 'ניתן להגדיר את כל הסוגים השונים של שדות שניתן לשייך לכל אנשי הקשר שלך. למשל, אם בעתיד תופיע רשת חברתית חדשה, תהיה לך האפשרות להוסיף את דרך התקשורת החדשה הזאת מול אנשי הקשר שלך ממש מכאן.',
    'personalization_contact_field_type_table_name' => 'שם',
    'personalization_contact_field_type_table_protocol' => 'פרוטוקול',
    'personalization_contact_field_type_table_actions' => 'פעולות',
    'personalization_contact_field_type_modal_title' => 'הוספת סוג שדה חדש לאנשי קשר',
    'personalization_contact_field_type_modal_edit_title' => 'עריכת סוג שדה קיים לאנשי קשר',
    'personalization_contact_field_type_modal_delete_title' => 'מחיקת סוג שדה קיים לאנשי קשר',
    'personalization_contact_field_type_modal_delete_description' => 'למחוק את סוג השדה הזה של אנשי הקשר? מחיקת סוג זה של שדה לאנשי קשר ימחק את כל הנתונים מסוג זה עבור כל אנשי הקשר שלך.',
    'personalization_contact_field_type_modal_name' => 'שם',
    'personalization_contact_field_type_modal_protocol' => 'פרוטוקול (רשות)',
    'personalization_contact_field_type_modal_protocol_help' => 'כל סוג חדש של שדה איש קשר אמור לתמוך בלחיצה עליו. אם מוגדר פרוטוקול, אנו נשתמש בלחיצה כדי להפעיל את הפעולה שהוגדרה.',
    'personalization_contact_field_type_modal_icon' => 'סמל (רשות)',
    'personalization_contact_field_type_modal_icon_help' => 'ניתן לשייך סמל עם סוג שדה איש קשר זה. יהיה עליך להוסיף הפניה לסמל מתוך Font Awesome.',
    'personalization_contact_field_type_delete_success' => 'סוג שדה איש הקשר נמחק בהצלחה.',
    'personalization_contact_field_type_add_success' => 'סוג שדה איש הקשר נוסף בהצלחה.',
    'personalization_contact_field_type_edit_success' => 'סוג שדה איש הקשר עודכן בהצלחה.',

    'personalization_genders_title' => 'סוגי מגדר',
    'personalization_genders_add' => 'הוספת סוג מגדר חדש',
    'personalization_genders_desc' => 'ניתן להגדיר כמה מגדרים שיש לך צורך בהם. צריך לפחות סוג מגדר אחד בחשבון שלך.',
    'personalization_genders_modal_add' => 'הוספת סוג מגדר',
    'personalization_genders_modal_edit' => 'עדכון סוג מגדר',
    'personalization_genders_modal_name' => 'שם',
    'personalization_genders_modal_name_help' => 'השם המשמש להצגת המגדר בעמוד יצירת הקשר.',
    'personalization_genders_modal_sex' => 'מגדר',
    'personalization_genders_modal_sex_help' => 'משמש לציון יחסים ומהלך ייבוא/ייצוא של כרטיס ביקור - vCard.',
    'personalization_genders_modal_default' => 'נא לבחור את מגדר בררת המחדל לאנשי קשר חדשים',
    'personalization_genders_modal_delete' => 'מחיקת סוג מגדר',
    'personalization_genders_modal_delete_desc' => 'למחוק את המגדר „{name}”?',
    'personalization_genders_modal_delete_question' => 'לאחד מאנשי הקשר שלך מוגדר המגדר הזה. אם המגדר יימחק, לאיזה מגדר לשייך את איש הקשר?|ל־{count} מאנשי הקשר שלך מוגדר המגדר הזה. אם המגדר יימחק, לאיזה מגדר לשייך את אנשי הקשר?',
    'personalization_genders_modal_delete_question_default' => 'מגדר זה הוא בררת המחדל. לאחר מחיקת מגדר זה, איזה מגדר יוגדר כבררת המחדל החדשה?',
    'personalization_genders_modal_error' => 'נא לבחור במגדר מהרשימה.',
    'personalization_genders_list_contact_number' => 'איש קשר אחד|{count} אנשי קשר',
    'personalization_genders_table_name' => 'שם',
    'personalization_genders_table_sex' => 'מגדר',
    'personalization_genders_table_default' => 'בררת מחדל',
    'personalization_genders_default' => 'מגדר בררת המחדל',
    'personalization_genders_make_default' => 'החלפת מגדר בררת המחדל',
    'personalization_genders_select_default' => 'בחירת מגדר בררת מחדל',
    'personalization_genders_m' => 'זכר',
    'personalization_genders_f' => 'נקבה',
    'personalization_genders_o' => 'אחר',
    'personalization_genders_u' => 'לא ידוע',
    'personalization_genders_n' => 'אין או שלא משנה',

    'personalization_reminder_rule_save' => 'השינוי נשמר',
    'personalization_reminder_rule_title' => 'כללי תזכורות',
    'personalization_reminder_rule_line' => 'יום לפני|יומיים לפני|{count} ימים לפני',
    'personalization_reminder_rule_desc' => 'לכל תזכורת שמוגדרת, מוניקה יכולה לשלוח לך הודעה כמה ימים לפני שהאירוע מתרחש. ניתן להתאים את הגדרות ההתראות האלו כאן. ההתראות חלות על תזכורות חודשיות ושנתיות.',

    'personalization_module_save' => 'השינוי נשמר',
    'personalization_module_title' => 'תכונות',
    'personalization_module_desc' => 'יכול להיות שאין לך צורך בכל התכונות של מוניקה. להלן ניתן לכבות או להפעיל תכונות מסוימות שמשמשות אותך בגיליון אנשי קשר. השינוי הזה ישפיע על כל אנשי הקשר שלך. כיבוי התכונה הזאת לא מוחק נתונים, הוא פשוט מסתיר אותה.',

    'personalisation_paid_upgrade' => 'תכונה זו היא תכונת פרמיום שדורשת הפעלת מינוי בתשלום. ניתן לשדרג את החשבון שלך על ידי מעבר ל<a href=":url">הגדרות > מינוי</a>.',
    'personalisation_paid_upgrade_vue' => 'תכונה זו היא תכונת פרמיום שדורשת הפעלת מינוי בתשלום. ניתן לשדרג את החשבון שלך על ידי מעבר ל<a href="{url}">הגדרות > מינוי</a>.',

    'reminder_time_to_send' => 'השעה ביום בה תישלחנה התזכורות',
    'reminder_time_to_send_help' => 'התזכורת הבאה שלך מתוזמנת להישלח ב־<span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'קטגוריות סוגי פעילות',
    'personalization_activity_type_category_add' => 'הוספת קטגוריית סוג פעילות חדשה',
    'personalization_activity_type_category_table_name' => 'שם',
    'personalization_activity_type_category_description' => 'פעילות עם אחד מאנשי הקשר שלך יכולה להיות מסוג וסוג קטגוריה מסוימים. החשבון שלך מוגדר מראש עם סוגי קטגוריות כלשהם כבררת מחדל, אך ניתן להתאים אותם דרך כאן.',
    'personalization_activity_type_category_table_actions' => 'פעולות',
    'personalization_activity_type_category_modal_add' => 'הוספת קטגוריית סוג פעילות חדשה',
    'personalization_activity_type_category_modal_edit' => 'עריכת קטגוריית סוג פעילות',
    'personalization_activity_type_category_modal_question' => 'איך יש לקרוא לקטגוריה החדשה?',
    'personalization_activity_type_add_button' => 'הוספת סוג פעילות חדש',
    'personalization_activity_type_modal_add' => 'הוספת סוג פעילות חדש',
    'personalization_activity_type_modal_question' => 'איך יש לקרוא לסוג הקטגוריה החדש?',
    'personalization_activity_type_modal_edit' => 'עריכת סוג פעילות',
    'personalization_activity_type_category_modal_delete' => 'מחיקת קטגוריית סוג פעילות',
    'personalization_activity_type_category_modal_delete_desc' => 'למחוק את הקטגוריה הזאת? מחיקתה תמחק את כל סוגי הפעילות המשויכים. פעילויות שאינן שייכות לקטגוריה הזאת לא תושפענה מהמחיקה.',
    'personalization_activity_type_modal_delete' => 'מחיקת סוג פעילות',
    'personalization_activity_type_modal_delete_desc' => 'למחוק את סוג הפעילות הזה? פעילויות ששייכות לקטגוריה זו לא תושפענה מהמחיקה הזאת.',
    'personalization_activity_type_modal_delete_error' => 'אין לנו אפשרות למצוא את סוג הפעילות.',
    'personalization_activity_type_category_modal_delete_error' => 'אין לנו אפשרות למצוא את קטגוריית סוג הפעילות הזו.',

    'personalization_life_event_category_title' => 'קטגוריות אירועי חיים',
    'personalization_live_event_category_table_name' => 'שם',
    'personalization_life_event_category_description' => 'לאירוע חיים יכול להיות סוג וקטגוריה. בחשבון שלך כבר נוצרו קטגוריות וסוגים כבררת מחדל אך ניתן לערוך את סוגי אירועי החיים להלן.',
    'personalization_live_event_category_table_actions' => 'פעולות',
    'personalization_life_event_type_add_button' => 'הוספת סוג חדש של אירוע חיים',
    'personalization_life_event_type_modal_add' => 'הוספת סוג חדש של אירוע חיים',
    'personalization_life_event_type_modal_question' => 'איך יש לקרוא לסוג אירוע החיים החדש?',
    'personalization_life_event_type_modal_edit' => 'עריכת סוג אירוע חיים',
    'personalization_life_event_type_modal_delete' => 'מחיקת סוג אירוע חיים',
    'personalization_life_event_type_modal_delete_desc' => 'למחוק סוג אירוע חיים? אירועי חיים ששייכים לסוג הזה יימחקו עם ביצוע הפעולה.',
    'personalization_life_event_type_modal_delete_error' => 'לא הצלחנו למצוא את סוג אירוע חיים זה.',

    'personalization_life_event_category_work_education' => 'עבודה והשכלה',
    'personalization_life_event_category_family_relationships' => 'משפחה ויחסים',
    'personalization_life_event_category_home_living' => 'בית ומחייה',
    'personalization_life_event_category_travel_experiences' => 'טיול וחוויות',
    'personalization_life_event_category_health_wellness' => 'בריאות ורווחה',

    'personalization_life_event_type_new_job' => 'עבודה חדשה',
    'personalization_life_event_type_retirement' => 'פרישה',
    'personalization_life_event_type_new_school' => 'בית ספר חדש',
    'personalization_life_event_type_study_abroad' => 'לימודים בחו״ל',
    'personalization_life_event_type_volunteer_work' => 'עבודה התנדבותית',
    'personalization_life_event_type_published_book_or_paper' => 'פרסום של ספר או מאמר',
    'personalization_life_event_type_military_service' => 'שירות צבאי',
    'personalization_life_event_type_first_met' => 'פגישה ראשונה',
    'personalization_life_event_type_new_relationship' => 'קשר חדש',
    'personalization_life_event_type_engagement' => 'אירוסין',
    'personalization_life_event_type_marriage' => 'נישואין',
    'personalization_life_event_type_anniversary' => 'יום השנה',
    'personalization_life_event_type_expecting_a_baby' => 'בציפייה לתינוק',
    'personalization_life_event_type_new_child' => 'ילד חדש',
    'personalization_life_event_type_new_family_member' => 'חבר חדש במשפחה',
    'personalization_life_event_type_new_pet' => 'חיית מחמד חדשה',
    'personalization_life_event_type_end_of_relationship' => 'סיום קשר',
    'personalization_life_event_type_loss_of_a_loved_one' => 'אובדן של אדם קרוב',
    'personalization_life_event_type_moved' => 'מעבר דירה',
    'personalization_life_event_type_bought_a_home' => 'רכישת דירה',
    'personalization_life_event_type_home_improvement' => 'שיפוץ הבית',
    'personalization_life_event_type_holidays' => 'חגים',
    'personalization_life_event_type_new_vehicle' => 'כלי רכב חדש',
    'personalization_life_event_type_new_roommate' => 'שותף/שותפה חדש/ה',
    'personalization_life_event_type_overcame_an_illness' => 'החלמה ממחלה',
    'personalization_life_event_type_quit_a_habit' => 'גמילה',
    'personalization_life_event_type_new_eating_habits' => 'הרגלי אכילה חדשים',
    'personalization_life_event_type_weight_loss' => 'ירידה במשקל',
    'personalization_life_event_type_wear_glass_or_contact' => 'התחלת הרכבת משקפיים או עדשות מגע',
    'personalization_life_event_type_broken_bone' => 'שבירת עצם',
    'personalization_life_event_type_removed_braces' => 'הסרת גשר בשיניים',
    'personalization_life_event_type_surgery' => 'לאחר ניתוח',
    'personalization_life_event_type_dentist' => 'לאחר טיפול שיניים',
    'personalization_life_event_type_new_sport' => 'עיסוק בספורט חדש',
    'personalization_life_event_type_new_hobby' => 'אימוץ תחביב חדש',
    'personalization_life_event_type_new_instrument' => 'התחלת למידת כלי נגינה חדש',
    'personalization_life_event_type_new_language' => 'התחלת רכישת שפה חדשה',
    'personalization_life_event_type_tattoo_or_piercing' => 'קעקוע או פירסינג',
    'personalization_life_event_type_new_license' => 'רישיון חדש',
    'personalization_life_event_type_travel' => 'טיול',
    'personalization_life_event_type_achievement_or_award' => 'הישג או פרס',
    'personalization_life_event_type_changed_beliefs' => 'שינוי אמונה',
    'personalization_life_event_type_first_word' => 'מילה ראשונה',
    'personalization_life_event_type_first_kiss' => 'נשיקה ראשונה',

    'storage_title' => 'אחסון',
    'storage_account_info' => 'מגבלת החשבון שלך היא: :accountLimit מגה בתים. הניצולת הנוכחית שלך היא: :currentAccountSize מגה בתים (בערך :percentUsage%).',
    'storage_upgrade_notice' => 'עליך לשדרג את החשבון שלך כדי שתהיה לך אפשרות להעלות מסמכים ותמונות.',
    'storage_description' => 'כאן ניתן לצפות בכל המסמכים והתמונות שהועלו לטובת אנשי הקשר שלך.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'להלן ניתן למצוא את כל ההגדרות לשימוש במשאבי WebDAV עבור נתונים מיוצאים מסוג CardDAV ו־CalDAV.',
    'dav_copy_help' => 'העתקה ללוח הגזירים שלך',
    'dav_clipboard_copied' => 'הערך הועתק ללוח הגזירים שלך',
    'dav_url_base' => 'כתובת בסיס לכל המשאבים מסוג CardDAV ו־CalDAV:',
    'dav_connect_help' => 'ניתן להתחבר לאנשי הקשר ו/או ללוחות השנה שלך עם כתובת בסיס זו מהטלפון או המחשב שלך.',
    'dav_connect_help2' => 'עליך להשתמש בשם הכניסה שלך (כתובת דוא״ל) וליצור אסימון API בתור ססמה לאימות.',
    'dav_url_carddav' => 'כתובת CardDAV למשאבי אנשי קשר:',
    'dav_url_caldav_birthdays' => 'כתובת CalDAV למשאבי ימי הולדת:',
    'dav_url_caldav_tasks' => 'כתובת CalDAV עבור משאבי משימות:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'ייצוא כל אנשי הקשר בקובץ אחד',
    'dav_caldav_birthdays_export' => 'ייצוא כל ימי ההולדת בקובץ אחד',
    'dav_caldav_tasks_export' => 'ייצוא כל המשימות בקובץ אחד',

    'archive_title' => 'העברת כל אנשי הקשר בחשבון שלך לארכיון',
    'archive_desc' => 'פעולה זו תעביר את כל אנשי הקשר בחשבון שלך לארכיון.',
    'archive_cta' => 'העברת כל אנשי הקשר לארכיון',

    'logs_title' => 'כל מה שקרה לחשבון הזה',
    'logs_actor' => 'גורם',
    'logs_timestamp' => 'חותמת זמן',
    'logs_description' => 'תיאור',
    'logs_subject' => 'נושא',
    'logs_size' => 'גודל (ק״ס)',
    'logs_object' => 'עצם',
];
