# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class DBRP(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'org_id': 'str',
        'bucket_id': 'str',
        'database': 'str',
        'retention_policy': 'str',
        'default': 'bool',
        'virtual': 'bool',
        'links': 'Links'
    }

    attribute_map = {
        'id': 'id',
        'org_id': 'orgID',
        'bucket_id': 'bucketID',
        'database': 'database',
        'retention_policy': 'retention_policy',
        'default': 'default',
        'virtual': 'virtual',
        'links': 'links'
    }

    def __init__(self, id=None, org_id=None, bucket_id=None, database=None, retention_policy=None, default=None, virtual=None, links=None):  # noqa: E501,D401,D403
        """DBRP - a model defined in OpenAPI."""  # noqa: E501
        self._id = None
        self._org_id = None
        self._bucket_id = None
        self._database = None
        self._retention_policy = None
        self._default = None
        self._virtual = None
        self._links = None
        self.discriminator = None

        self.id = id
        self.org_id = org_id
        self.bucket_id = bucket_id
        self.database = database
        self.retention_policy = retention_policy
        self.default = default
        if virtual is not None:
            self.virtual = virtual
        if links is not None:
            self.links = links

    @property
    def id(self):
        """Get the id of this DBRP.

        The resource ID that InfluxDB uses to uniquely identify the database retention policy (DBRP) mapping.

        :return: The id of this DBRP.
        :rtype: str
        """  # noqa: E501
        return self._id

    @id.setter
    def id(self, id):
        """Set the id of this DBRP.

        The resource ID that InfluxDB uses to uniquely identify the database retention policy (DBRP) mapping.

        :param id: The id of this DBRP.
        :type: str
        """  # noqa: E501
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        self._id = id

    @property
    def org_id(self):
        """Get the org_id of this DBRP.

        An organization ID. Identifies the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) that owns the mapping.

        :return: The org_id of this DBRP.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this DBRP.

        An organization ID. Identifies the [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) that owns the mapping.

        :param org_id: The org_id of this DBRP.
        :type: str
        """  # noqa: E501
        if org_id is None:
            raise ValueError("Invalid value for `org_id`, must not be `None`")  # noqa: E501
        self._org_id = org_id

    @property
    def bucket_id(self):
        """Get the bucket_id of this DBRP.

        A bucket ID. Identifies the bucket used as the target for the translation.

        :return: The bucket_id of this DBRP.
        :rtype: str
        """  # noqa: E501
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """Set the bucket_id of this DBRP.

        A bucket ID. Identifies the bucket used as the target for the translation.

        :param bucket_id: The bucket_id of this DBRP.
        :type: str
        """  # noqa: E501
        if bucket_id is None:
            raise ValueError("Invalid value for `bucket_id`, must not be `None`")  # noqa: E501
        self._bucket_id = bucket_id

    @property
    def database(self):
        """Get the database of this DBRP.

        A database name. Identifies the InfluxDB v1 database.

        :return: The database of this DBRP.
        :rtype: str
        """  # noqa: E501
        return self._database

    @database.setter
    def database(self, database):
        """Set the database of this DBRP.

        A database name. Identifies the InfluxDB v1 database.

        :param database: The database of this DBRP.
        :type: str
        """  # noqa: E501
        if database is None:
            raise ValueError("Invalid value for `database`, must not be `None`")  # noqa: E501
        self._database = database

    @property
    def retention_policy(self):
        """Get the retention_policy of this DBRP.

        A [retention policy](https://docs.influxdata.com/influxdb/v1.8/concepts/glossary/#retention-policy-rp) name. Identifies the InfluxDB v1 retention policy mapping.

        :return: The retention_policy of this DBRP.
        :rtype: str
        """  # noqa: E501
        return self._retention_policy

    @retention_policy.setter
    def retention_policy(self, retention_policy):
        """Set the retention_policy of this DBRP.

        A [retention policy](https://docs.influxdata.com/influxdb/v1.8/concepts/glossary/#retention-policy-rp) name. Identifies the InfluxDB v1 retention policy mapping.

        :param retention_policy: The retention_policy of this DBRP.
        :type: str
        """  # noqa: E501
        if retention_policy is None:
            raise ValueError("Invalid value for `retention_policy`, must not be `None`")  # noqa: E501
        self._retention_policy = retention_policy

    @property
    def default(self):
        """Get the default of this DBRP.

        If set to `true`, this DBRP mapping is the default retention policy for the database (specified by the `database` property's value).

        :return: The default of this DBRP.
        :rtype: bool
        """  # noqa: E501
        return self._default

    @default.setter
    def default(self, default):
        """Set the default of this DBRP.

        If set to `true`, this DBRP mapping is the default retention policy for the database (specified by the `database` property's value).

        :param default: The default of this DBRP.
        :type: bool
        """  # noqa: E501
        if default is None:
            raise ValueError("Invalid value for `default`, must not be `None`")  # noqa: E501
        self._default = default

    @property
    def virtual(self):
        """Get the virtual of this DBRP.

        Indicates an autogenerated, virtual mapping based on the bucket name. Currently only available in OSS.

        :return: The virtual of this DBRP.
        :rtype: bool
        """  # noqa: E501
        return self._virtual

    @virtual.setter
    def virtual(self, virtual):
        """Set the virtual of this DBRP.

        Indicates an autogenerated, virtual mapping based on the bucket name. Currently only available in OSS.

        :param virtual: The virtual of this DBRP.
        :type: bool
        """  # noqa: E501
        self._virtual = virtual

    @property
    def links(self):
        """Get the links of this DBRP.

        :return: The links of this DBRP.
        :rtype: Links
        """  # noqa: E501
        return self._links

    @links.setter
    def links(self, links):
        """Set the links of this DBRP.

        :param links: The links of this DBRP.
        :type: Links
        """  # noqa: E501
        self._links = links

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, DBRP):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
