// Generated by gmmproc 2.82.0 -- DO NOT MODIFY!
#ifndef _GTKMM_TREEEXPANDER_H
#define _GTKMM_TREEEXPANDER_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkmm/widget.h>
#include <gtkmm/treelistrow.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API TreeExpander_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** An indenting expander button for use in a tree list.
 *
 * %Gtk::TreeExpander is a widget that provides an expander for a list.
 *
 * It is typically placed as a bottommost child into a Gtk::ListView to allow
 * users to expand and collapse children in a list with a Gtk::TreeListModel.
 * It will provide the common UI elements, gestures and keybindings for this
 * purpose.
 *
 * On top of this, the "listitem.expand", "listitem.collapse" and
 * "listitem.toggle-expand" actions are provided to allow adding custom UI
 * for managing expanded state.
 *
 * The Gtk::TreeListModel must be set to not be passthrough. Then it will provide
 * Gtk::TreeListRow items which can be set via set_list_row()
 * on the expander. The expander will then watch that row item automatically.  
 * set_child() sets the widget that displays the actual row contents.
 *
 * %Gtk::TreeExpander can be modified with properties such as
 * property_indent_for_icon(), property_indent_for_depth(), and
 * property_hide_expander() to achieve a different appearance.
 * This can even be done to influence individual rows, for example by binding
 * property_hide_expander() to the item count of the model of the treelistrow,
 * to hide the expander for rows without children, even if the row is expandable.
 *
 * @see Gtk::TreeListModel
 * @ingroup ListView
 *
 * @newin{3,98}
 */

class GTKMM_API TreeExpander : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeExpander CppObjectType;
  typedef TreeExpander_Class CppClassType;
  typedef GtkTreeExpander BaseObjectType;
  typedef GtkTreeExpanderClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  TreeExpander(TreeExpander&& src) noexcept;
  TreeExpander& operator=(TreeExpander&& src) noexcept;

  // noncopyable
  TreeExpander(const TreeExpander&) = delete;
  TreeExpander& operator=(const TreeExpander&) = delete;

  ~TreeExpander() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class TreeExpander_Class;
  static CppClassType treeexpander_class_;

protected:
  explicit TreeExpander(const Glib::ConstructParams& construct_params);
  explicit TreeExpander(GtkTreeExpander* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkTreeExpander*       gobj()       { return reinterpret_cast<GtkTreeExpander*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkTreeExpander* gobj() const { return reinterpret_cast<GtkTreeExpander*>(gobject_); }

private:

        
public:
  TreeExpander();

  
  /** Gets the child widget displayed by @a self.
   * 
   * @return The child displayed by @a self.
   */
  Widget* get_child();
  
  /** Gets the child widget displayed by @a self.
   * 
   * @return The child displayed by @a self.
   */
  const Widget* get_child() const;
  
  /** Sets the content widget to display.
   * 
   * @param widget A `Gtk::Widget`.
   */
  void set_child(Widget& widget);
  /** Removes the content widget to display.
   */
  void unset_child();

 
  /** Forwards the item set on the `Gtk::TreeListRow` that @a self is managing.
   * 
   * This call is essentially equivalent to calling:
   * 
   * 
   * [C example ellipted]
   * 
   * @return The item of the row.
   */
  Glib::RefPtr<Glib::ObjectBase> get_item();
  
  /** Forwards the item set on the `Gtk::TreeListRow` that @a self is managing.
   * 
   * This call is essentially equivalent to calling:
   * 
   * 
   * [C example ellipted]
   * 
   * @return The item of the row.
   */
  Glib::RefPtr<const Glib::ObjectBase> get_item() const;

  
  /** Gets the list row managed by @a self.
   * 
   * @return The list row displayed by @a self.
   */
  Glib::RefPtr<TreeListRow> get_list_row();
  
  /** Gets the list row managed by @a self.
   * 
   * @return The list row displayed by @a self.
   */
  Glib::RefPtr<const TreeListRow> get_list_row() const;
  
  /** Sets the tree list row that this expander should manage.
   * 
   * @param list_row A `Gtk::TreeListRow`.
   */
  void set_list_row(const Glib::RefPtr<TreeListRow>& list_row);
  /** Removes the tree list row that this expander should manage.
   */
  void unset_list_row();

  
  /** TreeExpander indents each level of depth with an additional indent.
   * 
   * @newin{4,10}
   * 
   * @return <tt>true</tt> if the child should be indented . Otherwise <tt>false</tt>.
   */
  bool get_indent_for_depth() const;
  
  /** Sets if the TreeExpander should indent the child according to its depth.
   * 
   * @newin{4,10}
   * 
   * @param indent_for_depth <tt>true</tt> if the child should be indented. Otherwise <tt>false</tt>.
   */
  void set_indent_for_depth(bool indent_for_depth =  true);
  
  /** TreeExpander indents the child by the width of an expander-icon if it is not expandable.
   * 
   * @newin{4,6}
   * 
   * @return <tt>true</tt> if the child should be indented when not expandable. Otherwise <tt>false</tt>.
   */
  bool get_indent_for_icon() const;
  
  /** Sets if the TreeExpander should indent the child by the width of an expander-icon when it is not expandable.
   * 
   * @newin{4,6}
   * 
   * @param indent_for_icon <tt>true</tt> if the child should be indented without expander. Otherwise <tt>false</tt>.
   */
  void set_indent_for_icon(bool indent_for_icon =  true);
  
  /** Gets whether the TreeExpander should be hidden in a GtkTreeListRow.
   * 
   * @newin{4,10}
   * 
   * @return <tt>true</tt> if the expander icon should be hidden. Otherwise <tt>false</tt>.
   */
  bool get_hide_expander() const;
  
  /** Sets whether the expander icon should be visible in a GtkTreeListRow.
   * 
   * @newin{4,10}
   * 
   * @param hide_expander <tt>true</tt> if the expander should be hidden. Otherwise <tt>false</tt>.
   */
  void set_hide_expander(bool hide_expander =  true);

  /** The child widget with the actual contents.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_child() ;

/** The child widget with the actual contents.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_child() const;

  /** Whether the expander icon should be hidden in a GtkTreeListRow.
   * Note that this property simply hides the icon.  The actions and keybinding
   * (i.e. collapse and expand) are not affected by this property.
   * 
   * A common use for this property would be to bind to the number of children in a
   * GtkTreeListRow's model in order to hide the expander when a row has no children.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hide_expander() ;

/** Whether the expander icon should be hidden in a GtkTreeListRow.
   * Note that this property simply hides the icon.  The actions and keybinding
   * (i.e. collapse and expand) are not affected by this property.
   * 
   * A common use for this property would be to bind to the number of children in a
   * GtkTreeListRow's model in order to hide the expander when a row has no children.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hide_expander() const;

  /** TreeExpander indents the child according to its depth.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_indent_for_depth() ;

/** TreeExpander indents the child according to its depth.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_indent_for_depth() const;

  /** TreeExpander indents the child by the width of an expander-icon if it is not expandable.
   * 
   * @newin{4,6}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_indent_for_icon() ;

/** TreeExpander indents the child by the width of an expander-icon if it is not expandable.
   * 
   * @newin{4,6}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_indent_for_icon() const;

  /** The item held by this expander's row.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::ObjectBase> > property_item() const;


  /** The list row to track for expander state.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<TreeListRow> > property_list_row() ;

/** The list row to track for expander state.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TreeListRow> > property_list_row() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TreeExpander
   */
  GTKMM_API
  Gtk::TreeExpander* wrap(GtkTreeExpander* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TREEEXPANDER_H */

