/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseException;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.AbstractHttpErrorHandler;
import java.io.IOException;

public abstract class AbstractPlatformErrorHandler<T extends FirebaseException>
extends AbstractHttpErrorHandler<T> {
    protected final JsonFactory jsonFactory;

    public AbstractPlatformErrorHandler(JsonFactory jsonFactory) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory, (Object)"jsonFactory must not be null");
    }

    @Override
    protected final FirebaseException httpResponseErrorToBaseException(HttpResponseException e, IncomingHttpResponse response) {
        String message;
        FirebaseException base = super.httpResponseErrorToBaseException(e, response);
        PlatformErrorResponse parsedError = this.parseErrorResponse(e.getContent());
        ErrorCode code = base.getErrorCode();
        String status = parsedError.getStatus();
        if (!Strings.isNullOrEmpty((String)status)) {
            code = Enum.valueOf(ErrorCode.class, parsedError.getStatus());
        }
        if (Strings.isNullOrEmpty((String)(message = parsedError.getMessage()))) {
            message = base.getMessage();
        }
        return new FirebaseException(code, message, e, response);
    }

    private PlatformErrorResponse parseErrorResponse(String content) {
        PlatformErrorResponse response = new PlatformErrorResponse();
        if (!Strings.isNullOrEmpty((String)content)) {
            try {
                this.jsonFactory.createJsonParser(content).parseAndClose((Object)response);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return response;
    }

    public static class PlatformError {
        @Key(value="status")
        private String status;
        @Key(value="message")
        private String message;
    }

    public static class PlatformErrorResponse {
        @Key(value="error")
        private PlatformError error;

        String getStatus() {
            return this.error != null ? this.error.status : null;
        }

        String getMessage() {
            return this.error != null ? this.error.message : null;
        }
    }
}

