/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HelloMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHelloParser
extends HelloMessageParser<ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerHelloParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.SERVER_HELLO, version, config);
    }

    protected void parseSelectedCiphersuite(ServerHelloMessage msg) {
        msg.setSelectedCipherSuite(this.parseByteArrayField(2));
    }

    protected void parseSelectedComressionMethod(ServerHelloMessage msg) {
        msg.setSelectedCompressionMethod(this.parseByteField(1));
    }

    @Override
    protected void parseHandshakeMessageContent(ServerHelloMessage msg) {
        LOGGER.debug("Parsing ServerHelloMessage");
        this.parseProtocolVersion(msg);
        ProtocolVersion version = ProtocolVersion.getProtocolVersion((byte[])msg.getProtocolVersion().getValue());
        if (version != null) {
            this.setVersion(version);
        }
        this.parseRandom(msg);
        this.parseSessionIDLength(msg);
        this.parseSessionID(msg);
        this.parseSelectedCiphersuite(msg);
        this.parseSelectedComressionMethod(msg);
        LOGGER.trace("Checking for ExtensionLength Field");
        if (this.hasExtensionLengthField(msg)) {
            LOGGER.trace("Parsing ExtensionLength field");
            this.parseExtensionLength(msg);
            this.parseExtensionBytes(msg);
        }
    }

    @Override
    protected ServerHelloMessage createHandshakeMessage() {
        return new ServerHelloMessage();
    }
}

