/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.https;

import de.rub.nds.tlsattacker.core.https.HttpsResponseMessage;
import de.rub.nds.tlsattacker.core.https.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.https.header.HttpsHeader;
import de.rub.nds.tlsattacker.core.protocol.preparator.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;

public class HttpsResponsePreparator
extends ProtocolMessagePreparator<HttpsResponseMessage> {
    private final HttpsResponseMessage message;

    public HttpsResponsePreparator(Chooser chooser, HttpsResponseMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        this.message.setResponseProtocol("HTTP/1.1");
        this.message.setResponseStatusCode("200 OK");
        this.message.setResponseContent(this.chooser.getConfig().getDefaultApplicationMessageData());
        for (HttpsHeader header : this.message.getHeader()) {
            if (header instanceof ContentLengthHeader) {
                ((ContentLengthHeader)header).setConfigLength(((String)this.message.getResponseContent().getValue()).getBytes().length);
            }
            header.getPreparator(this.chooser).prepare();
        }
    }
}

