/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.DocStringReferenceProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.EpydocString;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public final class DocStringAnnotator
extends PyAnnotator {
    @Override
    public void visitPyFile(@NotNull PyFile node) {
        if (node == null) {
            DocStringAnnotator.$$$reportNull$$$0(0);
        }
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node));
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        if (node == null) {
            DocStringAnnotator.$$$reportNull$$$0(1);
        }
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyClass(@NotNull PyClass node) {
        if (node == null) {
            DocStringAnnotator.$$$reportNull$$$0(2);
        }
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        PyExpression right;
        if (node == null) {
            DocStringAnnotator.$$$reportNull$$$0(3);
        }
        if (node.isAssignmentTo("__doc__") && (right = node.getAssignedValue()) instanceof PyStringLiteralExpression) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)right).textAttributes(PyHighlighter.PY_DOC_COMMENT).create();
            this.annotateDocStringStmt((PyStringLiteralExpression)right);
        }
    }

    @Override
    public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
        if (node == null) {
            DocStringAnnotator.$$$reportNull$$$0(4);
        }
        if (node.getExpression() instanceof PyStringLiteralExpression && DocStringUtil.isVariableDocString((PyStringLiteralExpression)node.getExpression())) {
            this.annotateDocStringStmt((PyStringLiteralExpression)node.getExpression());
        }
    }

    private void annotateDocStringStmt(PyStringLiteralExpression stmt) {
        if (stmt != null) {
            TextRange textRange;
            String[] tags;
            DocStringFormat format = DocStringParser.getConfiguredDocStringFormat((PsiElement)stmt);
            if (format == DocStringFormat.EPYTEXT) {
                tags = EpydocString.ALL_TAGS;
            } else if (format == DocStringFormat.REST) {
                tags = SphinxDocString.ALL_TAGS;
            } else {
                return;
            }
            int pos = 0;
            while ((textRange = DocStringReferenceProvider.findNextTag(stmt.getText(), pos, tags)) != null) {
                this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range(textRange.shiftRight(stmt.getTextRange().getStartOffset())).textAttributes(PyHighlighter.PY_DOC_COMMENT_TAG).create();
                pos = textRange.getEndOffset();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "node";
        objectArray2[1] = "com/jetbrains/python/validation/DocStringAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyAssignmentStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyExpressionStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

