/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.FileASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiFile
extends PsiFileSystemItem {
    public static final PsiFile[] EMPTY_ARRAY = new PsiFile[0];

    @Override
    public VirtualFile getVirtualFile();

    public PsiDirectory getContainingDirectory();

    @Override
    public PsiDirectory getParent();

    public long getModificationStamp();

    @NotNull
    public PsiFile getOriginalFile();

    @NotNull
    public FileType getFileType();

    @Deprecated
    public PsiFile @NotNull [] getPsiRoots();

    @NotNull
    public FileViewProvider getViewProvider();

    @ApiStatus.NonExtendable
    @NotNull
    default public Document getFileDocument() {
        Document document = this.getViewProvider().getDocument();
        if (document == null) {
            throw new UnsupportedOperationException("No document is available for file " + this.getClass());
        }
        Document document2 = document;
        if (document2 == null) {
            PsiFile.$$$reportNull$$$0(0);
        }
        return document2;
    }

    @Override
    public FileASTNode getNode();

    public void subtreeChanged();

    default public void clearCaches() {
    }

    @Nullable
    default public IFileElementType getFileElementType() {
        return ObjectUtils.tryCast(PsiUtilCore.getElementType(this.getNode()), IFileElementType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiFile", "getFileDocument"));
    }
}

