/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListEnterHandlerDelegate$postProcessEnter$;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemUnindentHandler;
import org.intellij.plugins.markdown.editor.lists.MarkdownListMarkerBackspaceHandlerDelegate;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListNumber;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016JF\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J2\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "emptyItem", "", "codeInsightSettings", "Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings$State;", "getCodeInsightSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings$State;", "invokeInsideIndent", "", "newLineCharOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isInCodeFence", "handleEmptyItem", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "postProcessEnter", "Companion", "intellij.markdown"})
@ExperimentalStdlibApi
@SourceDebugExtension(value={"SMAP\nMarkdownListEnterHandlerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListEnterHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,184:1\n66#2,2:185\n67#2:187\n67#2:188\n477#3:189\n*S KotlinDebug\n*F\n+ 1 MarkdownListEnterHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate\n*L\n94#1:185,2\n117#1:187\n125#1:188\n160#1:189\n*E\n"})
public final class MarkdownListEnterHandlerDelegate
implements EnterHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String emptyItem;

    private final MarkdownCodeInsightSettings.State getCodeInsightSettings() {
        return (MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState();
    }

    public boolean invokeInsideIndent(int newLineCharOffset, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!this.getCodeInsightSettings().getSmartEnterAndBackspace()) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        return file instanceof MarkdownFile;
    }

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        String string;
        MarkdownBlockQuote blockQuote;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
                Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                this.emptyItem = null;
                if (!this.getCodeInsightSettings().getSmartEnterAndBackspace()) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                if (!(file instanceof MarkdownFile)) break block14;
                Object object = caretOffset.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                if (!this.isInCodeFence(((Number)object).intValue(), file)) break block15;
            }
            return EnterHandlerDelegate.Result.Continue;
        }
        if (Intrinsics.areEqual((Object)DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY), (Object)true)) {
            editor2.putUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY, (Object)true);
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(document2);
        Object object = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int line = document2.getLineNumber(((Number)object).intValue());
        if (line > 0) {
            boolean prevLineBlank;
            TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document2, line);
            boolean insideIndent = !indentRange.isEmpty() && ((Number)caretOffset.get()).intValue() <= indentRange.getEndOffset();
            boolean bl = prevLineBlank = ListUtils.INSTANCE.getLineIndentRange(document2, line - 1).getEndOffset() == document2.getLineEndOffset(line - 1);
            if (insideIndent && prevLineBlank) {
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        MarkdownFile markdownFile = (MarkdownFile)file;
        Object object2 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAt(markdownFile, ((Number)object2).intValue(), document2);
        if (markdownListItem == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        MarkdownListItem item = markdownListItem;
        PsiElement[] psiElementArray = item.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        if (((Object[])psiElementArray).length == 0) {
            this.handleEmptyItem(item, editor2, file, originalHandler, dataContext);
            caretOffset.set((Object)editor2.getCaretModel().getOffset());
            return EnterHandlerDelegate.Result.Stop;
        }
        Object object3 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        PsiElement psiElement = MarkdownPsiUtil.INSTANCE.findNonWhiteSpacePrevSibling(file, ((Number)object3).intValue());
        if (psiElement != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            v10 = (MarkdownBlockQuote)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownBlockQuote.class, (boolean)true);
        } else {
            v10 = blockQuote = null;
        }
        if (blockQuote != null && PsiTreeUtilKt.isAncestor$default((PsiElement)((PsiElement)item), (PsiElement)((PsiElement)blockQuote), (boolean)false, (int)2, null)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int itemLine = document2.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)item)));
        PsiElement psiElement2 = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement markerElement = psiElement2;
        TextRange textRange = ListUtils.INSTANCE.getLineIndentRange(document2, itemLine).union(markerElement.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"union(...)");
        TextRange indentWithMakerRange = textRange;
        Object object4 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        if (indentWithMakerRange.contains(((Number)object4).intValue())) {
            caretOffset.set((Object)PsiTreeUtilKt.getEndOffset((PsiElement)markerElement));
        }
        if ((string = ListUtils.INSTANCE.getLineIndentSpaces(document2, itemLine, file)) == null) {
            string = "";
        }
        String indentSpaces = string;
        this.emptyItem = indentSpaces + ListUtils.INSTANCE.getNormalizedMarker(item);
        return EnterHandlerDelegate.Result.Default;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInCodeFence(int caretOffset, PsiFile file) {
        void $this$parentOfType$iv;
        PsiElement element2;
        if (caretOffset == 0) {
            return false;
        }
        PsiElement psiElement = file.findElementAt(caretOffset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = element2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        MarkdownCodeFence fence = (MarkdownCodeFence)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownCodeFence.class, (boolean)false);
        return fence != null;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleEmptyItem(MarkdownListItem item, Editor editor2, PsiFile file, EditorActionHandler originalHandler, DataContext dataContext) {
        void $this$parentOfType$iv;
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement markerElement = psiElement;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiElement psiElement2 = (PsiElement)item;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItem.class, (boolean)true) == null) {
            MarkdownListMarkerBackspaceHandlerDelegate backspaceHandler = new MarkdownListMarkerBackspaceHandlerDelegate();
            int markerEnd = PsiTreeUtilKt.getEndOffset((PsiElement)markerElement);
            editor2.getCaretModel().moveToOffset(markerEnd);
            char c = editor2.getDocument().getCharsSequence().charAt(markerEnd - 1);
            backspaceHandler.beforeCharDeleted(c, file, editor2);
            ActionsKt.runWriteAction(() -> MarkdownListEnterHandlerDelegate.handleEmptyItem$lambda$0(document2, markerEnd));
            backspaceHandler.charDeleted(c, file, editor2);
        } else {
            MarkdownListItemUnindentHandler unindentHandler = new MarkdownListItemUnindentHandler(originalHandler);
            unindentHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
        }
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (Intrinsics.areEqual((Object)editor2.getUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY), (Object)true)) {
            editor2.putUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY, null);
            return EnterHandlerDelegate.Result.Continue;
        }
        String string = this.emptyItem;
        if (string == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        String emptyItem = string;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)emptyItem);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAt((MarkdownFile)file, editor2.getCaretModel().getOffset(), document2);
        Intrinsics.checkNotNull((Object)markdownListItem);
        MarkdownListItem item = markdownListItem;
        MarkdownCodeInsightSettings.ListNumberingType listNumberingType = this.getCodeInsightSettings().getListNumberingType();
        if (this.getCodeInsightSettings().getRenumberListsOnType() && listNumberingType != MarkdownCodeInsightSettings.ListNumberingType.PREVIOUS_NUMBER) {
            ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, ListUtils.INSTANCE.getList(item), document2, false, false, false, listNumberingType == MarkdownCodeInsightSettings.ListNumberingType.SEQUENTIAL, 8, null);
        } else {
            Integer previousNumber;
            MarkdownListItem previousItem;
            Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)item), (boolean)false, (boolean)false);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)postProcessEnter$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownListItem markdownListItem2 = previousItem = (MarkdownListItem)SequencesKt.firstOrNull((Sequence)sequence);
            Integer n = previousNumber = markdownListItem2 != null ? ListRenumberUtils.INSTANCE.obtainMarkerNumber(markdownListItem2) : null;
            if (previousNumber != null) {
                PsiElement psiElement = item.getMarkerElement();
                MarkdownListNumber marker = psiElement instanceof MarkdownListNumber ? (MarkdownListNumber)psiElement : null;
                int currentNumber = switch (WhenMappings.$EnumSwitchMapping$0[listNumberingType.ordinal()]) {
                    case 1 -> previousNumber + 1;
                    case 2 -> 1;
                    case 3 -> previousNumber;
                    default -> throw new NoWhenBranchMatchedException();
                };
                MarkdownListNumber markdownListNumber = marker;
                if (markdownListNumber != null) {
                    MarkdownListEnterHandlerDelegate.Companion.replaceWithOtherNumber(markdownListNumber, currentNumber);
                }
            }
        }
        this.emptyItem = null;
        return EnterHandlerDelegate.Result.Stop;
    }

    private static final Unit handleEmptyItem$lambda$0(Document $document, int $markerEnd) {
        $document.deleteString($markerEnd - 1, $markerEnd);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate$Companion;", "", "<init>", "()V", "replaceWithOtherNumber", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListNumber;", "number", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final MarkdownListNumber replaceWithOtherNumber(MarkdownListNumber $this$replaceWithOtherNumber, int number) {
            LeafElement leafElement = $this$replaceWithOtherNumber.replaceWithText("" + number + $this$replaceWithOtherNumber.getDelimiter() + " ");
            Intrinsics.checkNotNull((Object)leafElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownListNumber");
            return (MarkdownListNumber)leafElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MarkdownCodeInsightSettings.ListNumberingType.values().length];
            try {
                nArray[MarkdownCodeInsightSettings.ListNumberingType.SEQUENTIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkdownCodeInsightSettings.ListNumberingType.ONES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkdownCodeInsightSettings.ListNumberingType.PREVIOUS_NUMBER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

