/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.shortcut;

import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.shortcut.InlineCompletionShortcutChangeListener;
import com.intellij.codeInsight.inline.completion.shortcut.InlineCompletionShortcutHint;
import com.intellij.codeInsight.inline.completion.shortcut.InlineCompletionShortcutHintRendererBase;
import com.intellij.codeInsight.inline.completion.shortcut.InlineCompletionShortcutHintState;
import com.intellij.codeInsight.inline.hint.InlineShortcutHintRendererBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement;", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "lineNumber", "", "isMultiline", "", "<init>", "(IZ)V", "getLineNumber", "()I", "()Z", "text", "", "getText", "()Ljava/lang/String;", "hint", "Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHint;", "toPresentable", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement$Presentable;", "Presentable", "intellij.platform.inline.completion"})
@ApiStatus.Internal
public final class InlineCompletionShortcutHintElement
implements InlineCompletionElement {
    private final int lineNumber;
    private final boolean isMultiline;
    @NotNull
    private final String text;
    @NotNull
    private final InlineCompletionShortcutHint hint;

    public InlineCompletionShortcutHintElement(int lineNumber, boolean isMultiline) {
        this.lineNumber = lineNumber;
        this.isMultiline = isMultiline;
        this.text = "";
        this.hint = InlineCompletionShortcutHint.Companion.random(this.isMultiline);
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final boolean isMultiline() {
        return this.isMultiline;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public InlineCompletionElement.Presentable toPresentable() {
        return new Presentable(this, this.hint);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\fH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0012H\u0002J\f\u0010$\u001a\u00020\u0012*\u00020%H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement$Presentable;", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement$Presentable;", "element", "Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement;", "hint", "Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHint;", "<init>", "(Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement;Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHint;)V", "getElement", "()Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement;", "shortcutInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintRendererBase;", "suffixInlay", "offset", "", "Ljava/lang/Integer;", "currentShortcut", "", "isVisible", "", "getBounds", "Ljava/awt/Rectangle;", "startOffset", "()Ljava/lang/Integer;", "endOffset", "dispose", "", "render", "editor", "Lcom/intellij/openapi/editor/Editor;", "getSuffixRenderer", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getShortcutRenderer", "rerender", "getShortcutRepresentation", "asString", "Lcom/intellij/openapi/actionSystem/Shortcut;", "hintShouldRender", "Companion", "intellij.platform.inline.completion"})
    @SourceDebugExtension(value={"SMAP\nInlineCompletionShortcutHintElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionShortcutHintElement.kt\ncom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement$Presentable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,187:1\n1#2:188\n24#3:189\n*S KotlinDebug\n*F\n+ 1 InlineCompletionShortcutHintElement.kt\ncom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement$Presentable\n*L\n138#1:189\n*E\n"})
    public static final class Presentable
    implements InlineCompletionElement.Presentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final InlineCompletionShortcutHintElement element;
        @NotNull
        private final InlineCompletionShortcutHint hint;
        @Nullable
        private Inlay<InlineCompletionShortcutHintRendererBase> shortcutInlay;
        @Nullable
        private Inlay<InlineCompletionShortcutHintRendererBase> suffixInlay;
        @Nullable
        private Integer offset;
        @Nullable
        private String currentShortcut;
        @NotNull
        private static final Logger LOG;

        public Presentable(@NotNull InlineCompletionShortcutHintElement element, @NotNull InlineCompletionShortcutHint hint) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)hint), (String)"hint");
            this.element = element;
            this.hint = hint;
            this.currentShortcut = this.getShortcutRepresentation();
            InlineCompletionShortcutChangeListener.Companion.whenInsertShortcutChanged((Disposable)this, (Function0<Unit>)((Function0)() -> Presentable._init_$lambda$0(this)));
        }

        @NotNull
        public InlineCompletionShortcutHintElement getElement() {
            return this.element;
        }

        public boolean isVisible() {
            return this.getBounds() != null;
        }

        @Nullable
        public Rectangle getBounds() {
            if (!this.hintShouldRender()) {
                return null;
            }
            Object object = this.shortcutInlay;
            if (object == null || (object = object.getBounds()) == null) {
                return null;
            }
            Object shortcutBounds = object;
            Object object2 = this.suffixInlay;
            if (object2 == null || (object2 = object2.getBounds()) == null) {
                return null;
            }
            Object suffixBounds = object2;
            return ((Rectangle)shortcutBounds).union((Rectangle)suffixBounds);
        }

        @Nullable
        public Integer startOffset() {
            return this.offset;
        }

        @Nullable
        public Integer endOffset() {
            return this.offset;
        }

        public void dispose() {
            Disposable p0;
            Inlay<InlineCompletionShortcutHintRendererBase> inlay = this.shortcutInlay;
            if (inlay != null) {
                p0 = (Disposable)inlay;
                boolean $i$f$dispose$stub_for_inlining = false;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            Inlay<InlineCompletionShortcutHintRendererBase> inlay2 = this.suffixInlay;
            if (inlay2 != null) {
                p0 = (Disposable)inlay2;
                boolean $i$f$dispose$stub_for_inlining$1 = false;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            this.shortcutInlay = null;
            this.suffixInlay = null;
            this.offset = null;
        }

        public void render(@NotNull Editor editor, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!(editor instanceof EditorImpl) || this.currentShortcut == null || !InlineShortcutHintRendererBase.Companion.isAvailableForLine(editor, this.getElement().getLineNumber())) {
                return;
            }
            try {
                int caretOffset = ((EditorImpl)editor).getCaretModel().getOffset();
                this.shortcutInlay = ((EditorImpl)editor).getInlayModel().addAfterLineEndElement(caretOffset, true, (EditorCustomElementRenderer)this.getShortcutRenderer());
                this.suffixInlay = ((EditorImpl)editor).getInlayModel().addAfterLineEndElement(caretOffset, true, (EditorCustomElementRenderer)this.getSuffixRenderer((EditorImpl)editor));
                this.offset = offset;
            }
            catch (Exception e) {
                LOG.error("Could not render Full Line in-editor hint.", (Throwable)e);
            }
        }

        private final InlineCompletionShortcutHintRendererBase getSuffixRenderer(EditorImpl editor) {
            String string = this.hint.getSuffixText();
            return new InlineCompletionShortcutHintRendererBase(this, editor, string){
                final /* synthetic */ Presentable this$0;
                final /* synthetic */ EditorImpl $editor;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    super($super_call_param$1);
                }

                protected boolean isEnabledAdditional(Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    return Presentable.access$hintShouldRender(this.this$0);
                }

                protected void paintIfEnabled(Inlay<?> inlay, Graphics g, Rectangle r, TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    InlineShortcutHintRendererBase.paintLabel$default((InlineShortcutHintRendererBase)this, (Graphics)g, (EditorImpl)this.$editor, (Rectangle)r, (String)this.getText(), (TextAttributes)this.clearEffects(textAttributes), null, (int)32, null);
                }
            };
        }

        private final InlineCompletionShortcutHintRendererBase getShortcutRenderer() {
            String string = this.currentShortcut;
            return new InlineCompletionShortcutHintRendererBase(this, string){
                final /* synthetic */ Presentable this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected boolean isEnabledAdditional(Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    return Presentable.access$hintShouldRender(this.this$0);
                }

                protected void paintIfEnabled(Inlay<?> inlay, Graphics g, Rectangle r, TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    this.paintHint(inlay, g, r, this.clearEffects(textAttributes));
                }
            };
        }

        private final void rerender() {
            block2: {
                this.currentShortcut = this.getShortcutRepresentation();
                Object object = this.shortcutInlay;
                if (object != null && (object = (InlineCompletionShortcutHintRendererBase)object.getRenderer()) != null) {
                    object.setText(this.currentShortcut);
                }
                Inlay<InlineCompletionShortcutHintRendererBase> inlay = this.shortcutInlay;
                if (inlay != null) {
                    inlay.update();
                }
                Inlay<InlineCompletionShortcutHintRendererBase> inlay2 = this.suffixInlay;
                if (inlay2 == null) break block2;
                inlay2.update();
            }
        }

        private final String getShortcutRepresentation() {
            Shortcut shortcut;
            Shortcut shortcut2 = shortcut = KeymapUtil.getPrimaryShortcut((String)this.hint.getActionId());
            return shortcut2 != null ? this.asString(shortcut2) : null;
        }

        private final String asString(Shortcut $this$asString) {
            String string;
            switch ($this$asString.toString()) {
                case "[pressed TAB]": {
                    string = "Tab";
                    break;
                }
                case "[pressed ENTER]": {
                    string = "Enter";
                    break;
                }
                case "[shift pressed RIGHT]": {
                    string = "Shift \u2192";
                    break;
                }
                default: {
                    String string2 = KeymapUtil.getShortcutText((Shortcut)$this$asString);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutText(...)");
                }
            }
            return string;
        }

        private final boolean hintShouldRender() {
            return this.currentShortcut != null && InlineCompletionShortcutHintState.Companion.getState() == InlineCompletionShortcutHintState.SHOW_HINT;
        }

        private static final Unit _init_$lambda$0(Presentable this$0) {
            this$0.rerender();
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ boolean access$hintShouldRender(Presentable $this) {
            return $this.hintShouldRender();
        }

        static {
            Companion $this$thisLogger$iv = Companion = new Companion(null);
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintElement$Presentable$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.inline.completion"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

