/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.search;

import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolReference;", "Lcom/intellij/psi/PsiReference;", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "host", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/webSymbols/WebSymbol;Lcom/intellij/psi/PsiElement;Lcom/intellij/model/psi/PsiExternalReferenceHost;Lcom/intellij/openapi/util/TextRange;)V", "newName", "Lcom/intellij/openapi/util/Ref;", "", "getNewName$intellij_platform_webSymbols", "()Lcom/intellij/openapi/util/Ref;", "createRenameHandler", "Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolReference$RenameHandler;", "getElement", "getRangeInElement", "resolve", "getCanonicalText", "handleElementRename", "newElementName", "bindToElement", "element", "isReferenceTo", "", "isSoft", "RenameHandler", "intellij.platform.webSymbols"})
@ApiStatus.Internal
public final class PsiSourcedWebSymbolReference
implements PsiReference {
    @NotNull
    private final WebSymbol symbol;
    @NotNull
    private final PsiElement sourceElement;
    @NotNull
    private final PsiExternalReferenceHost host;
    @NotNull
    private final TextRange range;
    @NotNull
    private final Ref<String> newName;

    public PsiSourcedWebSymbolReference(@NotNull WebSymbol symbol, @NotNull PsiElement sourceElement, @NotNull PsiExternalReferenceHost host, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.symbol = symbol;
        this.sourceElement = sourceElement;
        this.host = host;
        this.range = range;
        this.newName = new Ref();
    }

    @NotNull
    public final Ref<String> getNewName$intellij_platform_webSymbols() {
        return this.newName;
    }

    @NotNull
    public final RenameHandler createRenameHandler() {
        return new RenameHandler(this);
    }

    @NotNull
    public PsiElement getElement() {
        return (PsiElement)this.host;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.range;
    }

    @NotNull
    public PsiElement resolve() {
        return this.sourceElement;
    }

    @NotNull
    public String getCanonicalText() {
        PsiElement psiElement = this.sourceElement;
        Object object = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        if (object == null || (object = object.getName()) == null) {
            String string = this.range.substring(this.host.getText());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        }
        return object;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        this.newName.set((Object)newElementName);
        return (PsiElement)this.host;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.isEquivalentTo(this.sourceElement) || this.sourceElement.isEquivalentTo(element);
    }

    public boolean isSoft() {
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolReference$RenameHandler;", "", "reference", "Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolReference;", "<init>", "(Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolReference;)V", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "targetPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "rangePointer", "Lcom/intellij/psi/SmartPsiFileRange;", "Lorg/jetbrains/annotations/NotNull;", "nameRef", "Lcom/intellij/openapi/util/Ref;", "", "handleRename", "Lcom/intellij/refactoring/util/NonCodeUsageInfo;", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nPsiSourcedWebSymbolReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiSourcedWebSymbolReference.kt\ncom/intellij/webSymbols/search/PsiSourcedWebSymbolReference$RenameHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
    public static final class RenameHandler {
        @NotNull
        private final WebSymbol symbol;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> targetPointer;
        @NotNull
        private final SmartPsiFileRange rangePointer;
        @NotNull
        private final Ref<String> nameRef;

        /*
         * WARNING - void declaration
         */
        public RenameHandler(@NotNull PsiSourcedWebSymbolReference reference) {
            PsiElement psiElement;
            void it;
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            this.symbol = reference.symbol;
            PsiElement psiElement2 = reference.resolve();
            RenameHandler renameHandler = this;
            boolean bl = false;
            if (it instanceof FakePsiElement) {
                psiElement = ((FakePsiElement)it).getContext();
                if (psiElement == null) {
                    psiElement = it;
                }
            } else {
                psiElement = psiElement2;
            }
            renameHandler.targetPointer = SmartPointersKt.createSmartPointer((PsiElement)psiElement);
            SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)reference.getElement().getProject()).createSmartPsiFileRangePointer(reference.getElement().getContainingFile(), reference.getRangeInElement().shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)reference.getElement())));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
            this.rangePointer = smartPsiFileRange;
            this.nameRef = reference.getNewName$intellij_platform_webSymbols();
        }

        @Nullable
        public final NonCodeUsageInfo handleRename() {
            Segment segment = this.rangePointer.getPsiRange();
            if (segment == null) {
                return null;
            }
            Segment range = segment;
            PsiFile psiFile = (PsiFile)this.rangePointer.getElement();
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            String string = (String)this.nameRef.get();
            if (string == null) {
                return null;
            }
            String newName = string;
            PsiElement psiElement = this.targetPointer.dereference();
            if (psiElement == null) {
                return null;
            }
            PsiElement target = psiElement;
            int n = range.getStartOffset();
            int n2 = range.getEndOffset();
            WebSymbolsQueryExecutor webSymbolsQueryExecutor = WebSymbolsQueryExecutorFactory.Companion.create$default(WebSymbolsQueryExecutorFactory.Companion, (PsiElement)file, false, 2, null);
            String string2 = file.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n3 = range.getStartOffset();
            int n4 = range.getEndOffset();
            String string4 = string3.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            return NonCodeUsageInfo.create((PsiFile)file, (int)n, (int)n2, (PsiElement)target, (String)this.symbol.adjustNameForRefactoring(webSymbolsQueryExecutor, newName, string4));
        }
    }
}

