/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectFloatAssociativeContainer;
import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.ObjectFloatMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.comparators.ObjectFloatComparator;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.ObjectFloatPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.ObjectFloatProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationObjectFloatHashMap<KType>
implements ObjectFloatMap<KType> {
    public final ObjectFloatHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectFloatHashMap(ObjectFloatHashMap<KType> delegate2, Comparator<KType> comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectFloatHashMap(ObjectFloatHashMap<KType> delegate2, ObjectFloatComparator<KType> comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectFloatComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final float[] values;
            {
                this.keys = SortedIterationObjectFloatHashMap.this.delegate.keys;
                this.values = SortedIterationObjectFloatHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectFloatCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectFloatPredicate<? super KType> predicate) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectFloatProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectFloatPredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public float get(KType key2) {
        return this.delegate.get(key2);
    }

    @Override
    public float getOrDefault(KType key2, float defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public float put(KType key2, float value) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectFloatAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectFloatCursor<? extends KType>> iterable) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public float putOrAdd(KType key2, float putValue, float incrementValue) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public float addTo(KType key2, float additionValue) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public float remove(KType key2) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public float indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public float indexReplace(int index, float newValue) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key2, float value) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public float indexRemove(int index) {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectFloatHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectFloatCursor<KType>> {
        private final ObjectFloatCursor<KType> cursor = new ObjectFloatCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectFloatCursor<KType> fetch() {
            if (this.index < SortedIterationObjectFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectFloatHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectFloatCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectFloatHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectFloatHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final SortedIterationObjectFloatHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (ObjectFloatCursor c : this.owner) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected FloatCursor fetch() {
            if (this.index < SortedIterationObjectFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectFloatHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

