/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.google.common.primitives.Ints;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcs.log.graph.AbstractGraphCommit;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.IntGraphCommit;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class GraphCommitImpl<CommitId>
extends AbstractGraphCommit<CommitId> {
    @NotNull
    private final CommitId myId;
    @NotNull
    private final Object myParents;

    private GraphCommitImpl(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        if (id == null) {
            GraphCommitImpl.$$$reportNull$$$0(0);
        }
        if (parents == null) {
            GraphCommitImpl.$$$reportNull$$$0(1);
        }
        super(timestamp);
        this.myId = id;
        if (parents.isEmpty()) {
            this.myParents = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        } else if (parents.size() == 1) {
            this.myParents = parents.get(0);
            assert (!(this.myParents instanceof Object[]));
        } else {
            this.myParents = parents.toArray();
        }
    }

    @NotNull
    public CommitId getId() {
        CommitId CommitId = this.myId;
        if (CommitId == null) {
            GraphCommitImpl.$$$reportNull$$$0(2);
        }
        return CommitId;
    }

    public CommitId get(int index) {
        Object object = this.myParents;
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (index < 0 || index >= array.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return (CommitId)array[index];
        }
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (CommitId)this.myParents;
    }

    public int size() {
        return this.myParents instanceof Object[] ? ((Object[])this.myParents).length : 1;
    }

    @NotNull
    public static <CommitId> GraphCommit<CommitId> createCommit(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        if (id == null) {
            GraphCommitImpl.$$$reportNull$$$0(3);
        }
        if (parents == null) {
            GraphCommitImpl.$$$reportNull$$$0(4);
        }
        if (id instanceof Integer) {
            return GraphCommitImpl.createIntCommit((Integer)id, parents, timestamp);
        }
        return new GraphCommitImpl<Integer>((Integer)id, parents, timestamp);
    }

    @NotNull
    public static GraphCommit<Integer> createIntCommit(int id, @NotNull List<Integer> parents, long timestamp) {
        if (parents == null) {
            GraphCommitImpl.$$$reportNull$$$0(5);
        }
        if (parents.size() == 1) {
            return new IntGraphCommit.SingleParent(timestamp, id, parents.get(0));
        }
        return new IntGraphCommit.MultiParent(timestamp, id, Ints.toArray(parents));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/GraphCommitImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/GraphCommitImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIntCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

