/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u + uvec3(36u, 32u, 88u)) => uvec3(36u, 32u, 88u)
 * (0u + uvec3(59u, 77u, 68u)) => uvec3(59u, 77u, 68u)
 * (6u + uvec3(36u, 32u, 88u)) => uvec3(42u, 38u, 94u)
 * (6u + uvec3(59u, 77u, 68u)) => uvec3(65u, 83u, 74u)
 * (12u + uvec3(36u, 32u, 88u)) => uvec3(48u, 44u, 100u)
 * (12u + uvec3(59u, 77u, 68u)) => uvec3(71u, 89u, 80u)
 * (32u + uvec3(36u, 32u, 88u)) => uvec3(68u, 64u, 120u)
 * (32u + uvec3(59u, 77u, 68u)) => uvec3(91u, 109u, 100u)
 * (74u + uvec3(36u, 32u, 88u)) => uvec3(110u, 106u, 162u)
 * (74u + uvec3(59u, 77u, 68u)) => uvec3(133u, 151u, 142u)
 */
#version 130

void main()
{
  float[all(equal((0u + uvec3(36u, 32u, 88u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array0;
  float[all(equal((0u + uvec3(59u, 77u, 68u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array1;
  float[all(equal((6u + uvec3(36u, 32u, 88u)), uvec3(42u, 38u, 94u))) ? 1 : -1] array2;
  float[all(equal((6u + uvec3(59u, 77u, 68u)), uvec3(65u, 83u, 74u))) ? 1 : -1] array3;
  float[all(equal((12u + uvec3(36u, 32u, 88u)), uvec3(48u, 44u, 100u))) ? 1 : -1] array4;
  float[all(equal((12u + uvec3(59u, 77u, 68u)), uvec3(71u, 89u, 80u))) ? 1 : -1] array5;
  float[all(equal((32u + uvec3(36u, 32u, 88u)), uvec3(68u, 64u, 120u))) ? 1 : -1] array6;
  float[all(equal((32u + uvec3(59u, 77u, 68u)), uvec3(91u, 109u, 100u))) ? 1 : -1] array7;
  float[all(equal((74u + uvec3(36u, 32u, 88u)), uvec3(110u, 106u, 162u))) ? 1 : -1] array8;
  float[all(equal((74u + uvec3(59u, 77u, 68u)), uvec3(133u, 151u, 142u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
